<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAdGroupsResponse StructType
 * @subpackage Structs
 */
class AddAdGroupsResponse extends AbstractStructBase
{
    /**
     * The AdGroupIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNullableOflong
     */
    public $AdGroupIds;
    /**
     * The InheritedBidStrategyTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $InheritedBidStrategyTypes;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for AddAdGroupsResponse
     * @uses AddAdGroupsResponse::setAdGroupIds()
     * @uses AddAdGroupsResponse::setInheritedBidStrategyTypes()
     * @uses AddAdGroupsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfNullableOflong $adGroupIds
     * @param \ArrayType\ArrayOfstring $inheritedBidStrategyTypes
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfNullableOflong $adGroupIds = null, \ArrayType\ArrayOfstring $inheritedBidStrategyTypes = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setAdGroupIds($adGroupIds)
            ->setInheritedBidStrategyTypes($inheritedBidStrategyTypes)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get AdGroupIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNullableOflong|null
     */
    public function getAdGroupIds()
    {
        return isset($this->AdGroupIds) ? $this->AdGroupIds : null;
    }
    /**
     * Set AdGroupIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNullableOflong $adGroupIds
     * @return \StructType\AddAdGroupsResponse
     */
    public function setAdGroupIds(\ArrayType\ArrayOfNullableOflong $adGroupIds = null)
    {
        if (is_null($adGroupIds) || (is_array($adGroupIds) && empty($adGroupIds))) {
            unset($this->AdGroupIds);
        } else {
            $this->AdGroupIds = $adGroupIds;
        }
        return $this;
    }
    /**
     * Get InheritedBidStrategyTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getInheritedBidStrategyTypes()
    {
        return isset($this->InheritedBidStrategyTypes) ? $this->InheritedBidStrategyTypes : null;
    }
    /**
     * Set InheritedBidStrategyTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $inheritedBidStrategyTypes
     * @return \StructType\AddAdGroupsResponse
     */
    public function setInheritedBidStrategyTypes(\ArrayType\ArrayOfstring $inheritedBidStrategyTypes = null)
    {
        if (is_null($inheritedBidStrategyTypes) || (is_array($inheritedBidStrategyTypes) && empty($inheritedBidStrategyTypes))) {
            unset($this->InheritedBidStrategyTypes);
        } else {
            $this->InheritedBidStrategyTypes = $inheritedBidStrategyTypes;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\AddAdGroupsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
