<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAdGroupCriterionsResponse StructType
 * @subpackage Structs
 */
class AddAdGroupCriterionsResponse extends AbstractStructBase
{
    /**
     * The AdGroupCriterionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNullableOflong
     */
    public $AdGroupCriterionIds;
    /**
     * The NestedPartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchErrorCollection
     */
    public $NestedPartialErrors;
    /**
     * Constructor method for AddAdGroupCriterionsResponse
     * @uses AddAdGroupCriterionsResponse::setAdGroupCriterionIds()
     * @uses AddAdGroupCriterionsResponse::setNestedPartialErrors()
     * @param \ArrayType\ArrayOfNullableOflong $adGroupCriterionIds
     * @param \ArrayType\ArrayOfBatchErrorCollection $nestedPartialErrors
     */
    public function __construct(\ArrayType\ArrayOfNullableOflong $adGroupCriterionIds = null, \ArrayType\ArrayOfBatchErrorCollection $nestedPartialErrors = null)
    {
        $this
            ->setAdGroupCriterionIds($adGroupCriterionIds)
            ->setNestedPartialErrors($nestedPartialErrors);
    }
    /**
     * Get AdGroupCriterionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNullableOflong|null
     */
    public function getAdGroupCriterionIds()
    {
        return isset($this->AdGroupCriterionIds) ? $this->AdGroupCriterionIds : null;
    }
    /**
     * Set AdGroupCriterionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNullableOflong $adGroupCriterionIds
     * @return \StructType\AddAdGroupCriterionsResponse
     */
    public function setAdGroupCriterionIds(\ArrayType\ArrayOfNullableOflong $adGroupCriterionIds = null)
    {
        if (is_null($adGroupCriterionIds) || (is_array($adGroupCriterionIds) && empty($adGroupCriterionIds))) {
            unset($this->AdGroupCriterionIds);
        } else {
            $this->AdGroupCriterionIds = $adGroupCriterionIds;
        }
        return $this;
    }
    /**
     * Get NestedPartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchErrorCollection|null
     */
    public function getNestedPartialErrors()
    {
        return isset($this->NestedPartialErrors) ? $this->NestedPartialErrors : null;
    }
    /**
     * Set NestedPartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchErrorCollection $nestedPartialErrors
     * @return \StructType\AddAdGroupCriterionsResponse
     */
    public function setNestedPartialErrors(\ArrayType\ArrayOfBatchErrorCollection $nestedPartialErrors = null)
    {
        if (is_null($nestedPartialErrors) || (is_array($nestedPartialErrors) && empty($nestedPartialErrors))) {
            unset($this->NestedPartialErrors);
        } else {
            $this->NestedPartialErrors = $nestedPartialErrors;
        }
        return $this;
    }
}
