<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdGroupCriterionAction StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdGroupCriterionAction
 * @subpackage Structs
 */
class AdGroupCriterionAction extends AbstractStructBase
{
    /**
     * The Action
     * @var string
     */
    public $Action;
    /**
     * The AdGroupCriterion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdGroupCriterion
     */
    public $AdGroupCriterion;
    /**
     * Constructor method for AdGroupCriterionAction
     * @uses AdGroupCriterionAction::setAction()
     * @uses AdGroupCriterionAction::setAdGroupCriterion()
     * @param string $action
     * @param \StructType\AdGroupCriterion $adGroupCriterion
     */
    public function __construct($action = null, \StructType\AdGroupCriterion $adGroupCriterion = null)
    {
        $this
            ->setAction($action)
            ->setAdGroupCriterion($adGroupCriterion);
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\ItemAction::valueIsValid()
     * @uses \EnumType\ItemAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\AdGroupCriterionAction
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \EnumType\ItemAction::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get AdGroupCriterion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdGroupCriterion|null
     */
    public function getAdGroupCriterion()
    {
        return isset($this->AdGroupCriterion) ? $this->AdGroupCriterion : null;
    }
    /**
     * Set AdGroupCriterion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdGroupCriterion $adGroupCriterion
     * @return \StructType\AdGroupCriterionAction
     */
    public function setAdGroupCriterion(\StructType\AdGroupCriterion $adGroupCriterion = null)
    {
        if (is_null($adGroupCriterion) || (is_array($adGroupCriterion) && empty($adGroupCriterion))) {
            unset($this->AdGroupCriterion);
        } else {
            $this->AdGroupCriterion = $adGroupCriterion;
        }
        return $this;
    }
}
