<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdExtensionIdToEntityIdAssociation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdExtensionIdToEntityIdAssociation
 * @subpackage Structs
 */
class AdExtensionIdToEntityIdAssociation extends AbstractStructBase
{
    /**
     * The AdExtensionId
     * @var int
     */
    public $AdExtensionId;
    /**
     * The EntityId
     * @var int
     */
    public $EntityId;
    /**
     * Constructor method for AdExtensionIdToEntityIdAssociation
     * @uses AdExtensionIdToEntityIdAssociation::setAdExtensionId()
     * @uses AdExtensionIdToEntityIdAssociation::setEntityId()
     * @param int $adExtensionId
     * @param int $entityId
     */
    public function __construct($adExtensionId = null, $entityId = null)
    {
        $this
            ->setAdExtensionId($adExtensionId)
            ->setEntityId($entityId);
    }
    /**
     * Get AdExtensionId value
     * @return int|null
     */
    public function getAdExtensionId()
    {
        return $this->AdExtensionId;
    }
    /**
     * Set AdExtensionId value
     * @param int $adExtensionId
     * @return \StructType\AdExtensionIdToEntityIdAssociation
     */
    public function setAdExtensionId($adExtensionId = null)
    {
        // validation for constraint: int
        if (!is_null($adExtensionId) && !(is_int($adExtensionId) || ctype_digit($adExtensionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adExtensionId, true), gettype($adExtensionId)), __LINE__);
        }
        $this->AdExtensionId = $adExtensionId;
        return $this;
    }
    /**
     * Get EntityId value
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param int $entityId
     * @return \StructType\AdExtensionIdToEntityIdAssociation
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
}
