<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdExtensionEditorialReasonCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdExtensionEditorialReasonCollection
 * @subpackage Structs
 */
class AdExtensionEditorialReasonCollection extends AbstractStructBase
{
    /**
     * The AdExtensionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdExtensionId;
    /**
     * The Reasons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdExtensionEditorialReason
     */
    public $Reasons;
    /**
     * Constructor method for AdExtensionEditorialReasonCollection
     * @uses AdExtensionEditorialReasonCollection::setAdExtensionId()
     * @uses AdExtensionEditorialReasonCollection::setReasons()
     * @param int $adExtensionId
     * @param \ArrayType\ArrayOfAdExtensionEditorialReason $reasons
     */
    public function __construct($adExtensionId = null, \ArrayType\ArrayOfAdExtensionEditorialReason $reasons = null)
    {
        $this
            ->setAdExtensionId($adExtensionId)
            ->setReasons($reasons);
    }
    /**
     * Get AdExtensionId value
     * @return int|null
     */
    public function getAdExtensionId()
    {
        return $this->AdExtensionId;
    }
    /**
     * Set AdExtensionId value
     * @param int $adExtensionId
     * @return \StructType\AdExtensionEditorialReasonCollection
     */
    public function setAdExtensionId($adExtensionId = null)
    {
        // validation for constraint: int
        if (!is_null($adExtensionId) && !(is_int($adExtensionId) || ctype_digit($adExtensionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adExtensionId, true), gettype($adExtensionId)), __LINE__);
        }
        $this->AdExtensionId = $adExtensionId;
        return $this;
    }
    /**
     * Get Reasons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdExtensionEditorialReason|null
     */
    public function getReasons()
    {
        return isset($this->Reasons) ? $this->Reasons : null;
    }
    /**
     * Set Reasons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdExtensionEditorialReason $reasons
     * @return \StructType\AdExtensionEditorialReasonCollection
     */
    public function setReasons(\ArrayType\ArrayOfAdExtensionEditorialReason $reasons = null)
    {
        if (is_null($reasons) || (is_array($reasons) && empty($reasons))) {
            unset($this->Reasons);
        } else {
            $this->Reasons = $reasons;
        }
        return $this;
    }
}
