<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdExtensionAssociation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdExtensionAssociation
 * @subpackage Structs
 */
class AdExtensionAssociation extends AbstractStructBase
{
    /**
     * The AdExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdExtension
     */
    public $AdExtension;
    /**
     * The AssociationType
     * @var string
     */
    public $AssociationType;
    /**
     * The EditorialStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EditorialStatus;
    /**
     * The EntityId
     * @var int
     */
    public $EntityId;
    /**
     * Constructor method for AdExtensionAssociation
     * @uses AdExtensionAssociation::setAdExtension()
     * @uses AdExtensionAssociation::setAssociationType()
     * @uses AdExtensionAssociation::setEditorialStatus()
     * @uses AdExtensionAssociation::setEntityId()
     * @param \StructType\AdExtension $adExtension
     * @param string $associationType
     * @param string $editorialStatus
     * @param int $entityId
     */
    public function __construct(\StructType\AdExtension $adExtension = null, $associationType = null, $editorialStatus = null, $entityId = null)
    {
        $this
            ->setAdExtension($adExtension)
            ->setAssociationType($associationType)
            ->setEditorialStatus($editorialStatus)
            ->setEntityId($entityId);
    }
    /**
     * Get AdExtension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdExtension|null
     */
    public function getAdExtension()
    {
        return isset($this->AdExtension) ? $this->AdExtension : null;
    }
    /**
     * Set AdExtension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdExtension $adExtension
     * @return \StructType\AdExtensionAssociation
     */
    public function setAdExtension(\StructType\AdExtension $adExtension = null)
    {
        if (is_null($adExtension) || (is_array($adExtension) && empty($adExtension))) {
            unset($this->AdExtension);
        } else {
            $this->AdExtension = $adExtension;
        }
        return $this;
    }
    /**
     * Get AssociationType value
     * @return string|null
     */
    public function getAssociationType()
    {
        return $this->AssociationType;
    }
    /**
     * Set AssociationType value
     * @uses \EnumType\AssociationType::valueIsValid()
     * @uses \EnumType\AssociationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $associationType
     * @return \StructType\AdExtensionAssociation
     */
    public function setAssociationType($associationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AssociationType::valueIsValid($associationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AssociationType', is_array($associationType) ? implode(', ', $associationType) : var_export($associationType, true), implode(', ', \EnumType\AssociationType::getValidValues())), __LINE__);
        }
        $this->AssociationType = $associationType;
        return $this;
    }
    /**
     * Get EditorialStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEditorialStatus()
    {
        return isset($this->EditorialStatus) ? $this->EditorialStatus : null;
    }
    /**
     * Set EditorialStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdExtensionEditorialStatus::valueIsValid()
     * @uses \EnumType\AdExtensionEditorialStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $editorialStatus
     * @return \StructType\AdExtensionAssociation
     */
    public function setEditorialStatus($editorialStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdExtensionEditorialStatus::valueIsValid($editorialStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdExtensionEditorialStatus', is_array($editorialStatus) ? implode(', ', $editorialStatus) : var_export($editorialStatus, true), implode(', ', \EnumType\AdExtensionEditorialStatus::getValidValues())), __LINE__);
        }
        if (is_null($editorialStatus) || (is_array($editorialStatus) && empty($editorialStatus))) {
            unset($this->EditorialStatus);
        } else {
            $this->EditorialStatus = $editorialStatus;
        }
        return $this;
    }
    /**
     * Get EntityId value
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param int $entityId
     * @return \StructType\AdExtensionAssociation
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
}
