<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdExtension StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdExtension
 * @subpackage Structs
 */
class AdExtension extends AbstractStructBase
{
    /**
     * The DevicePreference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DevicePreference;
    /**
     * The ForwardCompatibilityMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValuePairOfstringstring
     */
    public $ForwardCompatibilityMap;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The Scheduling
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Schedule
     */
    public $Scheduling;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Version;
    /**
     * Constructor method for AdExtension
     * @uses AdExtension::setDevicePreference()
     * @uses AdExtension::setForwardCompatibilityMap()
     * @uses AdExtension::setId()
     * @uses AdExtension::setScheduling()
     * @uses AdExtension::setStatus()
     * @uses AdExtension::setType()
     * @uses AdExtension::setVersion()
     * @param int $devicePreference
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @param int $id
     * @param \StructType\Schedule $scheduling
     * @param string $status
     * @param string $type
     * @param int $version
     */
    public function __construct($devicePreference = null, \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null, $id = null, \StructType\Schedule $scheduling = null, $status = null, $type = null, $version = null)
    {
        $this
            ->setDevicePreference($devicePreference)
            ->setForwardCompatibilityMap($forwardCompatibilityMap)
            ->setId($id)
            ->setScheduling($scheduling)
            ->setStatus($status)
            ->setType($type)
            ->setVersion($version);
    }
    /**
     * Get DevicePreference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDevicePreference()
    {
        return isset($this->DevicePreference) ? $this->DevicePreference : null;
    }
    /**
     * Set DevicePreference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $devicePreference
     * @return \StructType\AdExtension
     */
    public function setDevicePreference($devicePreference = null)
    {
        // validation for constraint: int
        if (!is_null($devicePreference) && !(is_int($devicePreference) || ctype_digit($devicePreference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($devicePreference, true), gettype($devicePreference)), __LINE__);
        }
        if (is_null($devicePreference) || (is_array($devicePreference) && empty($devicePreference))) {
            unset($this->DevicePreference);
        } else {
            $this->DevicePreference = $devicePreference;
        }
        return $this;
    }
    /**
     * Get ForwardCompatibilityMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValuePairOfstringstring|null
     */
    public function getForwardCompatibilityMap()
    {
        return isset($this->ForwardCompatibilityMap) ? $this->ForwardCompatibilityMap : null;
    }
    /**
     * Set ForwardCompatibilityMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @return \StructType\AdExtension
     */
    public function setForwardCompatibilityMap(\ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null)
    {
        if (is_null($forwardCompatibilityMap) || (is_array($forwardCompatibilityMap) && empty($forwardCompatibilityMap))) {
            unset($this->ForwardCompatibilityMap);
        } else {
            $this->ForwardCompatibilityMap = $forwardCompatibilityMap;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\AdExtension
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Scheduling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Schedule|null
     */
    public function getScheduling()
    {
        return isset($this->Scheduling) ? $this->Scheduling : null;
    }
    /**
     * Set Scheduling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Schedule $scheduling
     * @return \StructType\AdExtension
     */
    public function setScheduling(\StructType\Schedule $scheduling = null)
    {
        if (is_null($scheduling) || (is_array($scheduling) && empty($scheduling))) {
            unset($this->Scheduling);
        } else {
            $this->Scheduling = $scheduling;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdExtensionStatus::valueIsValid()
     * @uses \EnumType\AdExtensionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\AdExtension
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdExtensionStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdExtensionStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\AdExtensionStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \StructType\AdExtension
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get Version value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVersion()
    {
        return isset($this->Version) ? $this->Version : null;
    }
    /**
     * Set Version value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $version
     * @return \StructType\AdExtension
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        if (is_null($version) || (is_array($version) && empty($version))) {
            unset($this->Version);
        } else {
            $this->Version = $version;
        }
        return $this;
    }
}
