<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the ApplicationToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $applicationToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationToken($applicationToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApplicationToken', $applicationToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the AuthenticationToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $authenticationToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticationToken($authenticationToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticationToken', $authenticationToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the CustomerAccountId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $customerAccountId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCustomerAccountId($customerAccountId, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CustomerAccountId', $customerAccountId, $mustUnderstand, $actor);
    }
    /**
     * Sets the CustomerId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $customerId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCustomerId($customerId, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CustomerId', $customerId, $mustUnderstand, $actor);
    }
    /**
     * Sets the DeveloperToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $developerToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDeveloperToken($developerToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DeveloperToken', $developerToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the Password SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $password
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPassword($password, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Password', $password, $mustUnderstand, $actor);
    }
    /**
     * Sets the UserName SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $userName
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserName($userName, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserName', $userName, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetCampaignsByAccountId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCampaignsByAccountIdRequest $parameters
     * @return \StructType\GetCampaignsByAccountIdResponse|bool
     */
    public function GetCampaignsByAccountId(\StructType\GetCampaignsByAccountIdRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCampaignsByAccountId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCampaignsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCampaignsByIdsRequest $parameters
     * @return \StructType\GetCampaignsByIdsResponse|bool
     */
    public function GetCampaignsByIds(\StructType\GetCampaignsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCampaignsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNegativeSitesByCampaignIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNegativeSitesByCampaignIdsRequest $parameters
     * @return \StructType\GetNegativeSitesByCampaignIdsResponse|bool
     */
    public function GetNegativeSitesByCampaignIds(\StructType\GetNegativeSitesByCampaignIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNegativeSitesByCampaignIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConfigValue
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetConfigValueRequest $parameters
     * @return \StructType\GetConfigValueResponse|bool
     */
    public function GetConfigValue(\StructType\GetConfigValueRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetConfigValue($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBSCCountries
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBSCCountriesRequest $parameters
     * @return \StructType\GetBSCCountriesResponse|bool
     */
    public function GetBSCCountries(\StructType\GetBSCCountriesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBSCCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdGroupsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdGroupsByIdsRequest $parameters
     * @return \StructType\GetAdGroupsByIdsResponse|bool
     */
    public function GetAdGroupsByIds(\StructType\GetAdGroupsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdGroupsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdGroupsByCampaignId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdGroupsByCampaignIdRequest $parameters
     * @return \StructType\GetAdGroupsByCampaignIdResponse|bool
     */
    public function GetAdGroupsByCampaignId(\StructType\GetAdGroupsByCampaignIdRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdGroupsByCampaignId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNegativeSitesByAdGroupIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNegativeSitesByAdGroupIdsRequest $parameters
     * @return \StructType\GetNegativeSitesByAdGroupIdsResponse|bool
     */
    public function GetNegativeSitesByAdGroupIds(\StructType\GetNegativeSitesByAdGroupIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNegativeSitesByAdGroupIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGeoLocationsFileUrl
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGeoLocationsFileUrlRequest $parameters
     * @return \StructType\GetGeoLocationsFileUrlResponse|bool
     */
    public function GetGeoLocationsFileUrl(\StructType\GetGeoLocationsFileUrlRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGeoLocationsFileUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdsByEditorialStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdsByEditorialStatusRequest $parameters
     * @return \StructType\GetAdsByEditorialStatusResponse|bool
     */
    public function GetAdsByEditorialStatus(\StructType\GetAdsByEditorialStatusRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdsByEditorialStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdsByIdsRequest $parameters
     * @return \StructType\GetAdsByIdsResponse|bool
     */
    public function GetAdsByIds(\StructType\GetAdsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdsByAdGroupId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdsByAdGroupIdRequest $parameters
     * @return \StructType\GetAdsByAdGroupIdResponse|bool
     */
    public function GetAdsByAdGroupId(\StructType\GetAdsByAdGroupIdRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdsByAdGroupId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetKeywordsByEditorialStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKeywordsByEditorialStatusRequest $parameters
     * @return \StructType\GetKeywordsByEditorialStatusResponse|bool
     */
    public function GetKeywordsByEditorialStatus(\StructType\GetKeywordsByEditorialStatusRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetKeywordsByEditorialStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetKeywordsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKeywordsByIdsRequest $parameters
     * @return \StructType\GetKeywordsByIdsResponse|bool
     */
    public function GetKeywordsByIds(\StructType\GetKeywordsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetKeywordsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetKeywordsByAdGroupId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKeywordsByAdGroupIdRequest $parameters
     * @return \StructType\GetKeywordsByAdGroupIdResponse|bool
     */
    public function GetKeywordsByAdGroupId(\StructType\GetKeywordsByAdGroupIdRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetKeywordsByAdGroupId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEditorialReasonsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEditorialReasonsByIdsRequest $parameters
     * @return \StructType\GetEditorialReasonsByIdsResponse|bool
     */
    public function GetEditorialReasonsByIds(\StructType\GetEditorialReasonsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEditorialReasonsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountMigrationStatuses
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountMigrationStatusesRequest $parameters
     * @return \StructType\GetAccountMigrationStatusesResponse|bool
     */
    public function GetAccountMigrationStatuses(\StructType\GetAccountMigrationStatusesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccountMigrationStatuses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountPropertiesRequest $parameters
     * @return \StructType\GetAccountPropertiesResponse|bool
     */
    public function GetAccountProperties(\StructType\GetAccountPropertiesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccountProperties($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdExtensionsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdExtensionsByIdsRequest $parameters
     * @return \StructType\GetAdExtensionsByIdsResponse|bool
     */
    public function GetAdExtensionsByIds(\StructType\GetAdExtensionsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdExtensionsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdExtensionsEditorialReasons
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdExtensionsEditorialReasonsRequest $parameters
     * @return \StructType\GetAdExtensionsEditorialReasonsResponse|bool
     */
    public function GetAdExtensionsEditorialReasons(\StructType\GetAdExtensionsEditorialReasonsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdExtensionsEditorialReasons($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdExtensionsAssociations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdExtensionsAssociationsRequest $parameters
     * @return \StructType\GetAdExtensionsAssociationsResponse|bool
     */
    public function GetAdExtensionsAssociations(\StructType\GetAdExtensionsAssociationsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdExtensionsAssociations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdExtensionIdsByAccountId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdExtensionIdsByAccountIdRequest $parameters
     * @return \StructType\GetAdExtensionIdsByAccountIdResponse|bool
     */
    public function GetAdExtensionIdsByAccountId(\StructType\GetAdExtensionIdsByAccountIdRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdExtensionIdsByAccountId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMediaMetaDataByAccountId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMediaMetaDataByAccountIdRequest $parameters
     * @return \StructType\GetMediaMetaDataByAccountIdResponse|bool
     */
    public function GetMediaMetaDataByAccountId(\StructType\GetMediaMetaDataByAccountIdRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMediaMetaDataByAccountId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMediaMetaDataByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMediaMetaDataByIdsRequest $parameters
     * @return \StructType\GetMediaMetaDataByIdsResponse|bool
     */
    public function GetMediaMetaDataByIds(\StructType\GetMediaMetaDataByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMediaMetaDataByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMediaAssociations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMediaAssociationsRequest $parameters
     * @return \StructType\GetMediaAssociationsResponse|bool
     */
    public function GetMediaAssociations(\StructType\GetMediaAssociationsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMediaAssociations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdGroupCriterionsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdGroupCriterionsByIdsRequest $parameters
     * @return \StructType\GetAdGroupCriterionsByIdsResponse|bool
     */
    public function GetAdGroupCriterionsByIds(\StructType\GetAdGroupCriterionsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdGroupCriterionsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBMCStoresByCustomerId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBMCStoresByCustomerIdRequest $parameters
     * @return \StructType\GetBMCStoresByCustomerIdResponse|bool
     */
    public function GetBMCStoresByCustomerId(\StructType\GetBMCStoresByCustomerIdRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBMCStoresByCustomerId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNegativeKeywordsByEntityIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNegativeKeywordsByEntityIdsRequest $parameters
     * @return \StructType\GetNegativeKeywordsByEntityIdsResponse|bool
     */
    public function GetNegativeKeywordsByEntityIds(\StructType\GetNegativeKeywordsByEntityIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNegativeKeywordsByEntityIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSharedEntitiesByAccountId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSharedEntitiesByAccountIdRequest $parameters
     * @return \StructType\GetSharedEntitiesByAccountIdResponse|bool
     */
    public function GetSharedEntitiesByAccountId(\StructType\GetSharedEntitiesByAccountIdRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSharedEntitiesByAccountId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSharedEntities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSharedEntitiesRequest $parameters
     * @return \StructType\GetSharedEntitiesResponse|bool
     */
    public function GetSharedEntities(\StructType\GetSharedEntitiesRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSharedEntities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListItemsBySharedList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListItemsBySharedListRequest $parameters
     * @return \StructType\GetListItemsBySharedListResponse|bool
     */
    public function GetListItemsBySharedList(\StructType\GetListItemsBySharedListRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListItemsBySharedList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetSharedEntityAssociationsBySharedEntityIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSharedEntityAssociationsBySharedEntityIdsRequest $parameters
     * @return \StructType\GetSharedEntityAssociationsBySharedEntityIdsResponse|bool
     */
    public function GetSharedEntityAssociationsBySharedEntityIds(\StructType\GetSharedEntityAssociationsBySharedEntityIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSharedEntityAssociationsBySharedEntityIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetSharedEntityAssociationsByEntityIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSharedEntityAssociationsByEntityIdsRequest $parameters
     * @return \StructType\GetSharedEntityAssociationsByEntityIdsResponse|bool
     */
    public function GetSharedEntityAssociationsByEntityIds(\StructType\GetSharedEntityAssociationsByEntityIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSharedEntityAssociationsByEntityIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCampaignSizesByAccountId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCampaignSizesByAccountIdRequest $parameters
     * @return \StructType\GetCampaignSizesByAccountIdResponse|bool
     */
    public function GetCampaignSizesByAccountId(\StructType\GetCampaignSizesByAccountIdRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCampaignSizesByAccountId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCampaignCriterionsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCampaignCriterionsByIdsRequest $parameters
     * @return \StructType\GetCampaignCriterionsByIdsResponse|bool
     */
    public function GetCampaignCriterionsByIds(\StructType\GetCampaignCriterionsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCampaignCriterionsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBudgetsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBudgetsByIdsRequest $parameters
     * @return \StructType\GetBudgetsByIdsResponse|bool
     */
    public function GetBudgetsByIds(\StructType\GetBudgetsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBudgetsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCampaignIdsByBudgetIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCampaignIdsByBudgetIdsRequest $parameters
     * @return \StructType\GetCampaignIdsByBudgetIdsResponse|bool
     */
    public function GetCampaignIdsByBudgetIds(\StructType\GetCampaignIdsByBudgetIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCampaignIdsByBudgetIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBidStrategiesByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBidStrategiesByIdsRequest $parameters
     * @return \StructType\GetBidStrategiesByIdsResponse|bool
     */
    public function GetBidStrategiesByIds(\StructType\GetBidStrategiesByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBidStrategiesByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCampaignIdsByBidStrategyIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCampaignIdsByBidStrategyIdsRequest $parameters
     * @return \StructType\GetCampaignIdsByBidStrategyIdsResponse|bool
     */
    public function GetCampaignIdsByBidStrategyIds(\StructType\GetCampaignIdsByBidStrategyIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCampaignIdsByBidStrategyIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAudiencesByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAudiencesByIdsRequest $parameters
     * @return \StructType\GetAudiencesByIdsResponse|bool
     */
    public function GetAudiencesByIds(\StructType\GetAudiencesByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAudiencesByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUetTagsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUetTagsByIdsRequest $parameters
     * @return \StructType\GetUetTagsByIdsResponse|bool
     */
    public function GetUetTagsByIds(\StructType\GetUetTagsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUetTagsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConversionGoalsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetConversionGoalsByIdsRequest $parameters
     * @return \StructType\GetConversionGoalsByIdsResponse|bool
     */
    public function GetConversionGoalsByIds(\StructType\GetConversionGoalsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetConversionGoalsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConversionGoalsByTagIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetConversionGoalsByTagIdsRequest $parameters
     * @return \StructType\GetConversionGoalsByTagIdsResponse|bool
     */
    public function GetConversionGoalsByTagIds(\StructType\GetConversionGoalsByTagIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetConversionGoalsByTagIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLabelsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLabelsByIdsRequest $parameters
     * @return \StructType\GetLabelsByIdsResponse|bool
     */
    public function GetLabelsByIds(\StructType\GetLabelsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLabelsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLabelAssociationsByEntityIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLabelAssociationsByEntityIdsRequest $parameters
     * @return \StructType\GetLabelAssociationsByEntityIdsResponse|bool
     */
    public function GetLabelAssociationsByEntityIds(\StructType\GetLabelAssociationsByEntityIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLabelAssociationsByEntityIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLabelAssociationsByLabelIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLabelAssociationsByLabelIdsRequest $parameters
     * @return \StructType\GetLabelAssociationsByLabelIdsResponse|bool
     */
    public function GetLabelAssociationsByLabelIds(\StructType\GetLabelAssociationsByLabelIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLabelAssociationsByLabelIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExperimentsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExperimentsByIdsRequest $parameters
     * @return \StructType\GetExperimentsByIdsResponse|bool
     */
    public function GetExperimentsByIds(\StructType\GetExperimentsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExperimentsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProfileDataFileUrl
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProfileDataFileUrlRequest $parameters
     * @return \StructType\GetProfileDataFileUrlResponse|bool
     */
    public function GetProfileDataFileUrl(\StructType\GetProfileDataFileUrlRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProfileDataFileUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFileImportUploadUrl
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFileImportUploadUrlRequest $parameters
     * @return \StructType\GetFileImportUploadUrlResponse|bool
     */
    public function GetFileImportUploadUrl(\StructType\GetFileImportUploadUrlRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFileImportUploadUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetImportResults
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImportResultsRequest $parameters
     * @return \StructType\GetImportResultsResponse|bool
     */
    public function GetImportResults(\StructType\GetImportResultsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetImportResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetImportJobsByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImportJobsByIdsRequest $parameters
     * @return \StructType\GetImportJobsByIdsResponse|bool
     */
    public function GetImportJobsByIds(\StructType\GetImportJobsByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetImportJobsByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetImportEntityIdsMapping
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImportEntityIdsMappingRequest $parameters
     * @return \StructType\GetImportEntityIdsMappingResponse|bool
     */
    public function GetImportEntityIdsMapping(\StructType\GetImportEntityIdsMappingRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetImportEntityIdsMapping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVideosByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVideosByIdsRequest $parameters
     * @return \StructType\GetVideosByIdsResponse|bool
     */
    public function GetVideosByIds(\StructType\GetVideosByIdsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVideosByIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountMigrationStatusesResponse|\StructType\GetAccountPropertiesResponse|\StructType\GetAdExtensionIdsByAccountIdResponse|\StructType\GetAdExtensionsAssociationsResponse|\StructType\GetAdExtensionsByIdsResponse|\StructType\GetAdExtensionsEditorialReasonsResponse|\StructType\GetAdGroupCriterionsByIdsResponse|\StructType\GetAdGroupsByCampaignIdResponse|\StructType\GetAdGroupsByIdsResponse|\StructType\GetAdsByAdGroupIdResponse|\StructType\GetAdsByEditorialStatusResponse|\StructType\GetAdsByIdsResponse|\StructType\GetAudiencesByIdsResponse|\StructType\GetBidStrategiesByIdsResponse|\StructType\GetBMCStoresByCustomerIdResponse|\StructType\GetBSCCountriesResponse|\StructType\GetBudgetsByIdsResponse|\StructType\GetCampaignCriterionsByIdsResponse|\StructType\GetCampaignIdsByBidStrategyIdsResponse|\StructType\GetCampaignIdsByBudgetIdsResponse|\StructType\GetCampaignsByAccountIdResponse|\StructType\GetCampaignsByIdsResponse|\StructType\GetCampaignSizesByAccountIdResponse|\StructType\GetConfigValueResponse|\StructType\GetConversionGoalsByIdsResponse|\StructType\GetConversionGoalsByTagIdsResponse|\StructType\GetEditorialReasonsByIdsResponse|\StructType\GetExperimentsByIdsResponse|\StructType\GetFileImportUploadUrlResponse|\StructType\GetGeoLocationsFileUrlResponse|\StructType\GetImportEntityIdsMappingResponse|\StructType\GetImportJobsByIdsResponse|\StructType\GetImportResultsResponse|\StructType\GetKeywordsByAdGroupIdResponse|\StructType\GetKeywordsByEditorialStatusResponse|\StructType\GetKeywordsByIdsResponse|\StructType\GetLabelAssociationsByEntityIdsResponse|\StructType\GetLabelAssociationsByLabelIdsResponse|\StructType\GetLabelsByIdsResponse|\StructType\GetListItemsBySharedListResponse|\StructType\GetMediaAssociationsResponse|\StructType\GetMediaMetaDataByAccountIdResponse|\StructType\GetMediaMetaDataByIdsResponse|\StructType\GetNegativeKeywordsByEntityIdsResponse|\StructType\GetNegativeSitesByAdGroupIdsResponse|\StructType\GetNegativeSitesByCampaignIdsResponse|\StructType\GetProfileDataFileUrlResponse|\StructType\GetSharedEntitiesByAccountIdResponse|\StructType\GetSharedEntitiesResponse|\StructType\GetSharedEntityAssociationsByEntityIdsResponse|\StructType\GetSharedEntityAssociationsBySharedEntityIdsResponse|\StructType\GetUetTagsByIdsResponse|\StructType\GetVideosByIdsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
