<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Appeal ServiceType
 * @subpackage Services
 */
class Appeal extends AbstractSoapClientBase
{
    /**
     * Sets the ApplicationToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $applicationToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationToken($applicationToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApplicationToken', $applicationToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the AuthenticationToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $authenticationToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticationToken($authenticationToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticationToken', $authenticationToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the CustomerAccountId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $customerAccountId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCustomerAccountId($customerAccountId, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CustomerAccountId', $customerAccountId, $mustUnderstand, $actor);
    }
    /**
     * Sets the CustomerId SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $customerId
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCustomerId($customerId, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CustomerId', $customerId, $mustUnderstand, $actor);
    }
    /**
     * Sets the DeveloperToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $developerToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDeveloperToken($developerToken, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DeveloperToken', $developerToken, $mustUnderstand, $actor);
    }
    /**
     * Sets the Password SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $password
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPassword($password, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Password', $password, $mustUnderstand, $actor);
    }
    /**
     * Sets the UserName SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $userName
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserName($userName, $nameSpace = 'https://bingads.microsoft.com/CampaignManagement/v13', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserName', $userName, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AppealEditorialRejections
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationToken, AuthenticationToken, CustomerAccountId, CustomerId, DeveloperToken, Password, UserName
     * - SOAPHeaderNamespaces: https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13, https://bingads.microsoft.com/CampaignManagement/v13
     * - SOAPHeaderTypes: string, string, string, string, string, string, string
     * - SOAPHeaders: required, required, required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AppealEditorialRejectionsRequest $parameters
     * @return \StructType\AppealEditorialRejectionsResponse|bool
     */
    public function AppealEditorialRejections(\StructType\AppealEditorialRejectionsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AppealEditorialRejections($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AppealEditorialRejectionsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
