<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVideo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfVideo
 * @subpackage Arrays
 */
class ArrayOfVideo extends AbstractStructArrayBase
{
    /**
     * The Video
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Video[]
     */
    public $Video;
    /**
     * Constructor method for ArrayOfVideo
     * @uses ArrayOfVideo::setVideo()
     * @param \StructType\Video[] $video
     */
    public function __construct(array $video = array())
    {
        $this
            ->setVideo($video);
    }
    /**
     * Get Video value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Video[]|null
     */
    public function getVideo()
    {
        return isset($this->Video) ? $this->Video : null;
    }
    /**
     * This method is responsible for validating the values passed to the setVideo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVideo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVideoForArrayConstraintsFromSetVideo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfVideoVideoItem) {
            // validation for constraint: itemType
            if (!$arrayOfVideoVideoItem instanceof \StructType\Video) {
                $invalidValues[] = is_object($arrayOfVideoVideoItem) ? get_class($arrayOfVideoVideoItem) : sprintf('%s(%s)', gettype($arrayOfVideoVideoItem), var_export($arrayOfVideoVideoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Video property can only contain items of type \StructType\Video, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Video value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Video[] $video
     * @return \ArrayType\ArrayOfVideo
     */
    public function setVideo(array $video = array())
    {
        // validation for constraint: array
        if ('' !== ($videoArrayErrorMessage = self::validateVideoForArrayConstraintsFromSetVideo($video))) {
            throw new \InvalidArgumentException($videoArrayErrorMessage, __LINE__);
        }
        if (is_null($video) || (is_array($video) && empty($video))) {
            unset($this->Video);
        } else {
            $this->Video = $video;
        }
        return $this;
    }
    /**
     * Add item to Video value
     * @throws \InvalidArgumentException
     * @param \StructType\Video $item
     * @return \ArrayType\ArrayOfVideo
     */
    public function addToVideo(\StructType\Video $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Video) {
            throw new \InvalidArgumentException(sprintf('The Video property can only contain items of type \StructType\Video, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Video[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Video|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Video|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Video|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Video|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Video|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Video
     */
    public function getAttributeName()
    {
        return 'Video';
    }
}
