<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSharedEntity ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSharedEntity
 * @subpackage Arrays
 */
class ArrayOfSharedEntity extends AbstractStructArrayBase
{
    /**
     * The SharedEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SharedEntity[]
     */
    public $SharedEntity;
    /**
     * Constructor method for ArrayOfSharedEntity
     * @uses ArrayOfSharedEntity::setSharedEntity()
     * @param \StructType\SharedEntity[] $sharedEntity
     */
    public function __construct(array $sharedEntity = array())
    {
        $this
            ->setSharedEntity($sharedEntity);
    }
    /**
     * Get SharedEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SharedEntity[]|null
     */
    public function getSharedEntity()
    {
        return isset($this->SharedEntity) ? $this->SharedEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSharedEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSharedEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSharedEntityForArrayConstraintsFromSetSharedEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSharedEntitySharedEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfSharedEntitySharedEntityItem instanceof \StructType\SharedEntity) {
                $invalidValues[] = is_object($arrayOfSharedEntitySharedEntityItem) ? get_class($arrayOfSharedEntitySharedEntityItem) : sprintf('%s(%s)', gettype($arrayOfSharedEntitySharedEntityItem), var_export($arrayOfSharedEntitySharedEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SharedEntity property can only contain items of type \StructType\SharedEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SharedEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SharedEntity[] $sharedEntity
     * @return \ArrayType\ArrayOfSharedEntity
     */
    public function setSharedEntity(array $sharedEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($sharedEntityArrayErrorMessage = self::validateSharedEntityForArrayConstraintsFromSetSharedEntity($sharedEntity))) {
            throw new \InvalidArgumentException($sharedEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($sharedEntity) || (is_array($sharedEntity) && empty($sharedEntity))) {
            unset($this->SharedEntity);
        } else {
            $this->SharedEntity = $sharedEntity;
        }
        return $this;
    }
    /**
     * Add item to SharedEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\SharedEntity $item
     * @return \ArrayType\ArrayOfSharedEntity
     */
    public function addToSharedEntity(\StructType\SharedEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SharedEntity) {
            throw new \InvalidArgumentException(sprintf('The SharedEntity property can only contain items of type \StructType\SharedEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SharedEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SharedEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SharedEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SharedEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SharedEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SharedEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SharedEntity
     */
    public function getAttributeName()
    {
        return 'SharedEntity';
    }
}
