<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRuleItemGroup ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRuleItemGroup
 * @subpackage Arrays
 */
class ArrayOfRuleItemGroup extends AbstractStructArrayBase
{
    /**
     * The RuleItemGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RuleItemGroup[]
     */
    public $RuleItemGroup;
    /**
     * Constructor method for ArrayOfRuleItemGroup
     * @uses ArrayOfRuleItemGroup::setRuleItemGroup()
     * @param \StructType\RuleItemGroup[] $ruleItemGroup
     */
    public function __construct(array $ruleItemGroup = array())
    {
        $this
            ->setRuleItemGroup($ruleItemGroup);
    }
    /**
     * Get RuleItemGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RuleItemGroup[]|null
     */
    public function getRuleItemGroup()
    {
        return isset($this->RuleItemGroup) ? $this->RuleItemGroup : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRuleItemGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRuleItemGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRuleItemGroupForArrayConstraintsFromSetRuleItemGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRuleItemGroupRuleItemGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfRuleItemGroupRuleItemGroupItem instanceof \StructType\RuleItemGroup) {
                $invalidValues[] = is_object($arrayOfRuleItemGroupRuleItemGroupItem) ? get_class($arrayOfRuleItemGroupRuleItemGroupItem) : sprintf('%s(%s)', gettype($arrayOfRuleItemGroupRuleItemGroupItem), var_export($arrayOfRuleItemGroupRuleItemGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RuleItemGroup property can only contain items of type \StructType\RuleItemGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RuleItemGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RuleItemGroup[] $ruleItemGroup
     * @return \ArrayType\ArrayOfRuleItemGroup
     */
    public function setRuleItemGroup(array $ruleItemGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($ruleItemGroupArrayErrorMessage = self::validateRuleItemGroupForArrayConstraintsFromSetRuleItemGroup($ruleItemGroup))) {
            throw new \InvalidArgumentException($ruleItemGroupArrayErrorMessage, __LINE__);
        }
        if (is_null($ruleItemGroup) || (is_array($ruleItemGroup) && empty($ruleItemGroup))) {
            unset($this->RuleItemGroup);
        } else {
            $this->RuleItemGroup = $ruleItemGroup;
        }
        return $this;
    }
    /**
     * Add item to RuleItemGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\RuleItemGroup $item
     * @return \ArrayType\ArrayOfRuleItemGroup
     */
    public function addToRuleItemGroup(\StructType\RuleItemGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RuleItemGroup) {
            throw new \InvalidArgumentException(sprintf('The RuleItemGroup property can only contain items of type \StructType\RuleItemGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RuleItemGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RuleItemGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RuleItemGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RuleItemGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RuleItemGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RuleItemGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RuleItemGroup
     */
    public function getAttributeName()
    {
        return 'RuleItemGroup';
    }
}
