<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRuleItem ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRuleItem
 * @subpackage Arrays
 */
class ArrayOfRuleItem extends AbstractStructArrayBase
{
    /**
     * The RuleItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RuleItem[]
     */
    public $RuleItem;
    /**
     * Constructor method for ArrayOfRuleItem
     * @uses ArrayOfRuleItem::setRuleItem()
     * @param \StructType\RuleItem[] $ruleItem
     */
    public function __construct(array $ruleItem = array())
    {
        $this
            ->setRuleItem($ruleItem);
    }
    /**
     * Get RuleItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RuleItem[]|null
     */
    public function getRuleItem()
    {
        return isset($this->RuleItem) ? $this->RuleItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRuleItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRuleItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRuleItemForArrayConstraintsFromSetRuleItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRuleItemRuleItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfRuleItemRuleItemItem instanceof \StructType\RuleItem) {
                $invalidValues[] = is_object($arrayOfRuleItemRuleItemItem) ? get_class($arrayOfRuleItemRuleItemItem) : sprintf('%s(%s)', gettype($arrayOfRuleItemRuleItemItem), var_export($arrayOfRuleItemRuleItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RuleItem property can only contain items of type \StructType\RuleItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RuleItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RuleItem[] $ruleItem
     * @return \ArrayType\ArrayOfRuleItem
     */
    public function setRuleItem(array $ruleItem = array())
    {
        // validation for constraint: array
        if ('' !== ($ruleItemArrayErrorMessage = self::validateRuleItemForArrayConstraintsFromSetRuleItem($ruleItem))) {
            throw new \InvalidArgumentException($ruleItemArrayErrorMessage, __LINE__);
        }
        if (is_null($ruleItem) || (is_array($ruleItem) && empty($ruleItem))) {
            unset($this->RuleItem);
        } else {
            $this->RuleItem = $ruleItem;
        }
        return $this;
    }
    /**
     * Add item to RuleItem value
     * @throws \InvalidArgumentException
     * @param \StructType\RuleItem $item
     * @return \ArrayType\ArrayOfRuleItem
     */
    public function addToRuleItem(\StructType\RuleItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RuleItem) {
            throw new \InvalidArgumentException(sprintf('The RuleItem property can only contain items of type \StructType\RuleItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RuleItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RuleItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RuleItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RuleItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RuleItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RuleItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RuleItem
     */
    public function getAttributeName()
    {
        return 'RuleItem';
    }
}
