<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNullableOflong ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfNullableOflong
 * @subpackage Arrays
 */
class ArrayOfNullableOflong extends AbstractStructArrayBase
{
    /**
     * The long
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $long;
    /**
     * Constructor method for ArrayOfNullableOflong
     * @uses ArrayOfNullableOflong::setLong()
     * @param int[] $long
     */
    public function __construct(array $long = array())
    {
        $this
            ->setLong($long);
    }
    /**
     * Get long value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getLong()
    {
        return isset($this->long) ? $this->long : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLong method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLong method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLongForArrayConstraintsFromSetLong(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNullableOflongLongItem) {
            // validation for constraint: itemType
            if (!(is_int($arrayOfNullableOflongLongItem) || ctype_digit($arrayOfNullableOflongLongItem))) {
                $invalidValues[] = is_object($arrayOfNullableOflongLongItem) ? get_class($arrayOfNullableOflongLongItem) : sprintf('%s(%s)', gettype($arrayOfNullableOflongLongItem), var_export($arrayOfNullableOflongLongItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The long property can only contain items of type long, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set long value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $long
     * @return \ArrayType\ArrayOfNullableOflong
     */
    public function setLong(array $long = array())
    {
        // validation for constraint: array
        if ('' !== ($longArrayErrorMessage = self::validateLongForArrayConstraintsFromSetLong($long))) {
            throw new \InvalidArgumentException($longArrayErrorMessage, __LINE__);
        }
        if (is_null($long) || (is_array($long) && empty($long))) {
            unset($this->long);
        } else {
            $this->long = $long;
        }
        return $this;
    }
    /**
     * Add item to long value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \ArrayType\ArrayOfNullableOflong
     */
    public function addToLong($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The long property can only contain items of type long, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->long[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return int|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return int|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return int|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return int|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return int|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string long
     */
    public function getAttributeName()
    {
        return 'long';
    }
}
