<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMediaRepresentation ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMediaRepresentation
 * @subpackage Arrays
 */
class ArrayOfMediaRepresentation extends AbstractStructArrayBase
{
    /**
     * The MediaRepresentation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MediaRepresentation[]
     */
    public $MediaRepresentation;
    /**
     * Constructor method for ArrayOfMediaRepresentation
     * @uses ArrayOfMediaRepresentation::setMediaRepresentation()
     * @param \StructType\MediaRepresentation[] $mediaRepresentation
     */
    public function __construct(array $mediaRepresentation = array())
    {
        $this
            ->setMediaRepresentation($mediaRepresentation);
    }
    /**
     * Get MediaRepresentation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MediaRepresentation[]|null
     */
    public function getMediaRepresentation()
    {
        return isset($this->MediaRepresentation) ? $this->MediaRepresentation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMediaRepresentation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaRepresentation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaRepresentationForArrayConstraintsFromSetMediaRepresentation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMediaRepresentationMediaRepresentationItem) {
            // validation for constraint: itemType
            if (!$arrayOfMediaRepresentationMediaRepresentationItem instanceof \StructType\MediaRepresentation) {
                $invalidValues[] = is_object($arrayOfMediaRepresentationMediaRepresentationItem) ? get_class($arrayOfMediaRepresentationMediaRepresentationItem) : sprintf('%s(%s)', gettype($arrayOfMediaRepresentationMediaRepresentationItem), var_export($arrayOfMediaRepresentationMediaRepresentationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MediaRepresentation property can only contain items of type \StructType\MediaRepresentation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MediaRepresentation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MediaRepresentation[] $mediaRepresentation
     * @return \ArrayType\ArrayOfMediaRepresentation
     */
    public function setMediaRepresentation(array $mediaRepresentation = array())
    {
        // validation for constraint: array
        if ('' !== ($mediaRepresentationArrayErrorMessage = self::validateMediaRepresentationForArrayConstraintsFromSetMediaRepresentation($mediaRepresentation))) {
            throw new \InvalidArgumentException($mediaRepresentationArrayErrorMessage, __LINE__);
        }
        if (is_null($mediaRepresentation) || (is_array($mediaRepresentation) && empty($mediaRepresentation))) {
            unset($this->MediaRepresentation);
        } else {
            $this->MediaRepresentation = $mediaRepresentation;
        }
        return $this;
    }
    /**
     * Add item to MediaRepresentation value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaRepresentation $item
     * @return \ArrayType\ArrayOfMediaRepresentation
     */
    public function addToMediaRepresentation(\StructType\MediaRepresentation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaRepresentation) {
            throw new \InvalidArgumentException(sprintf('The MediaRepresentation property can only contain items of type \StructType\MediaRepresentation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MediaRepresentation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MediaRepresentation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MediaRepresentation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MediaRepresentation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MediaRepresentation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MediaRepresentation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MediaRepresentation
     */
    public function getAttributeName()
    {
        return 'MediaRepresentation';
    }
}
