<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMediaAssociation ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMediaAssociation
 * @subpackage Arrays
 */
class ArrayOfMediaAssociation extends AbstractStructArrayBase
{
    /**
     * The MediaAssociation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MediaAssociation[]
     */
    public $MediaAssociation;
    /**
     * Constructor method for ArrayOfMediaAssociation
     * @uses ArrayOfMediaAssociation::setMediaAssociation()
     * @param \StructType\MediaAssociation[] $mediaAssociation
     */
    public function __construct(array $mediaAssociation = array())
    {
        $this
            ->setMediaAssociation($mediaAssociation);
    }
    /**
     * Get MediaAssociation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MediaAssociation[]|null
     */
    public function getMediaAssociation()
    {
        return isset($this->MediaAssociation) ? $this->MediaAssociation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMediaAssociation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaAssociation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaAssociationForArrayConstraintsFromSetMediaAssociation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMediaAssociationMediaAssociationItem) {
            // validation for constraint: itemType
            if (!$arrayOfMediaAssociationMediaAssociationItem instanceof \StructType\MediaAssociation) {
                $invalidValues[] = is_object($arrayOfMediaAssociationMediaAssociationItem) ? get_class($arrayOfMediaAssociationMediaAssociationItem) : sprintf('%s(%s)', gettype($arrayOfMediaAssociationMediaAssociationItem), var_export($arrayOfMediaAssociationMediaAssociationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MediaAssociation property can only contain items of type \StructType\MediaAssociation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MediaAssociation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MediaAssociation[] $mediaAssociation
     * @return \ArrayType\ArrayOfMediaAssociation
     */
    public function setMediaAssociation(array $mediaAssociation = array())
    {
        // validation for constraint: array
        if ('' !== ($mediaAssociationArrayErrorMessage = self::validateMediaAssociationForArrayConstraintsFromSetMediaAssociation($mediaAssociation))) {
            throw new \InvalidArgumentException($mediaAssociationArrayErrorMessage, __LINE__);
        }
        if (is_null($mediaAssociation) || (is_array($mediaAssociation) && empty($mediaAssociation))) {
            unset($this->MediaAssociation);
        } else {
            $this->MediaAssociation = $mediaAssociation;
        }
        return $this;
    }
    /**
     * Add item to MediaAssociation value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaAssociation $item
     * @return \ArrayType\ArrayOfMediaAssociation
     */
    public function addToMediaAssociation(\StructType\MediaAssociation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaAssociation) {
            throw new \InvalidArgumentException(sprintf('The MediaAssociation property can only contain items of type \StructType\MediaAssociation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MediaAssociation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MediaAssociation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MediaAssociation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MediaAssociation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MediaAssociation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MediaAssociation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MediaAssociation
     */
    public function getAttributeName()
    {
        return 'MediaAssociation';
    }
}
