<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAudience ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAudience
 * @subpackage Arrays
 */
class ArrayOfAudience extends AbstractStructArrayBase
{
    /**
     * The Audience
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Audience[]
     */
    public $Audience;
    /**
     * Constructor method for ArrayOfAudience
     * @uses ArrayOfAudience::setAudience()
     * @param \StructType\Audience[] $audience
     */
    public function __construct(array $audience = array())
    {
        $this
            ->setAudience($audience);
    }
    /**
     * Get Audience value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Audience[]|null
     */
    public function getAudience()
    {
        return isset($this->Audience) ? $this->Audience : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAudience method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAudience method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAudienceForArrayConstraintsFromSetAudience(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAudienceAudienceItem) {
            // validation for constraint: itemType
            if (!$arrayOfAudienceAudienceItem instanceof \StructType\Audience) {
                $invalidValues[] = is_object($arrayOfAudienceAudienceItem) ? get_class($arrayOfAudienceAudienceItem) : sprintf('%s(%s)', gettype($arrayOfAudienceAudienceItem), var_export($arrayOfAudienceAudienceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Audience property can only contain items of type \StructType\Audience, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Audience value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Audience[] $audience
     * @return \ArrayType\ArrayOfAudience
     */
    public function setAudience(array $audience = array())
    {
        // validation for constraint: array
        if ('' !== ($audienceArrayErrorMessage = self::validateAudienceForArrayConstraintsFromSetAudience($audience))) {
            throw new \InvalidArgumentException($audienceArrayErrorMessage, __LINE__);
        }
        if (is_null($audience) || (is_array($audience) && empty($audience))) {
            unset($this->Audience);
        } else {
            $this->Audience = $audience;
        }
        return $this;
    }
    /**
     * Add item to Audience value
     * @throws \InvalidArgumentException
     * @param \StructType\Audience $item
     * @return \ArrayType\ArrayOfAudience
     */
    public function addToAudience(\StructType\Audience $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audience) {
            throw new \InvalidArgumentException(sprintf('The Audience property can only contain items of type \StructType\Audience, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Audience[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Audience|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Audience|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Audience|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Audience|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Audience|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Audience
     */
    public function getAttributeName()
    {
        return 'Audience';
    }
}
