<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAdType ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAdType
 * @subpackage Arrays
 */
class ArrayOfAdType extends AbstractStructArrayBase
{
    /**
     * The AdType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AdType;
    /**
     * Constructor method for ArrayOfAdType
     * @uses ArrayOfAdType::setAdType()
     * @param string[] $adType
     */
    public function __construct(array $adType = array())
    {
        $this
            ->setAdType($adType);
    }
    /**
     * Get AdType value
     * @return string[]|null
     */
    public function getAdType()
    {
        return $this->AdType;
    }
    /**
     * This method is responsible for validating the values passed to the setAdType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdTypeForArrayConstraintsFromSetAdType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAdTypeAdTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdType::valueIsValid($arrayOfAdTypeAdTypeItem)) {
                $invalidValues[] = is_object($arrayOfAdTypeAdTypeItem) ? get_class($arrayOfAdTypeAdTypeItem) : sprintf('%s(%s)', gettype($arrayOfAdTypeAdTypeItem), var_export($arrayOfAdTypeAdTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdType value
     * @uses \EnumType\AdType::valueIsValid()
     * @uses \EnumType\AdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adType
     * @return \ArrayType\ArrayOfAdType
     */
    public function setAdType(array $adType = array())
    {
        // validation for constraint: array
        if ('' !== ($adTypeArrayErrorMessage = self::validateAdTypeForArrayConstraintsFromSetAdType($adType))) {
            throw new \InvalidArgumentException($adTypeArrayErrorMessage, __LINE__);
        }
        $this->AdType = $adType;
        return $this;
    }
    /**
     * Add item to AdType value
     * @uses \EnumType\AdType::valueIsValid()
     * @uses \EnumType\AdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfAdType
     */
    public function addToAdType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\AdType::getValidValues())), __LINE__);
        }
        $this->AdType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\AdType::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfAdType
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\AdType::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AdType
     */
    public function getAttributeName()
    {
        return 'AdType';
    }
}
