<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAd ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAd
 * @subpackage Arrays
 */
class ArrayOfAd extends AbstractStructArrayBase
{
    /**
     * The Ad
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Ad[]
     */
    public $Ad;
    /**
     * Constructor method for ArrayOfAd
     * @uses ArrayOfAd::setAd()
     * @param \StructType\Ad[] $ad
     */
    public function __construct(array $ad = array())
    {
        $this
            ->setAd($ad);
    }
    /**
     * Get Ad value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Ad[]|null
     */
    public function getAd()
    {
        return isset($this->Ad) ? $this->Ad : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAd method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdForArrayConstraintsFromSetAd(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAdAdItem) {
            // validation for constraint: itemType
            if (!$arrayOfAdAdItem instanceof \StructType\Ad) {
                $invalidValues[] = is_object($arrayOfAdAdItem) ? get_class($arrayOfAdAdItem) : sprintf('%s(%s)', gettype($arrayOfAdAdItem), var_export($arrayOfAdAdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ad property can only contain items of type \StructType\Ad, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ad value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Ad[] $ad
     * @return \ArrayType\ArrayOfAd
     */
    public function setAd(array $ad = array())
    {
        // validation for constraint: array
        if ('' !== ($adArrayErrorMessage = self::validateAdForArrayConstraintsFromSetAd($ad))) {
            throw new \InvalidArgumentException($adArrayErrorMessage, __LINE__);
        }
        if (is_null($ad) || (is_array($ad) && empty($ad))) {
            unset($this->Ad);
        } else {
            $this->Ad = $ad;
        }
        return $this;
    }
    /**
     * Add item to Ad value
     * @throws \InvalidArgumentException
     * @param \StructType\Ad $item
     * @return \ArrayType\ArrayOfAd
     */
    public function addToAd(\StructType\Ad $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Ad) {
            throw new \InvalidArgumentException(sprintf('The Ad property can only contain items of type \StructType\Ad, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ad[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Ad|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Ad|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Ad|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Ad|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Ad|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Ad
     */
    public function getAttributeName()
    {
        return 'Ad';
    }
}
