<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountPropertyName ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAccountPropertyName
 * @subpackage Arrays
 */
class ArrayOfAccountPropertyName extends AbstractStructArrayBase
{
    /**
     * The AccountPropertyName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AccountPropertyName;
    /**
     * Constructor method for ArrayOfAccountPropertyName
     * @uses ArrayOfAccountPropertyName::setAccountPropertyName()
     * @param string[] $accountPropertyName
     */
    public function __construct(array $accountPropertyName = array())
    {
        $this
            ->setAccountPropertyName($accountPropertyName);
    }
    /**
     * Get AccountPropertyName value
     * @return string[]|null
     */
    public function getAccountPropertyName()
    {
        return $this->AccountPropertyName;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountPropertyName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountPropertyName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountPropertyNameForArrayConstraintsFromSetAccountPropertyName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAccountPropertyNameAccountPropertyNameItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AccountPropertyName::valueIsValid($arrayOfAccountPropertyNameAccountPropertyNameItem)) {
                $invalidValues[] = is_object($arrayOfAccountPropertyNameAccountPropertyNameItem) ? get_class($arrayOfAccountPropertyNameAccountPropertyNameItem) : sprintf('%s(%s)', gettype($arrayOfAccountPropertyNameAccountPropertyNameItem), var_export($arrayOfAccountPropertyNameAccountPropertyNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountPropertyName', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AccountPropertyName::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountPropertyName value
     * @uses \EnumType\AccountPropertyName::valueIsValid()
     * @uses \EnumType\AccountPropertyName::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accountPropertyName
     * @return \ArrayType\ArrayOfAccountPropertyName
     */
    public function setAccountPropertyName(array $accountPropertyName = array())
    {
        // validation for constraint: array
        if ('' !== ($accountPropertyNameArrayErrorMessage = self::validateAccountPropertyNameForArrayConstraintsFromSetAccountPropertyName($accountPropertyName))) {
            throw new \InvalidArgumentException($accountPropertyNameArrayErrorMessage, __LINE__);
        }
        $this->AccountPropertyName = $accountPropertyName;
        return $this;
    }
    /**
     * Add item to AccountPropertyName value
     * @uses \EnumType\AccountPropertyName::valueIsValid()
     * @uses \EnumType\AccountPropertyName::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfAccountPropertyName
     */
    public function addToAccountPropertyName($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountPropertyName::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountPropertyName', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\AccountPropertyName::getValidValues())), __LINE__);
        }
        $this->AccountPropertyName[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\AccountPropertyName::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfAccountPropertyName
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountPropertyName::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountPropertyName', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\AccountPropertyName::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountPropertyName
     */
    public function getAttributeName()
    {
        return 'AccountPropertyName';
    }
}
