<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountProperty ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAccountProperty
 * @subpackage Arrays
 */
class ArrayOfAccountProperty extends AbstractStructArrayBase
{
    /**
     * The AccountProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountProperty[]
     */
    public $AccountProperty;
    /**
     * Constructor method for ArrayOfAccountProperty
     * @uses ArrayOfAccountProperty::setAccountProperty()
     * @param \StructType\AccountProperty[] $accountProperty
     */
    public function __construct(array $accountProperty = array())
    {
        $this
            ->setAccountProperty($accountProperty);
    }
    /**
     * Get AccountProperty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountProperty[]|null
     */
    public function getAccountProperty()
    {
        return isset($this->AccountProperty) ? $this->AccountProperty : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountPropertyForArrayConstraintsFromSetAccountProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAccountPropertyAccountPropertyItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountPropertyAccountPropertyItem instanceof \StructType\AccountProperty) {
                $invalidValues[] = is_object($arrayOfAccountPropertyAccountPropertyItem) ? get_class($arrayOfAccountPropertyAccountPropertyItem) : sprintf('%s(%s)', gettype($arrayOfAccountPropertyAccountPropertyItem), var_export($arrayOfAccountPropertyAccountPropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountProperty property can only contain items of type \StructType\AccountProperty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountProperty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountProperty[] $accountProperty
     * @return \ArrayType\ArrayOfAccountProperty
     */
    public function setAccountProperty(array $accountProperty = array())
    {
        // validation for constraint: array
        if ('' !== ($accountPropertyArrayErrorMessage = self::validateAccountPropertyForArrayConstraintsFromSetAccountProperty($accountProperty))) {
            throw new \InvalidArgumentException($accountPropertyArrayErrorMessage, __LINE__);
        }
        if (is_null($accountProperty) || (is_array($accountProperty) && empty($accountProperty))) {
            unset($this->AccountProperty);
        } else {
            $this->AccountProperty = $accountProperty;
        }
        return $this;
    }
    /**
     * Add item to AccountProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountProperty $item
     * @return \ArrayType\ArrayOfAccountProperty
     */
    public function addToAccountProperty(\StructType\AccountProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountProperty) {
            throw new \InvalidArgumentException(sprintf('The AccountProperty property can only contain items of type \StructType\AccountProperty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AccountProperty[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AccountProperty|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AccountProperty|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AccountProperty|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AccountProperty|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AccountProperty|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountProperty
     */
    public function getAttributeName()
    {
        return 'AccountProperty';
    }
}
