<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebpageCondition StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebpageCondition
 * @subpackage Structs
 */
class WebpageCondition extends AbstractStructBase
{
    /**
     * The Argument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Argument;
    /**
     * The Operand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Operand;
    /**
     * Constructor method for WebpageCondition
     * @uses WebpageCondition::setArgument()
     * @uses WebpageCondition::setOperand()
     * @param string $argument
     * @param string $operand
     */
    public function __construct($argument = null, $operand = null)
    {
        $this
            ->setArgument($argument)
            ->setOperand($operand);
    }
    /**
     * Get Argument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArgument()
    {
        return isset($this->Argument) ? $this->Argument : null;
    }
    /**
     * Set Argument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $argument
     * @return \StructType\WebpageCondition
     */
    public function setArgument($argument = null)
    {
        // validation for constraint: string
        if (!is_null($argument) && !is_string($argument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($argument, true), gettype($argument)), __LINE__);
        }
        if (is_null($argument) || (is_array($argument) && empty($argument))) {
            unset($this->Argument);
        } else {
            $this->Argument = $argument;
        }
        return $this;
    }
    /**
     * Get Operand value
     * @return string|null
     */
    public function getOperand()
    {
        return $this->Operand;
    }
    /**
     * Set Operand value
     * @uses \EnumType\WebpageConditionOperand::valueIsValid()
     * @uses \EnumType\WebpageConditionOperand::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operand
     * @return \StructType\WebpageCondition
     */
    public function setOperand($operand = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebpageConditionOperand::valueIsValid($operand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WebpageConditionOperand', is_array($operand) ? implode(', ', $operand) : var_export($operand, true), implode(', ', \EnumType\WebpageConditionOperand::getValidValues())), __LINE__);
        }
        $this->Operand = $operand;
        return $this;
    }
}
