<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoAsset StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VideoAsset
 * @subpackage Structs
 */
class VideoAsset extends Asset
{
    /**
     * The SubType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubType;
    /**
     * The ThumbnailImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ImageAsset
     */
    public $ThumbnailImage;
    /**
     * Constructor method for VideoAsset
     * @uses VideoAsset::setSubType()
     * @uses VideoAsset::setThumbnailImage()
     * @param string $subType
     * @param \StructType\ImageAsset $thumbnailImage
     */
    public function __construct($subType = null, \StructType\ImageAsset $thumbnailImage = null)
    {
        $this
            ->setSubType($subType)
            ->setThumbnailImage($thumbnailImage);
    }
    /**
     * Get SubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubType()
    {
        return isset($this->SubType) ? $this->SubType : null;
    }
    /**
     * Set SubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subType
     * @return \StructType\VideoAsset
     */
    public function setSubType($subType = null)
    {
        // validation for constraint: string
        if (!is_null($subType) && !is_string($subType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subType, true), gettype($subType)), __LINE__);
        }
        if (is_null($subType) || (is_array($subType) && empty($subType))) {
            unset($this->SubType);
        } else {
            $this->SubType = $subType;
        }
        return $this;
    }
    /**
     * Get ThumbnailImage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ImageAsset|null
     */
    public function getThumbnailImage()
    {
        return isset($this->ThumbnailImage) ? $this->ThumbnailImage : null;
    }
    /**
     * Set ThumbnailImage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ImageAsset $thumbnailImage
     * @return \StructType\VideoAsset
     */
    public function setThumbnailImage(\StructType\ImageAsset $thumbnailImage = null)
    {
        if (is_null($thumbnailImage) || (is_array($thumbnailImage) && empty($thumbnailImage))) {
            unset($this->ThumbnailImage);
        } else {
            $this->ThumbnailImage = $thumbnailImage;
        }
        return $this;
    }
}
