<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoAdExtension StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VideoAdExtension
 * @subpackage Structs
 */
class VideoAdExtension extends AdExtension
{
    /**
     * The ActionText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionText;
    /**
     * The AlternativeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternativeText;
    /**
     * The DisplayText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayText;
    /**
     * The FinalAppUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAppUrl
     */
    public $FinalAppUrls;
    /**
     * The FinalMobileUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FinalMobileUrls;
    /**
     * The FinalUrlSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FinalUrlSuffix;
    /**
     * The FinalUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FinalUrls;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ThumbnailId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ThumbnailId;
    /**
     * The ThumbnailUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThumbnailUrl;
    /**
     * The TrackingUrlTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingUrlTemplate;
    /**
     * The UrlCustomParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomParameters
     */
    public $UrlCustomParameters;
    /**
     * The VideoId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VideoId;
    /**
     * Constructor method for VideoAdExtension
     * @uses VideoAdExtension::setActionText()
     * @uses VideoAdExtension::setAlternativeText()
     * @uses VideoAdExtension::setDisplayText()
     * @uses VideoAdExtension::setFinalAppUrls()
     * @uses VideoAdExtension::setFinalMobileUrls()
     * @uses VideoAdExtension::setFinalUrlSuffix()
     * @uses VideoAdExtension::setFinalUrls()
     * @uses VideoAdExtension::setName()
     * @uses VideoAdExtension::setThumbnailId()
     * @uses VideoAdExtension::setThumbnailUrl()
     * @uses VideoAdExtension::setTrackingUrlTemplate()
     * @uses VideoAdExtension::setUrlCustomParameters()
     * @uses VideoAdExtension::setVideoId()
     * @param string $actionText
     * @param string $alternativeText
     * @param string $displayText
     * @param \ArrayType\ArrayOfAppUrl $finalAppUrls
     * @param \ArrayType\ArrayOfstring $finalMobileUrls
     * @param string $finalUrlSuffix
     * @param \ArrayType\ArrayOfstring $finalUrls
     * @param string $name
     * @param int $thumbnailId
     * @param string $thumbnailUrl
     * @param string $trackingUrlTemplate
     * @param \StructType\CustomParameters $urlCustomParameters
     * @param int $videoId
     */
    public function __construct($actionText = null, $alternativeText = null, $displayText = null, \ArrayType\ArrayOfAppUrl $finalAppUrls = null, \ArrayType\ArrayOfstring $finalMobileUrls = null, $finalUrlSuffix = null, \ArrayType\ArrayOfstring $finalUrls = null, $name = null, $thumbnailId = null, $thumbnailUrl = null, $trackingUrlTemplate = null, \StructType\CustomParameters $urlCustomParameters = null, $videoId = null)
    {
        $this
            ->setActionText($actionText)
            ->setAlternativeText($alternativeText)
            ->setDisplayText($displayText)
            ->setFinalAppUrls($finalAppUrls)
            ->setFinalMobileUrls($finalMobileUrls)
            ->setFinalUrlSuffix($finalUrlSuffix)
            ->setFinalUrls($finalUrls)
            ->setName($name)
            ->setThumbnailId($thumbnailId)
            ->setThumbnailUrl($thumbnailUrl)
            ->setTrackingUrlTemplate($trackingUrlTemplate)
            ->setUrlCustomParameters($urlCustomParameters)
            ->setVideoId($videoId);
    }
    /**
     * Get ActionText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionText()
    {
        return isset($this->ActionText) ? $this->ActionText : null;
    }
    /**
     * Set ActionText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionText
     * @return \StructType\VideoAdExtension
     */
    public function setActionText($actionText = null)
    {
        // validation for constraint: string
        if (!is_null($actionText) && !is_string($actionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionText, true), gettype($actionText)), __LINE__);
        }
        if (is_null($actionText) || (is_array($actionText) && empty($actionText))) {
            unset($this->ActionText);
        } else {
            $this->ActionText = $actionText;
        }
        return $this;
    }
    /**
     * Get AlternativeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternativeText()
    {
        return isset($this->AlternativeText) ? $this->AlternativeText : null;
    }
    /**
     * Set AlternativeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternativeText
     * @return \StructType\VideoAdExtension
     */
    public function setAlternativeText($alternativeText = null)
    {
        // validation for constraint: string
        if (!is_null($alternativeText) && !is_string($alternativeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternativeText, true), gettype($alternativeText)), __LINE__);
        }
        if (is_null($alternativeText) || (is_array($alternativeText) && empty($alternativeText))) {
            unset($this->AlternativeText);
        } else {
            $this->AlternativeText = $alternativeText;
        }
        return $this;
    }
    /**
     * Get DisplayText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayText()
    {
        return isset($this->DisplayText) ? $this->DisplayText : null;
    }
    /**
     * Set DisplayText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayText
     * @return \StructType\VideoAdExtension
     */
    public function setDisplayText($displayText = null)
    {
        // validation for constraint: string
        if (!is_null($displayText) && !is_string($displayText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayText, true), gettype($displayText)), __LINE__);
        }
        if (is_null($displayText) || (is_array($displayText) && empty($displayText))) {
            unset($this->DisplayText);
        } else {
            $this->DisplayText = $displayText;
        }
        return $this;
    }
    /**
     * Get FinalAppUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAppUrl|null
     */
    public function getFinalAppUrls()
    {
        return isset($this->FinalAppUrls) ? $this->FinalAppUrls : null;
    }
    /**
     * Set FinalAppUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAppUrl $finalAppUrls
     * @return \StructType\VideoAdExtension
     */
    public function setFinalAppUrls(\ArrayType\ArrayOfAppUrl $finalAppUrls = null)
    {
        if (is_null($finalAppUrls) || (is_array($finalAppUrls) && empty($finalAppUrls))) {
            unset($this->FinalAppUrls);
        } else {
            $this->FinalAppUrls = $finalAppUrls;
        }
        return $this;
    }
    /**
     * Get FinalMobileUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFinalMobileUrls()
    {
        return isset($this->FinalMobileUrls) ? $this->FinalMobileUrls : null;
    }
    /**
     * Set FinalMobileUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $finalMobileUrls
     * @return \StructType\VideoAdExtension
     */
    public function setFinalMobileUrls(\ArrayType\ArrayOfstring $finalMobileUrls = null)
    {
        if (is_null($finalMobileUrls) || (is_array($finalMobileUrls) && empty($finalMobileUrls))) {
            unset($this->FinalMobileUrls);
        } else {
            $this->FinalMobileUrls = $finalMobileUrls;
        }
        return $this;
    }
    /**
     * Get FinalUrlSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinalUrlSuffix()
    {
        return isset($this->FinalUrlSuffix) ? $this->FinalUrlSuffix : null;
    }
    /**
     * Set FinalUrlSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $finalUrlSuffix
     * @return \StructType\VideoAdExtension
     */
    public function setFinalUrlSuffix($finalUrlSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($finalUrlSuffix) && !is_string($finalUrlSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalUrlSuffix, true), gettype($finalUrlSuffix)), __LINE__);
        }
        if (is_null($finalUrlSuffix) || (is_array($finalUrlSuffix) && empty($finalUrlSuffix))) {
            unset($this->FinalUrlSuffix);
        } else {
            $this->FinalUrlSuffix = $finalUrlSuffix;
        }
        return $this;
    }
    /**
     * Get FinalUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFinalUrls()
    {
        return isset($this->FinalUrls) ? $this->FinalUrls : null;
    }
    /**
     * Set FinalUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $finalUrls
     * @return \StructType\VideoAdExtension
     */
    public function setFinalUrls(\ArrayType\ArrayOfstring $finalUrls = null)
    {
        if (is_null($finalUrls) || (is_array($finalUrls) && empty($finalUrls))) {
            unset($this->FinalUrls);
        } else {
            $this->FinalUrls = $finalUrls;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\VideoAdExtension
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ThumbnailId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getThumbnailId()
    {
        return isset($this->ThumbnailId) ? $this->ThumbnailId : null;
    }
    /**
     * Set ThumbnailId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $thumbnailId
     * @return \StructType\VideoAdExtension
     */
    public function setThumbnailId($thumbnailId = null)
    {
        // validation for constraint: int
        if (!is_null($thumbnailId) && !(is_int($thumbnailId) || ctype_digit($thumbnailId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($thumbnailId, true), gettype($thumbnailId)), __LINE__);
        }
        if (is_null($thumbnailId) || (is_array($thumbnailId) && empty($thumbnailId))) {
            unset($this->ThumbnailId);
        } else {
            $this->ThumbnailId = $thumbnailId;
        }
        return $this;
    }
    /**
     * Get ThumbnailUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThumbnailUrl()
    {
        return isset($this->ThumbnailUrl) ? $this->ThumbnailUrl : null;
    }
    /**
     * Set ThumbnailUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thumbnailUrl
     * @return \StructType\VideoAdExtension
     */
    public function setThumbnailUrl($thumbnailUrl = null)
    {
        // validation for constraint: string
        if (!is_null($thumbnailUrl) && !is_string($thumbnailUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thumbnailUrl, true), gettype($thumbnailUrl)), __LINE__);
        }
        if (is_null($thumbnailUrl) || (is_array($thumbnailUrl) && empty($thumbnailUrl))) {
            unset($this->ThumbnailUrl);
        } else {
            $this->ThumbnailUrl = $thumbnailUrl;
        }
        return $this;
    }
    /**
     * Get TrackingUrlTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingUrlTemplate()
    {
        return isset($this->TrackingUrlTemplate) ? $this->TrackingUrlTemplate : null;
    }
    /**
     * Set TrackingUrlTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackingUrlTemplate
     * @return \StructType\VideoAdExtension
     */
    public function setTrackingUrlTemplate($trackingUrlTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($trackingUrlTemplate) && !is_string($trackingUrlTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingUrlTemplate, true), gettype($trackingUrlTemplate)), __LINE__);
        }
        if (is_null($trackingUrlTemplate) || (is_array($trackingUrlTemplate) && empty($trackingUrlTemplate))) {
            unset($this->TrackingUrlTemplate);
        } else {
            $this->TrackingUrlTemplate = $trackingUrlTemplate;
        }
        return $this;
    }
    /**
     * Get UrlCustomParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomParameters|null
     */
    public function getUrlCustomParameters()
    {
        return isset($this->UrlCustomParameters) ? $this->UrlCustomParameters : null;
    }
    /**
     * Set UrlCustomParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomParameters $urlCustomParameters
     * @return \StructType\VideoAdExtension
     */
    public function setUrlCustomParameters(\StructType\CustomParameters $urlCustomParameters = null)
    {
        if (is_null($urlCustomParameters) || (is_array($urlCustomParameters) && empty($urlCustomParameters))) {
            unset($this->UrlCustomParameters);
        } else {
            $this->UrlCustomParameters = $urlCustomParameters;
        }
        return $this;
    }
    /**
     * Get VideoId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVideoId()
    {
        return isset($this->VideoId) ? $this->VideoId : null;
    }
    /**
     * Set VideoId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $videoId
     * @return \StructType\VideoAdExtension
     */
    public function setVideoId($videoId = null)
    {
        // validation for constraint: int
        if (!is_null($videoId) && !(is_int($videoId) || ctype_digit($videoId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($videoId, true), gettype($videoId)), __LINE__);
        }
        if (is_null($videoId) || (is_array($videoId) && empty($videoId))) {
            unset($this->VideoId);
        } else {
            $this->VideoId = $videoId;
        }
        return $this;
    }
}
