<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCampaignsRequest StructType
 * @subpackage Structs
 */
class UpdateCampaignsRequest extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The Campaigns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCampaign
     */
    public $Campaigns;
    /**
     * Constructor method for UpdateCampaignsRequest
     * @uses UpdateCampaignsRequest::setAccountId()
     * @uses UpdateCampaignsRequest::setCampaigns()
     * @param int $accountId
     * @param \ArrayType\ArrayOfCampaign $campaigns
     */
    public function __construct($accountId = null, \ArrayType\ArrayOfCampaign $campaigns = null)
    {
        $this
            ->setAccountId($accountId)
            ->setCampaigns($campaigns);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\UpdateCampaignsRequest
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get Campaigns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCampaign|null
     */
    public function getCampaigns()
    {
        return isset($this->Campaigns) ? $this->Campaigns : null;
    }
    /**
     * Set Campaigns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCampaign $campaigns
     * @return \StructType\UpdateCampaignsRequest
     */
    public function setCampaigns(\ArrayType\ArrayOfCampaign $campaigns = null)
    {
        if (is_null($campaigns) || (is_array($campaigns) && empty($campaigns))) {
            unset($this->Campaigns);
        } else {
            $this->Campaigns = $campaigns;
        }
        return $this;
    }
}
