<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UetTag StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UetTag
 * @subpackage Structs
 */
class UetTag extends AbstractStructBase
{
    /**
     * The CustomerShare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerShare
     */
    public $CustomerShare;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The TrackingNoScript
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingNoScript;
    /**
     * The TrackingScript
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingScript;
    /**
     * The TrackingStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingStatus;
    /**
     * Constructor method for UetTag
     * @uses UetTag::setCustomerShare()
     * @uses UetTag::setDescription()
     * @uses UetTag::setId()
     * @uses UetTag::setName()
     * @uses UetTag::setTrackingNoScript()
     * @uses UetTag::setTrackingScript()
     * @uses UetTag::setTrackingStatus()
     * @param \StructType\CustomerShare $customerShare
     * @param string $description
     * @param int $id
     * @param string $name
     * @param string $trackingNoScript
     * @param string $trackingScript
     * @param string $trackingStatus
     */
    public function __construct(\StructType\CustomerShare $customerShare = null, $description = null, $id = null, $name = null, $trackingNoScript = null, $trackingScript = null, $trackingStatus = null)
    {
        $this
            ->setCustomerShare($customerShare)
            ->setDescription($description)
            ->setId($id)
            ->setName($name)
            ->setTrackingNoScript($trackingNoScript)
            ->setTrackingScript($trackingScript)
            ->setTrackingStatus($trackingStatus);
    }
    /**
     * Get CustomerShare value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerShare|null
     */
    public function getCustomerShare()
    {
        return isset($this->CustomerShare) ? $this->CustomerShare : null;
    }
    /**
     * Set CustomerShare value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerShare $customerShare
     * @return \StructType\UetTag
     */
    public function setCustomerShare(\StructType\CustomerShare $customerShare = null)
    {
        if (is_null($customerShare) || (is_array($customerShare) && empty($customerShare))) {
            unset($this->CustomerShare);
        } else {
            $this->CustomerShare = $customerShare;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\UetTag
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\UetTag
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\UetTag
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get TrackingNoScript value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingNoScript()
    {
        return isset($this->TrackingNoScript) ? $this->TrackingNoScript : null;
    }
    /**
     * Set TrackingNoScript value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackingNoScript
     * @return \StructType\UetTag
     */
    public function setTrackingNoScript($trackingNoScript = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNoScript) && !is_string($trackingNoScript)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNoScript, true), gettype($trackingNoScript)), __LINE__);
        }
        if (is_null($trackingNoScript) || (is_array($trackingNoScript) && empty($trackingNoScript))) {
            unset($this->TrackingNoScript);
        } else {
            $this->TrackingNoScript = $trackingNoScript;
        }
        return $this;
    }
    /**
     * Get TrackingScript value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingScript()
    {
        return isset($this->TrackingScript) ? $this->TrackingScript : null;
    }
    /**
     * Set TrackingScript value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackingScript
     * @return \StructType\UetTag
     */
    public function setTrackingScript($trackingScript = null)
    {
        // validation for constraint: string
        if (!is_null($trackingScript) && !is_string($trackingScript)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingScript, true), gettype($trackingScript)), __LINE__);
        }
        if (is_null($trackingScript) || (is_array($trackingScript) && empty($trackingScript))) {
            unset($this->TrackingScript);
        } else {
            $this->TrackingScript = $trackingScript;
        }
        return $this;
    }
    /**
     * Get TrackingStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingStatus()
    {
        return isset($this->TrackingStatus) ? $this->TrackingStatus : null;
    }
    /**
     * Set TrackingStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\UetTagTrackingStatus::valueIsValid()
     * @uses \EnumType\UetTagTrackingStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trackingStatus
     * @return \StructType\UetTag
     */
    public function setTrackingStatus($trackingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UetTagTrackingStatus::valueIsValid($trackingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UetTagTrackingStatus', is_array($trackingStatus) ? implode(', ', $trackingStatus) : var_export($trackingStatus, true), implode(', ', \EnumType\UetTagTrackingStatus::getValidValues())), __LINE__);
        }
        if (is_null($trackingStatus) || (is_array($trackingStatus) && empty($trackingStatus))) {
            unset($this->TrackingStatus);
        } else {
            $this->TrackingStatus = $trackingStatus;
        }
        return $this;
    }
}
