<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextAd StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TextAd
 * @subpackage Structs
 */
class TextAd extends Ad
{
    /**
     * The DestinationUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationUrl;
    /**
     * The DisplayUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayUrl;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Text;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * Constructor method for TextAd
     * @uses TextAd::setDestinationUrl()
     * @uses TextAd::setDisplayUrl()
     * @uses TextAd::setText()
     * @uses TextAd::setTitle()
     * @param string $destinationUrl
     * @param string $displayUrl
     * @param string $text
     * @param string $title
     */
    public function __construct($destinationUrl = null, $displayUrl = null, $text = null, $title = null)
    {
        $this
            ->setDestinationUrl($destinationUrl)
            ->setDisplayUrl($displayUrl)
            ->setText($text)
            ->setTitle($title);
    }
    /**
     * Get DestinationUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationUrl()
    {
        return isset($this->DestinationUrl) ? $this->DestinationUrl : null;
    }
    /**
     * Set DestinationUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationUrl
     * @return \StructType\TextAd
     */
    public function setDestinationUrl($destinationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($destinationUrl) && !is_string($destinationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationUrl, true), gettype($destinationUrl)), __LINE__);
        }
        if (is_null($destinationUrl) || (is_array($destinationUrl) && empty($destinationUrl))) {
            unset($this->DestinationUrl);
        } else {
            $this->DestinationUrl = $destinationUrl;
        }
        return $this;
    }
    /**
     * Get DisplayUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayUrl()
    {
        return isset($this->DisplayUrl) ? $this->DisplayUrl : null;
    }
    /**
     * Set DisplayUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayUrl
     * @return \StructType\TextAd
     */
    public function setDisplayUrl($displayUrl = null)
    {
        // validation for constraint: string
        if (!is_null($displayUrl) && !is_string($displayUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayUrl, true), gettype($displayUrl)), __LINE__);
        }
        if (is_null($displayUrl) || (is_array($displayUrl) && empty($displayUrl))) {
            unset($this->DisplayUrl);
        } else {
            $this->DisplayUrl = $displayUrl;
        }
        return $this;
    }
    /**
     * Get Text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getText()
    {
        return isset($this->Text) ? $this->Text : null;
    }
    /**
     * Set Text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $text
     * @return \StructType\TextAd
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->Text);
        } else {
            $this->Text = $text;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \StructType\TextAd
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
}
