<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetSettingDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TargetSettingDetail
 * @subpackage Structs
 */
class TargetSettingDetail extends AbstractStructBase
{
    /**
     * The CriterionTypeGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CriterionTypeGroup;
    /**
     * The TargetAndBid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TargetAndBid;
    /**
     * Constructor method for TargetSettingDetail
     * @uses TargetSettingDetail::setCriterionTypeGroup()
     * @uses TargetSettingDetail::setTargetAndBid()
     * @param string $criterionTypeGroup
     * @param bool $targetAndBid
     */
    public function __construct($criterionTypeGroup = null, $targetAndBid = null)
    {
        $this
            ->setCriterionTypeGroup($criterionTypeGroup)
            ->setTargetAndBid($targetAndBid);
    }
    /**
     * Get CriterionTypeGroup value
     * @return string|null
     */
    public function getCriterionTypeGroup()
    {
        return $this->CriterionTypeGroup;
    }
    /**
     * Set CriterionTypeGroup value
     * @uses \EnumType\CriterionTypeGroup::valueIsValid()
     * @uses \EnumType\CriterionTypeGroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $criterionTypeGroup
     * @return \StructType\TargetSettingDetail
     */
    public function setCriterionTypeGroup($criterionTypeGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CriterionTypeGroup::valueIsValid($criterionTypeGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CriterionTypeGroup', is_array($criterionTypeGroup) ? implode(', ', $criterionTypeGroup) : var_export($criterionTypeGroup, true), implode(', ', \EnumType\CriterionTypeGroup::getValidValues())), __LINE__);
        }
        $this->CriterionTypeGroup = $criterionTypeGroup;
        return $this;
    }
    /**
     * Get TargetAndBid value
     * @return bool|null
     */
    public function getTargetAndBid()
    {
        return $this->TargetAndBid;
    }
    /**
     * Set TargetAndBid value
     * @param bool $targetAndBid
     * @return \StructType\TargetSettingDetail
     */
    public function setTargetAndBid($targetAndBid = null)
    {
        // validation for constraint: boolean
        if (!is_null($targetAndBid) && !is_bool($targetAndBid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($targetAndBid, true), gettype($targetAndBid)), __LINE__);
        }
        $this->TargetAndBid = $targetAndBid;
        return $this;
    }
}
