<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetCpaBiddingScheme StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TargetCpaBiddingScheme
 * @subpackage Structs
 */
class TargetCpaBiddingScheme extends BiddingScheme
{
    /**
     * The MaxCpc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bid
     */
    public $MaxCpc;
    /**
     * The TargetCpa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TargetCpa;
    /**
     * Constructor method for TargetCpaBiddingScheme
     * @uses TargetCpaBiddingScheme::setMaxCpc()
     * @uses TargetCpaBiddingScheme::setTargetCpa()
     * @param \StructType\Bid $maxCpc
     * @param float $targetCpa
     */
    public function __construct(\StructType\Bid $maxCpc = null, $targetCpa = null)
    {
        $this
            ->setMaxCpc($maxCpc)
            ->setTargetCpa($targetCpa);
    }
    /**
     * Get MaxCpc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bid|null
     */
    public function getMaxCpc()
    {
        return isset($this->MaxCpc) ? $this->MaxCpc : null;
    }
    /**
     * Set MaxCpc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Bid $maxCpc
     * @return \StructType\TargetCpaBiddingScheme
     */
    public function setMaxCpc(\StructType\Bid $maxCpc = null)
    {
        if (is_null($maxCpc) || (is_array($maxCpc) && empty($maxCpc))) {
            unset($this->MaxCpc);
        } else {
            $this->MaxCpc = $maxCpc;
        }
        return $this;
    }
    /**
     * Get TargetCpa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTargetCpa()
    {
        return isset($this->TargetCpa) ? $this->TargetCpa : null;
    }
    /**
     * Set TargetCpa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $targetCpa
     * @return \StructType\TargetCpaBiddingScheme
     */
    public function setTargetCpa($targetCpa = null)
    {
        // validation for constraint: float
        if (!is_null($targetCpa) && !(is_float($targetCpa) || is_numeric($targetCpa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($targetCpa, true), gettype($targetCpa)), __LINE__);
        }
        if (is_null($targetCpa) || (is_array($targetCpa) && empty($targetCpa))) {
            unset($this->TargetCpa);
        } else {
            $this->TargetCpa = $targetCpa;
        }
        return $this;
    }
}
