<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StringRuleItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:StringRuleItem
 * @subpackage Structs
 */
class StringRuleItem extends RuleItem
{
    /**
     * The Operand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operand;
    /**
     * The Operator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Operator;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * Constructor method for StringRuleItem
     * @uses StringRuleItem::setOperand()
     * @uses StringRuleItem::setOperator()
     * @uses StringRuleItem::setValue()
     * @param string $operand
     * @param string $operator
     * @param string $value
     */
    public function __construct($operand = null, $operator = null, $value = null)
    {
        $this
            ->setOperand($operand)
            ->setOperator($operator)
            ->setValue($value);
    }
    /**
     * Get Operand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperand()
    {
        return isset($this->Operand) ? $this->Operand : null;
    }
    /**
     * Set Operand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operand
     * @return \StructType\StringRuleItem
     */
    public function setOperand($operand = null)
    {
        // validation for constraint: string
        if (!is_null($operand) && !is_string($operand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operand, true), gettype($operand)), __LINE__);
        }
        if (is_null($operand) || (is_array($operand) && empty($operand))) {
            unset($this->Operand);
        } else {
            $this->Operand = $operand;
        }
        return $this;
    }
    /**
     * Get Operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @uses \EnumType\StringOperator::valueIsValid()
     * @uses \EnumType\StringOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\StringRuleItem
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StringOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StringOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\StringOperator::getValidValues())), __LINE__);
        }
        $this->Operator = $operator;
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \StructType\StringRuleItem
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
