<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreCriterion StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:StoreCriterion
 * @subpackage Structs
 */
class StoreCriterion extends Criterion
{
    /**
     * The StoreId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StoreId;
    /**
     * Constructor method for StoreCriterion
     * @uses StoreCriterion::setStoreId()
     * @param int $storeId
     */
    public function __construct($storeId = null)
    {
        $this
            ->setStoreId($storeId);
    }
    /**
     * Get StoreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStoreId()
    {
        return isset($this->StoreId) ? $this->StoreId : null;
    }
    /**
     * Set StoreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $storeId
     * @return \StructType\StoreCriterion
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: int
        if (!is_null($storeId) && !(is_int($storeId) || ctype_digit($storeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        if (is_null($storeId) || (is_array($storeId) && empty($storeId))) {
            unset($this->StoreId);
        } else {
            $this->StoreId = $storeId;
        }
        return $this;
    }
}
