<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetNegativeSitesToCampaignsRequest StructType
 * @subpackage Structs
 */
class SetNegativeSitesToCampaignsRequest extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The CampaignNegativeSites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCampaignNegativeSites
     */
    public $CampaignNegativeSites;
    /**
     * Constructor method for SetNegativeSitesToCampaignsRequest
     * @uses SetNegativeSitesToCampaignsRequest::setAccountId()
     * @uses SetNegativeSitesToCampaignsRequest::setCampaignNegativeSites()
     * @param int $accountId
     * @param \ArrayType\ArrayOfCampaignNegativeSites $campaignNegativeSites
     */
    public function __construct($accountId = null, \ArrayType\ArrayOfCampaignNegativeSites $campaignNegativeSites = null)
    {
        $this
            ->setAccountId($accountId)
            ->setCampaignNegativeSites($campaignNegativeSites);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\SetNegativeSitesToCampaignsRequest
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get CampaignNegativeSites value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCampaignNegativeSites|null
     */
    public function getCampaignNegativeSites()
    {
        return isset($this->CampaignNegativeSites) ? $this->CampaignNegativeSites : null;
    }
    /**
     * Set CampaignNegativeSites value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCampaignNegativeSites $campaignNegativeSites
     * @return \StructType\SetNegativeSitesToCampaignsRequest
     */
    public function setCampaignNegativeSites(\ArrayType\ArrayOfCampaignNegativeSites $campaignNegativeSites = null)
    {
        if (is_null($campaignNegativeSites) || (is_array($campaignNegativeSites) && empty($campaignNegativeSites))) {
            unset($this->CampaignNegativeSites);
        } else {
            $this->CampaignNegativeSites = $campaignNegativeSites;
        }
        return $this;
    }
}
