<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetNegativeSitesToAdGroupsRequest StructType
 * @subpackage Structs
 */
class SetNegativeSitesToAdGroupsRequest extends AbstractStructBase
{
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignId;
    /**
     * The AdGroupNegativeSites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdGroupNegativeSites
     */
    public $AdGroupNegativeSites;
    /**
     * Constructor method for SetNegativeSitesToAdGroupsRequest
     * @uses SetNegativeSitesToAdGroupsRequest::setCampaignId()
     * @uses SetNegativeSitesToAdGroupsRequest::setAdGroupNegativeSites()
     * @param int $campaignId
     * @param \ArrayType\ArrayOfAdGroupNegativeSites $adGroupNegativeSites
     */
    public function __construct($campaignId = null, \ArrayType\ArrayOfAdGroupNegativeSites $adGroupNegativeSites = null)
    {
        $this
            ->setCampaignId($campaignId)
            ->setAdGroupNegativeSites($adGroupNegativeSites);
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\SetNegativeSitesToAdGroupsRequest
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
    /**
     * Get AdGroupNegativeSites value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdGroupNegativeSites|null
     */
    public function getAdGroupNegativeSites()
    {
        return isset($this->AdGroupNegativeSites) ? $this->AdGroupNegativeSites : null;
    }
    /**
     * Set AdGroupNegativeSites value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdGroupNegativeSites $adGroupNegativeSites
     * @return \StructType\SetNegativeSitesToAdGroupsRequest
     */
    public function setAdGroupNegativeSites(\ArrayType\ArrayOfAdGroupNegativeSites $adGroupNegativeSites = null)
    {
        if (is_null($adGroupNegativeSites) || (is_array($adGroupNegativeSites) && empty($adGroupNegativeSites))) {
            unset($this->AdGroupNegativeSites);
        } else {
            $this->AdGroupNegativeSites = $adGroupNegativeSites;
        }
        return $this;
    }
}
