<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetLabelAssociationsRequest StructType
 * @subpackage Structs
 */
class SetLabelAssociationsRequest extends AbstractStructBase
{
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntityType;
    /**
     * The LabelAssociations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLabelAssociation
     */
    public $LabelAssociations;
    /**
     * Constructor method for SetLabelAssociationsRequest
     * @uses SetLabelAssociationsRequest::setEntityType()
     * @uses SetLabelAssociationsRequest::setLabelAssociations()
     * @param string $entityType
     * @param \ArrayType\ArrayOfLabelAssociation $labelAssociations
     */
    public function __construct($entityType = null, \ArrayType\ArrayOfLabelAssociation $labelAssociations = null)
    {
        $this
            ->setEntityType($entityType)
            ->setLabelAssociations($labelAssociations);
    }
    /**
     * Get EntityType value
     * @return string|null
     */
    public function getEntityType()
    {
        return $this->EntityType;
    }
    /**
     * Set EntityType value
     * @uses \EnumType\EntityType::valueIsValid()
     * @uses \EnumType\EntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entityType
     * @return \StructType\SetLabelAssociationsRequest
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityType::valueIsValid($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityType', is_array($entityType) ? implode(', ', $entityType) : var_export($entityType, true), implode(', ', \EnumType\EntityType::getValidValues())), __LINE__);
        }
        $this->EntityType = $entityType;
        return $this;
    }
    /**
     * Get LabelAssociations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLabelAssociation|null
     */
    public function getLabelAssociations()
    {
        return isset($this->LabelAssociations) ? $this->LabelAssociations : null;
    }
    /**
     * Set LabelAssociations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLabelAssociation $labelAssociations
     * @return \StructType\SetLabelAssociationsRequest
     */
    public function setLabelAssociations(\ArrayType\ArrayOfLabelAssociation $labelAssociations = null)
    {
        if (is_null($labelAssociations) || (is_array($labelAssociations) && empty($labelAssociations))) {
            unset($this->LabelAssociations);
        } else {
            $this->LabelAssociations = $labelAssociations;
        }
        return $this;
    }
}
