<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetAccountPropertiesRequest StructType
 * @subpackage Structs
 */
class SetAccountPropertiesRequest extends AbstractStructBase
{
    /**
     * The AccountProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountProperty
     */
    public $AccountProperties;
    /**
     * Constructor method for SetAccountPropertiesRequest
     * @uses SetAccountPropertiesRequest::setAccountProperties()
     * @param \ArrayType\ArrayOfAccountProperty $accountProperties
     */
    public function __construct(\ArrayType\ArrayOfAccountProperty $accountProperties = null)
    {
        $this
            ->setAccountProperties($accountProperties);
    }
    /**
     * Get AccountProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountProperty|null
     */
    public function getAccountProperties()
    {
        return isset($this->AccountProperties) ? $this->AccountProperties : null;
    }
    /**
     * Set AccountProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountProperty $accountProperties
     * @return \StructType\SetAccountPropertiesRequest
     */
    public function setAccountProperties(\ArrayType\ArrayOfAccountProperty $accountProperties = null)
    {
        if (is_null($accountProperties) || (is_array($accountProperties) && empty($accountProperties))) {
            unset($this->AccountProperties);
        } else {
            $this->AccountProperties = $accountProperties;
        }
        return $this;
    }
}
