<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponsiveSearchAd StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResponsiveSearchAd
 * @subpackage Structs
 */
class ResponsiveSearchAd extends Ad
{
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAssetLink
     */
    public $Descriptions;
    /**
     * The Domain
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Domain;
    /**
     * The Headlines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAssetLink
     */
    public $Headlines;
    /**
     * The Path1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Path1;
    /**
     * The Path2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Path2;
    /**
     * Constructor method for ResponsiveSearchAd
     * @uses ResponsiveSearchAd::setDescriptions()
     * @uses ResponsiveSearchAd::setDomain()
     * @uses ResponsiveSearchAd::setHeadlines()
     * @uses ResponsiveSearchAd::setPath1()
     * @uses ResponsiveSearchAd::setPath2()
     * @param \ArrayType\ArrayOfAssetLink $descriptions
     * @param string $domain
     * @param \ArrayType\ArrayOfAssetLink $headlines
     * @param string $path1
     * @param string $path2
     */
    public function __construct(\ArrayType\ArrayOfAssetLink $descriptions = null, $domain = null, \ArrayType\ArrayOfAssetLink $headlines = null, $path1 = null, $path2 = null)
    {
        $this
            ->setDescriptions($descriptions)
            ->setDomain($domain)
            ->setHeadlines($headlines)
            ->setPath1($path1)
            ->setPath2($path2);
    }
    /**
     * Get Descriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAssetLink|null
     */
    public function getDescriptions()
    {
        return isset($this->Descriptions) ? $this->Descriptions : null;
    }
    /**
     * Set Descriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAssetLink $descriptions
     * @return \StructType\ResponsiveSearchAd
     */
    public function setDescriptions(\ArrayType\ArrayOfAssetLink $descriptions = null)
    {
        if (is_null($descriptions) || (is_array($descriptions) && empty($descriptions))) {
            unset($this->Descriptions);
        } else {
            $this->Descriptions = $descriptions;
        }
        return $this;
    }
    /**
     * Get Domain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomain()
    {
        return isset($this->Domain) ? $this->Domain : null;
    }
    /**
     * Set Domain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domain
     * @return \StructType\ResponsiveSearchAd
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domain, true), gettype($domain)), __LINE__);
        }
        if (is_null($domain) || (is_array($domain) && empty($domain))) {
            unset($this->Domain);
        } else {
            $this->Domain = $domain;
        }
        return $this;
    }
    /**
     * Get Headlines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAssetLink|null
     */
    public function getHeadlines()
    {
        return isset($this->Headlines) ? $this->Headlines : null;
    }
    /**
     * Set Headlines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAssetLink $headlines
     * @return \StructType\ResponsiveSearchAd
     */
    public function setHeadlines(\ArrayType\ArrayOfAssetLink $headlines = null)
    {
        if (is_null($headlines) || (is_array($headlines) && empty($headlines))) {
            unset($this->Headlines);
        } else {
            $this->Headlines = $headlines;
        }
        return $this;
    }
    /**
     * Get Path1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPath1()
    {
        return isset($this->Path1) ? $this->Path1 : null;
    }
    /**
     * Set Path1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $path1
     * @return \StructType\ResponsiveSearchAd
     */
    public function setPath1($path1 = null)
    {
        // validation for constraint: string
        if (!is_null($path1) && !is_string($path1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($path1, true), gettype($path1)), __LINE__);
        }
        if (is_null($path1) || (is_array($path1) && empty($path1))) {
            unset($this->Path1);
        } else {
            $this->Path1 = $path1;
        }
        return $this;
    }
    /**
     * Get Path2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPath2()
    {
        return isset($this->Path2) ? $this->Path2 : null;
    }
    /**
     * Set Path2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $path2
     * @return \StructType\ResponsiveSearchAd
     */
    public function setPath2($path2 = null)
    {
        // validation for constraint: string
        if (!is_null($path2) && !is_string($path2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($path2, true), gettype($path2)), __LINE__);
        }
        if (is_null($path2) || (is_array($path2) && empty($path2))) {
            unset($this->Path2);
        } else {
            $this->Path2 = $path2;
        }
        return $this;
    }
}
