<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionAdExtension StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PromotionAdExtension
 * @subpackage Structs
 */
class PromotionAdExtension extends AdExtension
{
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DiscountModifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DiscountModifier;
    /**
     * The FinalAppUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAppUrl
     */
    public $FinalAppUrls;
    /**
     * The FinalMobileUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FinalMobileUrls;
    /**
     * The FinalUrlSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FinalUrlSuffix;
    /**
     * The FinalUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FinalUrls;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The MoneyAmountOff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MoneyAmountOff;
    /**
     * The OrdersOverAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OrdersOverAmount;
    /**
     * The PercentOff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PercentOff;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Date
     */
    public $PromotionEndDate;
    /**
     * The PromotionItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromotionItem;
    /**
     * The PromotionOccasion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromotionOccasion;
    /**
     * The PromotionStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Date
     */
    public $PromotionStartDate;
    /**
     * The TrackingUrlTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingUrlTemplate;
    /**
     * The UrlCustomParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomParameters
     */
    public $UrlCustomParameters;
    /**
     * Constructor method for PromotionAdExtension
     * @uses PromotionAdExtension::setCurrencyCode()
     * @uses PromotionAdExtension::setDiscountModifier()
     * @uses PromotionAdExtension::setFinalAppUrls()
     * @uses PromotionAdExtension::setFinalMobileUrls()
     * @uses PromotionAdExtension::setFinalUrlSuffix()
     * @uses PromotionAdExtension::setFinalUrls()
     * @uses PromotionAdExtension::setLanguage()
     * @uses PromotionAdExtension::setMoneyAmountOff()
     * @uses PromotionAdExtension::setOrdersOverAmount()
     * @uses PromotionAdExtension::setPercentOff()
     * @uses PromotionAdExtension::setPromotionCode()
     * @uses PromotionAdExtension::setPromotionEndDate()
     * @uses PromotionAdExtension::setPromotionItem()
     * @uses PromotionAdExtension::setPromotionOccasion()
     * @uses PromotionAdExtension::setPromotionStartDate()
     * @uses PromotionAdExtension::setTrackingUrlTemplate()
     * @uses PromotionAdExtension::setUrlCustomParameters()
     * @param string $currencyCode
     * @param string $discountModifier
     * @param \ArrayType\ArrayOfAppUrl $finalAppUrls
     * @param \ArrayType\ArrayOfstring $finalMobileUrls
     * @param string $finalUrlSuffix
     * @param \ArrayType\ArrayOfstring $finalUrls
     * @param string $language
     * @param float $moneyAmountOff
     * @param float $ordersOverAmount
     * @param float $percentOff
     * @param string $promotionCode
     * @param \StructType\Date $promotionEndDate
     * @param string $promotionItem
     * @param string $promotionOccasion
     * @param \StructType\Date $promotionStartDate
     * @param string $trackingUrlTemplate
     * @param \StructType\CustomParameters $urlCustomParameters
     */
    public function __construct($currencyCode = null, $discountModifier = null, \ArrayType\ArrayOfAppUrl $finalAppUrls = null, \ArrayType\ArrayOfstring $finalMobileUrls = null, $finalUrlSuffix = null, \ArrayType\ArrayOfstring $finalUrls = null, $language = null, $moneyAmountOff = null, $ordersOverAmount = null, $percentOff = null, $promotionCode = null, \StructType\Date $promotionEndDate = null, $promotionItem = null, $promotionOccasion = null, \StructType\Date $promotionStartDate = null, $trackingUrlTemplate = null, \StructType\CustomParameters $urlCustomParameters = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setDiscountModifier($discountModifier)
            ->setFinalAppUrls($finalAppUrls)
            ->setFinalMobileUrls($finalMobileUrls)
            ->setFinalUrlSuffix($finalUrlSuffix)
            ->setFinalUrls($finalUrls)
            ->setLanguage($language)
            ->setMoneyAmountOff($moneyAmountOff)
            ->setOrdersOverAmount($ordersOverAmount)
            ->setPercentOff($percentOff)
            ->setPromotionCode($promotionCode)
            ->setPromotionEndDate($promotionEndDate)
            ->setPromotionItem($promotionItem)
            ->setPromotionOccasion($promotionOccasion)
            ->setPromotionStartDate($promotionStartDate)
            ->setTrackingUrlTemplate($trackingUrlTemplate)
            ->setUrlCustomParameters($urlCustomParameters);
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\PromotionAdExtension
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get DiscountModifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiscountModifier()
    {
        return isset($this->DiscountModifier) ? $this->DiscountModifier : null;
    }
    /**
     * Set DiscountModifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\PromotionDiscountModifier::valueIsValid()
     * @uses \EnumType\PromotionDiscountModifier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $discountModifier
     * @return \StructType\PromotionAdExtension
     */
    public function setDiscountModifier($discountModifier = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PromotionDiscountModifier::valueIsValid($discountModifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PromotionDiscountModifier', is_array($discountModifier) ? implode(', ', $discountModifier) : var_export($discountModifier, true), implode(', ', \EnumType\PromotionDiscountModifier::getValidValues())), __LINE__);
        }
        if (is_null($discountModifier) || (is_array($discountModifier) && empty($discountModifier))) {
            unset($this->DiscountModifier);
        } else {
            $this->DiscountModifier = $discountModifier;
        }
        return $this;
    }
    /**
     * Get FinalAppUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAppUrl|null
     */
    public function getFinalAppUrls()
    {
        return isset($this->FinalAppUrls) ? $this->FinalAppUrls : null;
    }
    /**
     * Set FinalAppUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAppUrl $finalAppUrls
     * @return \StructType\PromotionAdExtension
     */
    public function setFinalAppUrls(\ArrayType\ArrayOfAppUrl $finalAppUrls = null)
    {
        if (is_null($finalAppUrls) || (is_array($finalAppUrls) && empty($finalAppUrls))) {
            unset($this->FinalAppUrls);
        } else {
            $this->FinalAppUrls = $finalAppUrls;
        }
        return $this;
    }
    /**
     * Get FinalMobileUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFinalMobileUrls()
    {
        return isset($this->FinalMobileUrls) ? $this->FinalMobileUrls : null;
    }
    /**
     * Set FinalMobileUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $finalMobileUrls
     * @return \StructType\PromotionAdExtension
     */
    public function setFinalMobileUrls(\ArrayType\ArrayOfstring $finalMobileUrls = null)
    {
        if (is_null($finalMobileUrls) || (is_array($finalMobileUrls) && empty($finalMobileUrls))) {
            unset($this->FinalMobileUrls);
        } else {
            $this->FinalMobileUrls = $finalMobileUrls;
        }
        return $this;
    }
    /**
     * Get FinalUrlSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinalUrlSuffix()
    {
        return isset($this->FinalUrlSuffix) ? $this->FinalUrlSuffix : null;
    }
    /**
     * Set FinalUrlSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $finalUrlSuffix
     * @return \StructType\PromotionAdExtension
     */
    public function setFinalUrlSuffix($finalUrlSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($finalUrlSuffix) && !is_string($finalUrlSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalUrlSuffix, true), gettype($finalUrlSuffix)), __LINE__);
        }
        if (is_null($finalUrlSuffix) || (is_array($finalUrlSuffix) && empty($finalUrlSuffix))) {
            unset($this->FinalUrlSuffix);
        } else {
            $this->FinalUrlSuffix = $finalUrlSuffix;
        }
        return $this;
    }
    /**
     * Get FinalUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFinalUrls()
    {
        return isset($this->FinalUrls) ? $this->FinalUrls : null;
    }
    /**
     * Set FinalUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $finalUrls
     * @return \StructType\PromotionAdExtension
     */
    public function setFinalUrls(\ArrayType\ArrayOfstring $finalUrls = null)
    {
        if (is_null($finalUrls) || (is_array($finalUrls) && empty($finalUrls))) {
            unset($this->FinalUrls);
        } else {
            $this->FinalUrls = $finalUrls;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \StructType\PromotionAdExtension
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get MoneyAmountOff value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMoneyAmountOff()
    {
        return isset($this->MoneyAmountOff) ? $this->MoneyAmountOff : null;
    }
    /**
     * Set MoneyAmountOff value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $moneyAmountOff
     * @return \StructType\PromotionAdExtension
     */
    public function setMoneyAmountOff($moneyAmountOff = null)
    {
        // validation for constraint: float
        if (!is_null($moneyAmountOff) && !(is_float($moneyAmountOff) || is_numeric($moneyAmountOff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($moneyAmountOff, true), gettype($moneyAmountOff)), __LINE__);
        }
        if (is_null($moneyAmountOff) || (is_array($moneyAmountOff) && empty($moneyAmountOff))) {
            unset($this->MoneyAmountOff);
        } else {
            $this->MoneyAmountOff = $moneyAmountOff;
        }
        return $this;
    }
    /**
     * Get OrdersOverAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOrdersOverAmount()
    {
        return isset($this->OrdersOverAmount) ? $this->OrdersOverAmount : null;
    }
    /**
     * Set OrdersOverAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ordersOverAmount
     * @return \StructType\PromotionAdExtension
     */
    public function setOrdersOverAmount($ordersOverAmount = null)
    {
        // validation for constraint: float
        if (!is_null($ordersOverAmount) && !(is_float($ordersOverAmount) || is_numeric($ordersOverAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ordersOverAmount, true), gettype($ordersOverAmount)), __LINE__);
        }
        if (is_null($ordersOverAmount) || (is_array($ordersOverAmount) && empty($ordersOverAmount))) {
            unset($this->OrdersOverAmount);
        } else {
            $this->OrdersOverAmount = $ordersOverAmount;
        }
        return $this;
    }
    /**
     * Get PercentOff value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPercentOff()
    {
        return isset($this->PercentOff) ? $this->PercentOff : null;
    }
    /**
     * Set PercentOff value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $percentOff
     * @return \StructType\PromotionAdExtension
     */
    public function setPercentOff($percentOff = null)
    {
        // validation for constraint: float
        if (!is_null($percentOff) && !(is_float($percentOff) || is_numeric($percentOff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentOff, true), gettype($percentOff)), __LINE__);
        }
        if (is_null($percentOff) || (is_array($percentOff) && empty($percentOff))) {
            unset($this->PercentOff);
        } else {
            $this->PercentOff = $percentOff;
        }
        return $this;
    }
    /**
     * Get PromotionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromotionCode()
    {
        return isset($this->PromotionCode) ? $this->PromotionCode : null;
    }
    /**
     * Set PromotionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promotionCode
     * @return \StructType\PromotionAdExtension
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        if (is_null($promotionCode) || (is_array($promotionCode) && empty($promotionCode))) {
            unset($this->PromotionCode);
        } else {
            $this->PromotionCode = $promotionCode;
        }
        return $this;
    }
    /**
     * Get PromotionEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Date|null
     */
    public function getPromotionEndDate()
    {
        return isset($this->PromotionEndDate) ? $this->PromotionEndDate : null;
    }
    /**
     * Set PromotionEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Date $promotionEndDate
     * @return \StructType\PromotionAdExtension
     */
    public function setPromotionEndDate(\StructType\Date $promotionEndDate = null)
    {
        if (is_null($promotionEndDate) || (is_array($promotionEndDate) && empty($promotionEndDate))) {
            unset($this->PromotionEndDate);
        } else {
            $this->PromotionEndDate = $promotionEndDate;
        }
        return $this;
    }
    /**
     * Get PromotionItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromotionItem()
    {
        return isset($this->PromotionItem) ? $this->PromotionItem : null;
    }
    /**
     * Set PromotionItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promotionItem
     * @return \StructType\PromotionAdExtension
     */
    public function setPromotionItem($promotionItem = null)
    {
        // validation for constraint: string
        if (!is_null($promotionItem) && !is_string($promotionItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionItem, true), gettype($promotionItem)), __LINE__);
        }
        if (is_null($promotionItem) || (is_array($promotionItem) && empty($promotionItem))) {
            unset($this->PromotionItem);
        } else {
            $this->PromotionItem = $promotionItem;
        }
        return $this;
    }
    /**
     * Get PromotionOccasion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromotionOccasion()
    {
        return isset($this->PromotionOccasion) ? $this->PromotionOccasion : null;
    }
    /**
     * Set PromotionOccasion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\PromotionOccasion::valueIsValid()
     * @uses \EnumType\PromotionOccasion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $promotionOccasion
     * @return \StructType\PromotionAdExtension
     */
    public function setPromotionOccasion($promotionOccasion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PromotionOccasion::valueIsValid($promotionOccasion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PromotionOccasion', is_array($promotionOccasion) ? implode(', ', $promotionOccasion) : var_export($promotionOccasion, true), implode(', ', \EnumType\PromotionOccasion::getValidValues())), __LINE__);
        }
        if (is_null($promotionOccasion) || (is_array($promotionOccasion) && empty($promotionOccasion))) {
            unset($this->PromotionOccasion);
        } else {
            $this->PromotionOccasion = $promotionOccasion;
        }
        return $this;
    }
    /**
     * Get PromotionStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Date|null
     */
    public function getPromotionStartDate()
    {
        return isset($this->PromotionStartDate) ? $this->PromotionStartDate : null;
    }
    /**
     * Set PromotionStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Date $promotionStartDate
     * @return \StructType\PromotionAdExtension
     */
    public function setPromotionStartDate(\StructType\Date $promotionStartDate = null)
    {
        if (is_null($promotionStartDate) || (is_array($promotionStartDate) && empty($promotionStartDate))) {
            unset($this->PromotionStartDate);
        } else {
            $this->PromotionStartDate = $promotionStartDate;
        }
        return $this;
    }
    /**
     * Get TrackingUrlTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingUrlTemplate()
    {
        return isset($this->TrackingUrlTemplate) ? $this->TrackingUrlTemplate : null;
    }
    /**
     * Set TrackingUrlTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackingUrlTemplate
     * @return \StructType\PromotionAdExtension
     */
    public function setTrackingUrlTemplate($trackingUrlTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($trackingUrlTemplate) && !is_string($trackingUrlTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingUrlTemplate, true), gettype($trackingUrlTemplate)), __LINE__);
        }
        if (is_null($trackingUrlTemplate) || (is_array($trackingUrlTemplate) && empty($trackingUrlTemplate))) {
            unset($this->TrackingUrlTemplate);
        } else {
            $this->TrackingUrlTemplate = $trackingUrlTemplate;
        }
        return $this;
    }
    /**
     * Get UrlCustomParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomParameters|null
     */
    public function getUrlCustomParameters()
    {
        return isset($this->UrlCustomParameters) ? $this->UrlCustomParameters : null;
    }
    /**
     * Set UrlCustomParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomParameters $urlCustomParameters
     * @return \StructType\PromotionAdExtension
     */
    public function setUrlCustomParameters(\StructType\CustomParameters $urlCustomParameters = null)
    {
        if (is_null($urlCustomParameters) || (is_array($urlCustomParameters) && empty($urlCustomParameters))) {
            unset($this->UrlCustomParameters);
        } else {
            $this->UrlCustomParameters = $urlCustomParameters;
        }
        return $this;
    }
}
