<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductPartition StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductPartition
 * @subpackage Structs
 */
class ProductPartition extends Criterion
{
    /**
     * The Condition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductCondition
     */
    public $Condition;
    /**
     * The ParentCriterionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ParentCriterionId;
    /**
     * The PartitionType
     * @var string
     */
    public $PartitionType;
    /**
     * Constructor method for ProductPartition
     * @uses ProductPartition::setCondition()
     * @uses ProductPartition::setParentCriterionId()
     * @uses ProductPartition::setPartitionType()
     * @param \StructType\ProductCondition $condition
     * @param int $parentCriterionId
     * @param string $partitionType
     */
    public function __construct(\StructType\ProductCondition $condition = null, $parentCriterionId = null, $partitionType = null)
    {
        $this
            ->setCondition($condition)
            ->setParentCriterionId($parentCriterionId)
            ->setPartitionType($partitionType);
    }
    /**
     * Get Condition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductCondition|null
     */
    public function getCondition()
    {
        return isset($this->Condition) ? $this->Condition : null;
    }
    /**
     * Set Condition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProductCondition $condition
     * @return \StructType\ProductPartition
     */
    public function setCondition(\StructType\ProductCondition $condition = null)
    {
        if (is_null($condition) || (is_array($condition) && empty($condition))) {
            unset($this->Condition);
        } else {
            $this->Condition = $condition;
        }
        return $this;
    }
    /**
     * Get ParentCriterionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParentCriterionId()
    {
        return isset($this->ParentCriterionId) ? $this->ParentCriterionId : null;
    }
    /**
     * Set ParentCriterionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parentCriterionId
     * @return \StructType\ProductPartition
     */
    public function setParentCriterionId($parentCriterionId = null)
    {
        // validation for constraint: int
        if (!is_null($parentCriterionId) && !(is_int($parentCriterionId) || ctype_digit($parentCriterionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentCriterionId, true), gettype($parentCriterionId)), __LINE__);
        }
        if (is_null($parentCriterionId) || (is_array($parentCriterionId) && empty($parentCriterionId))) {
            unset($this->ParentCriterionId);
        } else {
            $this->ParentCriterionId = $parentCriterionId;
        }
        return $this;
    }
    /**
     * Get PartitionType value
     * @return string|null
     */
    public function getPartitionType()
    {
        return $this->PartitionType;
    }
    /**
     * Set PartitionType value
     * @uses \EnumType\ProductPartitionType::valueIsValid()
     * @uses \EnumType\ProductPartitionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionType
     * @return \StructType\ProductPartition
     */
    public function setPartitionType($partitionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductPartitionType::valueIsValid($partitionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductPartitionType', is_array($partitionType) ? implode(', ', $partitionType) : var_export($partitionType, true), implode(', ', \EnumType\ProductPartitionType::getValidValues())), __LINE__);
        }
        $this->PartitionType = $partitionType;
        return $this;
    }
}
