<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductAudience StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductAudience
 * @subpackage Structs
 */
class ProductAudience extends Audience
{
    /**
     * The ProductAudienceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ProductAudienceType;
    /**
     * The TagId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TagId;
    /**
     * Constructor method for ProductAudience
     * @uses ProductAudience::setProductAudienceType()
     * @uses ProductAudience::setTagId()
     * @param string[] $productAudienceType
     * @param int $tagId
     */
    public function __construct(array $productAudienceType = array(), $tagId = null)
    {
        $this
            ->setProductAudienceType($productAudienceType)
            ->setTagId($tagId);
    }
    /**
     * Get ProductAudienceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getProductAudienceType()
    {
        return isset($this->ProductAudienceType) ? $this->ProductAudienceType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductAudienceType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductAudienceType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductAudienceTypeForArrayConstraintsFromSetProductAudienceType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productAudienceProductAudienceTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ProductAudienceType::valueIsValid($productAudienceProductAudienceTypeItem)) {
                $invalidValues[] = is_object($productAudienceProductAudienceTypeItem) ? get_class($productAudienceProductAudienceTypeItem) : sprintf('%s(%s)', gettype($productAudienceProductAudienceTypeItem), var_export($productAudienceProductAudienceTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductAudienceType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ProductAudienceType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductAudienceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ProductAudienceType::valueIsValid()
     * @uses \EnumType\ProductAudienceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $productAudienceType
     * @return \StructType\ProductAudience
     */
    public function setProductAudienceType(array $productAudienceType = array())
    {
        // validation for constraint: list
        if ('' !== ($productAudienceTypeArrayErrorMessage = self::validateProductAudienceTypeForArrayConstraintsFromSetProductAudienceType($productAudienceType))) {
            throw new \InvalidArgumentException($productAudienceTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($productAudienceType) || (is_array($productAudienceType) && empty($productAudienceType))) {
            unset($this->ProductAudienceType);
        } else {
            $this->ProductAudienceType = is_array($productAudienceType) ? implode(' ', $productAudienceType) : null;
        }
        return $this;
    }
    /**
     * Get TagId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTagId()
    {
        return isset($this->TagId) ? $this->TagId : null;
    }
    /**
     * Set TagId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tagId
     * @return \StructType\ProductAudience
     */
    public function setTagId($tagId = null)
    {
        // validation for constraint: int
        if (!is_null($tagId) && !(is_int($tagId) || ctype_digit($tagId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tagId, true), gettype($tagId)), __LINE__);
        }
        if (is_null($tagId) || (is_array($tagId) && empty($tagId))) {
            unset($this->TagId);
        } else {
            $this->TagId = $tagId;
        }
        return $this;
    }
}
