<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceAdExtension StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PriceAdExtension
 * @subpackage Structs
 */
class PriceAdExtension extends AdExtension
{
    /**
     * The FinalUrlSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FinalUrlSuffix;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The PriceExtensionType
     * @var string
     */
    public $PriceExtensionType;
    /**
     * The TableRows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPriceTableRow
     */
    public $TableRows;
    /**
     * The TrackingUrlTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingUrlTemplate;
    /**
     * The UrlCustomParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomParameters
     */
    public $UrlCustomParameters;
    /**
     * Constructor method for PriceAdExtension
     * @uses PriceAdExtension::setFinalUrlSuffix()
     * @uses PriceAdExtension::setLanguage()
     * @uses PriceAdExtension::setPriceExtensionType()
     * @uses PriceAdExtension::setTableRows()
     * @uses PriceAdExtension::setTrackingUrlTemplate()
     * @uses PriceAdExtension::setUrlCustomParameters()
     * @param string $finalUrlSuffix
     * @param string $language
     * @param string $priceExtensionType
     * @param \ArrayType\ArrayOfPriceTableRow $tableRows
     * @param string $trackingUrlTemplate
     * @param \StructType\CustomParameters $urlCustomParameters
     */
    public function __construct($finalUrlSuffix = null, $language = null, $priceExtensionType = null, \ArrayType\ArrayOfPriceTableRow $tableRows = null, $trackingUrlTemplate = null, \StructType\CustomParameters $urlCustomParameters = null)
    {
        $this
            ->setFinalUrlSuffix($finalUrlSuffix)
            ->setLanguage($language)
            ->setPriceExtensionType($priceExtensionType)
            ->setTableRows($tableRows)
            ->setTrackingUrlTemplate($trackingUrlTemplate)
            ->setUrlCustomParameters($urlCustomParameters);
    }
    /**
     * Get FinalUrlSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinalUrlSuffix()
    {
        return isset($this->FinalUrlSuffix) ? $this->FinalUrlSuffix : null;
    }
    /**
     * Set FinalUrlSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $finalUrlSuffix
     * @return \StructType\PriceAdExtension
     */
    public function setFinalUrlSuffix($finalUrlSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($finalUrlSuffix) && !is_string($finalUrlSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalUrlSuffix, true), gettype($finalUrlSuffix)), __LINE__);
        }
        if (is_null($finalUrlSuffix) || (is_array($finalUrlSuffix) && empty($finalUrlSuffix))) {
            unset($this->FinalUrlSuffix);
        } else {
            $this->FinalUrlSuffix = $finalUrlSuffix;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \StructType\PriceAdExtension
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get PriceExtensionType value
     * @return string|null
     */
    public function getPriceExtensionType()
    {
        return $this->PriceExtensionType;
    }
    /**
     * Set PriceExtensionType value
     * @uses \EnumType\PriceExtensionType::valueIsValid()
     * @uses \EnumType\PriceExtensionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceExtensionType
     * @return \StructType\PriceAdExtension
     */
    public function setPriceExtensionType($priceExtensionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PriceExtensionType::valueIsValid($priceExtensionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PriceExtensionType', is_array($priceExtensionType) ? implode(', ', $priceExtensionType) : var_export($priceExtensionType, true), implode(', ', \EnumType\PriceExtensionType::getValidValues())), __LINE__);
        }
        $this->PriceExtensionType = $priceExtensionType;
        return $this;
    }
    /**
     * Get TableRows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPriceTableRow|null
     */
    public function getTableRows()
    {
        return isset($this->TableRows) ? $this->TableRows : null;
    }
    /**
     * Set TableRows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPriceTableRow $tableRows
     * @return \StructType\PriceAdExtension
     */
    public function setTableRows(\ArrayType\ArrayOfPriceTableRow $tableRows = null)
    {
        if (is_null($tableRows) || (is_array($tableRows) && empty($tableRows))) {
            unset($this->TableRows);
        } else {
            $this->TableRows = $tableRows;
        }
        return $this;
    }
    /**
     * Get TrackingUrlTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingUrlTemplate()
    {
        return isset($this->TrackingUrlTemplate) ? $this->TrackingUrlTemplate : null;
    }
    /**
     * Set TrackingUrlTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackingUrlTemplate
     * @return \StructType\PriceAdExtension
     */
    public function setTrackingUrlTemplate($trackingUrlTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($trackingUrlTemplate) && !is_string($trackingUrlTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingUrlTemplate, true), gettype($trackingUrlTemplate)), __LINE__);
        }
        if (is_null($trackingUrlTemplate) || (is_array($trackingUrlTemplate) && empty($trackingUrlTemplate))) {
            unset($this->TrackingUrlTemplate);
        } else {
            $this->TrackingUrlTemplate = $trackingUrlTemplate;
        }
        return $this;
    }
    /**
     * Get UrlCustomParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomParameters|null
     */
    public function getUrlCustomParameters()
    {
        return isset($this->UrlCustomParameters) ? $this->UrlCustomParameters : null;
    }
    /**
     * Set UrlCustomParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomParameters $urlCustomParameters
     * @return \StructType\PriceAdExtension
     */
    public function setUrlCustomParameters(\StructType\CustomParameters $urlCustomParameters = null)
    {
        if (is_null($urlCustomParameters) || (is_array($urlCustomParameters) && empty($urlCustomParameters))) {
            unset($this->UrlCustomParameters);
        } else {
            $this->UrlCustomParameters = $urlCustomParameters;
        }
        return $this;
    }
}
