<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfflineConversion StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OfflineConversion
 * @subpackage Structs
 */
class OfflineConversion extends AbstractStructBase
{
    /**
     * The ConversionCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConversionCurrencyCode;
    /**
     * The ConversionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConversionName;
    /**
     * The ConversionTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ConversionTime;
    /**
     * The ConversionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ConversionValue;
    /**
     * The ExternalAttributionCredit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ExternalAttributionCredit;
    /**
     * The ExternalAttributionModel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalAttributionModel;
    /**
     * The MicrosoftClickId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MicrosoftClickId;
    /**
     * Constructor method for OfflineConversion
     * @uses OfflineConversion::setConversionCurrencyCode()
     * @uses OfflineConversion::setConversionName()
     * @uses OfflineConversion::setConversionTime()
     * @uses OfflineConversion::setConversionValue()
     * @uses OfflineConversion::setExternalAttributionCredit()
     * @uses OfflineConversion::setExternalAttributionModel()
     * @uses OfflineConversion::setMicrosoftClickId()
     * @param string $conversionCurrencyCode
     * @param string $conversionName
     * @param string $conversionTime
     * @param float $conversionValue
     * @param float $externalAttributionCredit
     * @param string $externalAttributionModel
     * @param string $microsoftClickId
     */
    public function __construct($conversionCurrencyCode = null, $conversionName = null, $conversionTime = null, $conversionValue = null, $externalAttributionCredit = null, $externalAttributionModel = null, $microsoftClickId = null)
    {
        $this
            ->setConversionCurrencyCode($conversionCurrencyCode)
            ->setConversionName($conversionName)
            ->setConversionTime($conversionTime)
            ->setConversionValue($conversionValue)
            ->setExternalAttributionCredit($externalAttributionCredit)
            ->setExternalAttributionModel($externalAttributionModel)
            ->setMicrosoftClickId($microsoftClickId);
    }
    /**
     * Get ConversionCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConversionCurrencyCode()
    {
        return isset($this->ConversionCurrencyCode) ? $this->ConversionCurrencyCode : null;
    }
    /**
     * Set ConversionCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $conversionCurrencyCode
     * @return \StructType\OfflineConversion
     */
    public function setConversionCurrencyCode($conversionCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($conversionCurrencyCode) && !is_string($conversionCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversionCurrencyCode, true), gettype($conversionCurrencyCode)), __LINE__);
        }
        if (is_null($conversionCurrencyCode) || (is_array($conversionCurrencyCode) && empty($conversionCurrencyCode))) {
            unset($this->ConversionCurrencyCode);
        } else {
            $this->ConversionCurrencyCode = $conversionCurrencyCode;
        }
        return $this;
    }
    /**
     * Get ConversionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConversionName()
    {
        return isset($this->ConversionName) ? $this->ConversionName : null;
    }
    /**
     * Set ConversionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $conversionName
     * @return \StructType\OfflineConversion
     */
    public function setConversionName($conversionName = null)
    {
        // validation for constraint: string
        if (!is_null($conversionName) && !is_string($conversionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversionName, true), gettype($conversionName)), __LINE__);
        }
        if (is_null($conversionName) || (is_array($conversionName) && empty($conversionName))) {
            unset($this->ConversionName);
        } else {
            $this->ConversionName = $conversionName;
        }
        return $this;
    }
    /**
     * Get ConversionTime value
     * @return string|null
     */
    public function getConversionTime()
    {
        return $this->ConversionTime;
    }
    /**
     * Set ConversionTime value
     * @param string $conversionTime
     * @return \StructType\OfflineConversion
     */
    public function setConversionTime($conversionTime = null)
    {
        // validation for constraint: string
        if (!is_null($conversionTime) && !is_string($conversionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversionTime, true), gettype($conversionTime)), __LINE__);
        }
        $this->ConversionTime = $conversionTime;
        return $this;
    }
    /**
     * Get ConversionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getConversionValue()
    {
        return isset($this->ConversionValue) ? $this->ConversionValue : null;
    }
    /**
     * Set ConversionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $conversionValue
     * @return \StructType\OfflineConversion
     */
    public function setConversionValue($conversionValue = null)
    {
        // validation for constraint: float
        if (!is_null($conversionValue) && !(is_float($conversionValue) || is_numeric($conversionValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversionValue, true), gettype($conversionValue)), __LINE__);
        }
        if (is_null($conversionValue) || (is_array($conversionValue) && empty($conversionValue))) {
            unset($this->ConversionValue);
        } else {
            $this->ConversionValue = $conversionValue;
        }
        return $this;
    }
    /**
     * Get ExternalAttributionCredit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getExternalAttributionCredit()
    {
        return isset($this->ExternalAttributionCredit) ? $this->ExternalAttributionCredit : null;
    }
    /**
     * Set ExternalAttributionCredit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $externalAttributionCredit
     * @return \StructType\OfflineConversion
     */
    public function setExternalAttributionCredit($externalAttributionCredit = null)
    {
        // validation for constraint: float
        if (!is_null($externalAttributionCredit) && !(is_float($externalAttributionCredit) || is_numeric($externalAttributionCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($externalAttributionCredit, true), gettype($externalAttributionCredit)), __LINE__);
        }
        if (is_null($externalAttributionCredit) || (is_array($externalAttributionCredit) && empty($externalAttributionCredit))) {
            unset($this->ExternalAttributionCredit);
        } else {
            $this->ExternalAttributionCredit = $externalAttributionCredit;
        }
        return $this;
    }
    /**
     * Get ExternalAttributionModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalAttributionModel()
    {
        return isset($this->ExternalAttributionModel) ? $this->ExternalAttributionModel : null;
    }
    /**
     * Set ExternalAttributionModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalAttributionModel
     * @return \StructType\OfflineConversion
     */
    public function setExternalAttributionModel($externalAttributionModel = null)
    {
        // validation for constraint: string
        if (!is_null($externalAttributionModel) && !is_string($externalAttributionModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalAttributionModel, true), gettype($externalAttributionModel)), __LINE__);
        }
        if (is_null($externalAttributionModel) || (is_array($externalAttributionModel) && empty($externalAttributionModel))) {
            unset($this->ExternalAttributionModel);
        } else {
            $this->ExternalAttributionModel = $externalAttributionModel;
        }
        return $this;
    }
    /**
     * Get MicrosoftClickId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMicrosoftClickId()
    {
        return isset($this->MicrosoftClickId) ? $this->MicrosoftClickId : null;
    }
    /**
     * Set MicrosoftClickId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $microsoftClickId
     * @return \StructType\OfflineConversion
     */
    public function setMicrosoftClickId($microsoftClickId = null)
    {
        // validation for constraint: string
        if (!is_null($microsoftClickId) && !is_string($microsoftClickId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($microsoftClickId, true), gettype($microsoftClickId)), __LINE__);
        }
        if (is_null($microsoftClickId) || (is_array($microsoftClickId) && empty($microsoftClickId))) {
            unset($this->MicrosoftClickId);
        } else {
            $this->MicrosoftClickId = $microsoftClickId;
        }
        return $this;
    }
}
