<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NegativeKeyword StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NegativeKeyword
 * @subpackage Structs
 */
class NegativeKeyword extends SharedListItem
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The MatchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MatchType;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Text;
    /**
     * Constructor method for NegativeKeyword
     * @uses NegativeKeyword::setId()
     * @uses NegativeKeyword::setMatchType()
     * @uses NegativeKeyword::setText()
     * @param int $id
     * @param string $matchType
     * @param string $text
     */
    public function __construct($id = null, $matchType = null, $text = null)
    {
        $this
            ->setId($id)
            ->setMatchType($matchType)
            ->setText($text);
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\NegativeKeyword
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get MatchType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatchType()
    {
        return isset($this->MatchType) ? $this->MatchType : null;
    }
    /**
     * Set MatchType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\MatchType::valueIsValid()
     * @uses \EnumType\MatchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $matchType
     * @return \StructType\NegativeKeyword
     */
    public function setMatchType($matchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MatchType::valueIsValid($matchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MatchType', is_array($matchType) ? implode(', ', $matchType) : var_export($matchType, true), implode(', ', \EnumType\MatchType::getValidValues())), __LINE__);
        }
        if (is_null($matchType) || (is_array($matchType) && empty($matchType))) {
            unset($this->MatchType);
        } else {
            $this->MatchType = $matchType;
        }
        return $this;
    }
    /**
     * Get Text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getText()
    {
        return isset($this->Text) ? $this->Text : null;
    }
    /**
     * Set Text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $text
     * @return \StructType\NegativeKeyword
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->Text);
        } else {
            $this->Text = $text;
        }
        return $this;
    }
}
