<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MediaAssociation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MediaAssociation
 * @subpackage Structs
 */
class MediaAssociation extends AbstractStructBase
{
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EntityId;
    /**
     * The MediaEnabledEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $MediaEnabledEntity;
    /**
     * The MediaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MediaId;
    /**
     * Constructor method for MediaAssociation
     * @uses MediaAssociation::setEntityId()
     * @uses MediaAssociation::setMediaEnabledEntity()
     * @uses MediaAssociation::setMediaId()
     * @param int $entityId
     * @param string[] $mediaEnabledEntity
     * @param int $mediaId
     */
    public function __construct($entityId = null, array $mediaEnabledEntity = array(), $mediaId = null)
    {
        $this
            ->setEntityId($entityId)
            ->setMediaEnabledEntity($mediaEnabledEntity)
            ->setMediaId($mediaId);
    }
    /**
     * Get EntityId value
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param int $entityId
     * @return \StructType\MediaAssociation
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get MediaEnabledEntity value
     * @return string[]|null
     */
    public function getMediaEnabledEntity()
    {
        return $this->MediaEnabledEntity;
    }
    /**
     * This method is responsible for validating the values passed to the setMediaEnabledEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaEnabledEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaEnabledEntityForArrayConstraintsFromSetMediaEnabledEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mediaAssociationMediaEnabledEntityItem) {
            // validation for constraint: enumeration
            if (!\EnumType\MediaEnabledEntityFilter::valueIsValid($mediaAssociationMediaEnabledEntityItem)) {
                $invalidValues[] = is_object($mediaAssociationMediaEnabledEntityItem) ? get_class($mediaAssociationMediaEnabledEntityItem) : sprintf('%s(%s)', gettype($mediaAssociationMediaEnabledEntityItem), var_export($mediaAssociationMediaEnabledEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MediaEnabledEntityFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\MediaEnabledEntityFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MediaEnabledEntity value
     * @uses \EnumType\MediaEnabledEntityFilter::valueIsValid()
     * @uses \EnumType\MediaEnabledEntityFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $mediaEnabledEntity
     * @return \StructType\MediaAssociation
     */
    public function setMediaEnabledEntity(array $mediaEnabledEntity = array())
    {
        // validation for constraint: list
        if ('' !== ($mediaEnabledEntityArrayErrorMessage = self::validateMediaEnabledEntityForArrayConstraintsFromSetMediaEnabledEntity($mediaEnabledEntity))) {
            throw new \InvalidArgumentException($mediaEnabledEntityArrayErrorMessage, __LINE__);
        }
        $this->MediaEnabledEntity = is_array($mediaEnabledEntity) ? implode(' ', $mediaEnabledEntity) : null;
        return $this;
    }
    /**
     * Get MediaId value
     * @return int|null
     */
    public function getMediaId()
    {
        return $this->MediaId;
    }
    /**
     * Set MediaId value
     * @param int $mediaId
     * @return \StructType\MediaAssociation
     */
    public function setMediaId($mediaId = null)
    {
        // validation for constraint: int
        if (!is_null($mediaId) && !(is_int($mediaId) || ctype_digit($mediaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mediaId, true), gettype($mediaId)), __LINE__);
        }
        $this->MediaId = $mediaId;
        return $this;
    }
}
