<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationIntentCriterion StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LocationIntentCriterion
 * @subpackage Structs
 */
class LocationIntentCriterion extends Criterion
{
    /**
     * The IntentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntentOption;
    /**
     * Constructor method for LocationIntentCriterion
     * @uses LocationIntentCriterion::setIntentOption()
     * @param string $intentOption
     */
    public function __construct($intentOption = null)
    {
        $this
            ->setIntentOption($intentOption);
    }
    /**
     * Get IntentOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntentOption()
    {
        return isset($this->IntentOption) ? $this->IntentOption : null;
    }
    /**
     * Set IntentOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\IntentOption::valueIsValid()
     * @uses \EnumType\IntentOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $intentOption
     * @return \StructType\LocationIntentCriterion
     */
    public function setIntentOption($intentOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IntentOption::valueIsValid($intentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IntentOption', is_array($intentOption) ? implode(', ', $intentOption) : var_export($intentOption, true), implode(', ', \EnumType\IntentOption::getValidValues())), __LINE__);
        }
        if (is_null($intentOption) || (is_array($intentOption) && empty($intentOption))) {
            unset($this->IntentOption);
        } else {
            $this->IntentOption = $intentOption;
        }
        return $this;
    }
}
