<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationCriterion StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LocationCriterion
 * @subpackage Structs
 */
class LocationCriterion extends Criterion
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The EnclosedLocationIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $EnclosedLocationIds;
    /**
     * The LocationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocationId;
    /**
     * The LocationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocationType;
    /**
     * Constructor method for LocationCriterion
     * @uses LocationCriterion::setDisplayName()
     * @uses LocationCriterion::setEnclosedLocationIds()
     * @uses LocationCriterion::setLocationId()
     * @uses LocationCriterion::setLocationType()
     * @param string $displayName
     * @param \ArrayType\ArrayOflong $enclosedLocationIds
     * @param int $locationId
     * @param string $locationType
     */
    public function __construct($displayName = null, \ArrayType\ArrayOflong $enclosedLocationIds = null, $locationId = null, $locationType = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setEnclosedLocationIds($enclosedLocationIds)
            ->setLocationId($locationId)
            ->setLocationType($locationType);
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \StructType\LocationCriterion
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get EnclosedLocationIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getEnclosedLocationIds()
    {
        return isset($this->EnclosedLocationIds) ? $this->EnclosedLocationIds : null;
    }
    /**
     * Set EnclosedLocationIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $enclosedLocationIds
     * @return \StructType\LocationCriterion
     */
    public function setEnclosedLocationIds(\ArrayType\ArrayOflong $enclosedLocationIds = null)
    {
        if (is_null($enclosedLocationIds) || (is_array($enclosedLocationIds) && empty($enclosedLocationIds))) {
            unset($this->EnclosedLocationIds);
        } else {
            $this->EnclosedLocationIds = $enclosedLocationIds;
        }
        return $this;
    }
    /**
     * Get LocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocationId()
    {
        return isset($this->LocationId) ? $this->LocationId : null;
    }
    /**
     * Set LocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $locationId
     * @return \StructType\LocationCriterion
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: int
        if (!is_null($locationId) && !(is_int($locationId) || ctype_digit($locationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($locationId, true), gettype($locationId)), __LINE__);
        }
        if (is_null($locationId) || (is_array($locationId) && empty($locationId))) {
            unset($this->LocationId);
        } else {
            $this->LocationId = $locationId;
        }
        return $this;
    }
    /**
     * Get LocationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationType()
    {
        return isset($this->LocationType) ? $this->LocationType : null;
    }
    /**
     * Set LocationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationType
     * @return \StructType\LocationCriterion
     */
    public function setLocationType($locationType = null)
    {
        // validation for constraint: string
        if (!is_null($locationType) && !is_string($locationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationType, true), gettype($locationType)), __LINE__);
        }
        if (is_null($locationType) || (is_array($locationType) && empty($locationType))) {
            unset($this->LocationType);
        } else {
            $this->LocationType = $locationType;
        }
        return $this;
    }
}
