<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Keyword StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Keyword
 * @subpackage Structs
 */
class Keyword extends AbstractStructBase
{
    /**
     * The Bid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bid
     */
    public $Bid;
    /**
     * The BiddingScheme
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BiddingScheme
     */
    public $BiddingScheme;
    /**
     * The DestinationUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationUrl;
    /**
     * The EditorialStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EditorialStatus;
    /**
     * The FinalAppUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAppUrl
     */
    public $FinalAppUrls;
    /**
     * The FinalMobileUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FinalMobileUrls;
    /**
     * The FinalUrlSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FinalUrlSuffix;
    /**
     * The FinalUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FinalUrls;
    /**
     * The ForwardCompatibilityMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValuePairOfstringstring
     */
    public $ForwardCompatibilityMap;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The MatchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MatchType;
    /**
     * The Param1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Param1;
    /**
     * The Param2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Param2;
    /**
     * The Param3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Param3;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Text;
    /**
     * The TrackingUrlTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingUrlTemplate;
    /**
     * The UrlCustomParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomParameters
     */
    public $UrlCustomParameters;
    /**
     * Constructor method for Keyword
     * @uses Keyword::setBid()
     * @uses Keyword::setBiddingScheme()
     * @uses Keyword::setDestinationUrl()
     * @uses Keyword::setEditorialStatus()
     * @uses Keyword::setFinalAppUrls()
     * @uses Keyword::setFinalMobileUrls()
     * @uses Keyword::setFinalUrlSuffix()
     * @uses Keyword::setFinalUrls()
     * @uses Keyword::setForwardCompatibilityMap()
     * @uses Keyword::setId()
     * @uses Keyword::setMatchType()
     * @uses Keyword::setParam1()
     * @uses Keyword::setParam2()
     * @uses Keyword::setParam3()
     * @uses Keyword::setStatus()
     * @uses Keyword::setText()
     * @uses Keyword::setTrackingUrlTemplate()
     * @uses Keyword::setUrlCustomParameters()
     * @param \StructType\Bid $bid
     * @param \StructType\BiddingScheme $biddingScheme
     * @param string $destinationUrl
     * @param string $editorialStatus
     * @param \ArrayType\ArrayOfAppUrl $finalAppUrls
     * @param \ArrayType\ArrayOfstring $finalMobileUrls
     * @param string $finalUrlSuffix
     * @param \ArrayType\ArrayOfstring $finalUrls
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @param int $id
     * @param string $matchType
     * @param string $param1
     * @param string $param2
     * @param string $param3
     * @param string $status
     * @param string $text
     * @param string $trackingUrlTemplate
     * @param \StructType\CustomParameters $urlCustomParameters
     */
    public function __construct(\StructType\Bid $bid = null, \StructType\BiddingScheme $biddingScheme = null, $destinationUrl = null, $editorialStatus = null, \ArrayType\ArrayOfAppUrl $finalAppUrls = null, \ArrayType\ArrayOfstring $finalMobileUrls = null, $finalUrlSuffix = null, \ArrayType\ArrayOfstring $finalUrls = null, \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null, $id = null, $matchType = null, $param1 = null, $param2 = null, $param3 = null, $status = null, $text = null, $trackingUrlTemplate = null, \StructType\CustomParameters $urlCustomParameters = null)
    {
        $this
            ->setBid($bid)
            ->setBiddingScheme($biddingScheme)
            ->setDestinationUrl($destinationUrl)
            ->setEditorialStatus($editorialStatus)
            ->setFinalAppUrls($finalAppUrls)
            ->setFinalMobileUrls($finalMobileUrls)
            ->setFinalUrlSuffix($finalUrlSuffix)
            ->setFinalUrls($finalUrls)
            ->setForwardCompatibilityMap($forwardCompatibilityMap)
            ->setId($id)
            ->setMatchType($matchType)
            ->setParam1($param1)
            ->setParam2($param2)
            ->setParam3($param3)
            ->setStatus($status)
            ->setText($text)
            ->setTrackingUrlTemplate($trackingUrlTemplate)
            ->setUrlCustomParameters($urlCustomParameters);
    }
    /**
     * Get Bid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bid|null
     */
    public function getBid()
    {
        return isset($this->Bid) ? $this->Bid : null;
    }
    /**
     * Set Bid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Bid $bid
     * @return \StructType\Keyword
     */
    public function setBid(\StructType\Bid $bid = null)
    {
        if (is_null($bid) || (is_array($bid) && empty($bid))) {
            unset($this->Bid);
        } else {
            $this->Bid = $bid;
        }
        return $this;
    }
    /**
     * Get BiddingScheme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BiddingScheme|null
     */
    public function getBiddingScheme()
    {
        return isset($this->BiddingScheme) ? $this->BiddingScheme : null;
    }
    /**
     * Set BiddingScheme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BiddingScheme $biddingScheme
     * @return \StructType\Keyword
     */
    public function setBiddingScheme(\StructType\BiddingScheme $biddingScheme = null)
    {
        if (is_null($biddingScheme) || (is_array($biddingScheme) && empty($biddingScheme))) {
            unset($this->BiddingScheme);
        } else {
            $this->BiddingScheme = $biddingScheme;
        }
        return $this;
    }
    /**
     * Get DestinationUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationUrl()
    {
        return isset($this->DestinationUrl) ? $this->DestinationUrl : null;
    }
    /**
     * Set DestinationUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationUrl
     * @return \StructType\Keyword
     */
    public function setDestinationUrl($destinationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($destinationUrl) && !is_string($destinationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationUrl, true), gettype($destinationUrl)), __LINE__);
        }
        if (is_null($destinationUrl) || (is_array($destinationUrl) && empty($destinationUrl))) {
            unset($this->DestinationUrl);
        } else {
            $this->DestinationUrl = $destinationUrl;
        }
        return $this;
    }
    /**
     * Get EditorialStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEditorialStatus()
    {
        return isset($this->EditorialStatus) ? $this->EditorialStatus : null;
    }
    /**
     * Set EditorialStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\KeywordEditorialStatus::valueIsValid()
     * @uses \EnumType\KeywordEditorialStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $editorialStatus
     * @return \StructType\Keyword
     */
    public function setEditorialStatus($editorialStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KeywordEditorialStatus::valueIsValid($editorialStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KeywordEditorialStatus', is_array($editorialStatus) ? implode(', ', $editorialStatus) : var_export($editorialStatus, true), implode(', ', \EnumType\KeywordEditorialStatus::getValidValues())), __LINE__);
        }
        if (is_null($editorialStatus) || (is_array($editorialStatus) && empty($editorialStatus))) {
            unset($this->EditorialStatus);
        } else {
            $this->EditorialStatus = $editorialStatus;
        }
        return $this;
    }
    /**
     * Get FinalAppUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAppUrl|null
     */
    public function getFinalAppUrls()
    {
        return isset($this->FinalAppUrls) ? $this->FinalAppUrls : null;
    }
    /**
     * Set FinalAppUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAppUrl $finalAppUrls
     * @return \StructType\Keyword
     */
    public function setFinalAppUrls(\ArrayType\ArrayOfAppUrl $finalAppUrls = null)
    {
        if (is_null($finalAppUrls) || (is_array($finalAppUrls) && empty($finalAppUrls))) {
            unset($this->FinalAppUrls);
        } else {
            $this->FinalAppUrls = $finalAppUrls;
        }
        return $this;
    }
    /**
     * Get FinalMobileUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFinalMobileUrls()
    {
        return isset($this->FinalMobileUrls) ? $this->FinalMobileUrls : null;
    }
    /**
     * Set FinalMobileUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $finalMobileUrls
     * @return \StructType\Keyword
     */
    public function setFinalMobileUrls(\ArrayType\ArrayOfstring $finalMobileUrls = null)
    {
        if (is_null($finalMobileUrls) || (is_array($finalMobileUrls) && empty($finalMobileUrls))) {
            unset($this->FinalMobileUrls);
        } else {
            $this->FinalMobileUrls = $finalMobileUrls;
        }
        return $this;
    }
    /**
     * Get FinalUrlSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinalUrlSuffix()
    {
        return isset($this->FinalUrlSuffix) ? $this->FinalUrlSuffix : null;
    }
    /**
     * Set FinalUrlSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $finalUrlSuffix
     * @return \StructType\Keyword
     */
    public function setFinalUrlSuffix($finalUrlSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($finalUrlSuffix) && !is_string($finalUrlSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalUrlSuffix, true), gettype($finalUrlSuffix)), __LINE__);
        }
        if (is_null($finalUrlSuffix) || (is_array($finalUrlSuffix) && empty($finalUrlSuffix))) {
            unset($this->FinalUrlSuffix);
        } else {
            $this->FinalUrlSuffix = $finalUrlSuffix;
        }
        return $this;
    }
    /**
     * Get FinalUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFinalUrls()
    {
        return isset($this->FinalUrls) ? $this->FinalUrls : null;
    }
    /**
     * Set FinalUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $finalUrls
     * @return \StructType\Keyword
     */
    public function setFinalUrls(\ArrayType\ArrayOfstring $finalUrls = null)
    {
        if (is_null($finalUrls) || (is_array($finalUrls) && empty($finalUrls))) {
            unset($this->FinalUrls);
        } else {
            $this->FinalUrls = $finalUrls;
        }
        return $this;
    }
    /**
     * Get ForwardCompatibilityMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValuePairOfstringstring|null
     */
    public function getForwardCompatibilityMap()
    {
        return isset($this->ForwardCompatibilityMap) ? $this->ForwardCompatibilityMap : null;
    }
    /**
     * Set ForwardCompatibilityMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @return \StructType\Keyword
     */
    public function setForwardCompatibilityMap(\ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null)
    {
        if (is_null($forwardCompatibilityMap) || (is_array($forwardCompatibilityMap) && empty($forwardCompatibilityMap))) {
            unset($this->ForwardCompatibilityMap);
        } else {
            $this->ForwardCompatibilityMap = $forwardCompatibilityMap;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\Keyword
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get MatchType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatchType()
    {
        return isset($this->MatchType) ? $this->MatchType : null;
    }
    /**
     * Set MatchType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\MatchType::valueIsValid()
     * @uses \EnumType\MatchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $matchType
     * @return \StructType\Keyword
     */
    public function setMatchType($matchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MatchType::valueIsValid($matchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MatchType', is_array($matchType) ? implode(', ', $matchType) : var_export($matchType, true), implode(', ', \EnumType\MatchType::getValidValues())), __LINE__);
        }
        if (is_null($matchType) || (is_array($matchType) && empty($matchType))) {
            unset($this->MatchType);
        } else {
            $this->MatchType = $matchType;
        }
        return $this;
    }
    /**
     * Get Param1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParam1()
    {
        return isset($this->Param1) ? $this->Param1 : null;
    }
    /**
     * Set Param1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $param1
     * @return \StructType\Keyword
     */
    public function setParam1($param1 = null)
    {
        // validation for constraint: string
        if (!is_null($param1) && !is_string($param1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($param1, true), gettype($param1)), __LINE__);
        }
        if (is_null($param1) || (is_array($param1) && empty($param1))) {
            unset($this->Param1);
        } else {
            $this->Param1 = $param1;
        }
        return $this;
    }
    /**
     * Get Param2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParam2()
    {
        return isset($this->Param2) ? $this->Param2 : null;
    }
    /**
     * Set Param2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $param2
     * @return \StructType\Keyword
     */
    public function setParam2($param2 = null)
    {
        // validation for constraint: string
        if (!is_null($param2) && !is_string($param2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($param2, true), gettype($param2)), __LINE__);
        }
        if (is_null($param2) || (is_array($param2) && empty($param2))) {
            unset($this->Param2);
        } else {
            $this->Param2 = $param2;
        }
        return $this;
    }
    /**
     * Get Param3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParam3()
    {
        return isset($this->Param3) ? $this->Param3 : null;
    }
    /**
     * Set Param3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $param3
     * @return \StructType\Keyword
     */
    public function setParam3($param3 = null)
    {
        // validation for constraint: string
        if (!is_null($param3) && !is_string($param3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($param3, true), gettype($param3)), __LINE__);
        }
        if (is_null($param3) || (is_array($param3) && empty($param3))) {
            unset($this->Param3);
        } else {
            $this->Param3 = $param3;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\KeywordStatus::valueIsValid()
     * @uses \EnumType\KeywordStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Keyword
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KeywordStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KeywordStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\KeywordStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getText()
    {
        return isset($this->Text) ? $this->Text : null;
    }
    /**
     * Set Text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $text
     * @return \StructType\Keyword
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->Text);
        } else {
            $this->Text = $text;
        }
        return $this;
    }
    /**
     * Get TrackingUrlTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingUrlTemplate()
    {
        return isset($this->TrackingUrlTemplate) ? $this->TrackingUrlTemplate : null;
    }
    /**
     * Set TrackingUrlTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackingUrlTemplate
     * @return \StructType\Keyword
     */
    public function setTrackingUrlTemplate($trackingUrlTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($trackingUrlTemplate) && !is_string($trackingUrlTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingUrlTemplate, true), gettype($trackingUrlTemplate)), __LINE__);
        }
        if (is_null($trackingUrlTemplate) || (is_array($trackingUrlTemplate) && empty($trackingUrlTemplate))) {
            unset($this->TrackingUrlTemplate);
        } else {
            $this->TrackingUrlTemplate = $trackingUrlTemplate;
        }
        return $this;
    }
    /**
     * Get UrlCustomParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomParameters|null
     */
    public function getUrlCustomParameters()
    {
        return isset($this->UrlCustomParameters) ? $this->UrlCustomParameters : null;
    }
    /**
     * Set UrlCustomParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomParameters $urlCustomParameters
     * @return \StructType\Keyword
     */
    public function setUrlCustomParameters(\StructType\CustomParameters $urlCustomParameters = null)
    {
        if (is_null($urlCustomParameters) || (is_array($urlCustomParameters) && empty($urlCustomParameters))) {
            unset($this->UrlCustomParameters);
        } else {
            $this->UrlCustomParameters = $urlCustomParameters;
        }
        return $this;
    }
}
