<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportEntityStatistics StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ImportEntityStatistics
 * @subpackage Structs
 */
class ImportEntityStatistics extends AbstractStructBase
{
    /**
     * The Additions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Additions;
    /**
     * The Changes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Changes;
    /**
     * The Deletions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Deletions;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityType;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Errors;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Total;
    /**
     * Constructor method for ImportEntityStatistics
     * @uses ImportEntityStatistics::setAdditions()
     * @uses ImportEntityStatistics::setChanges()
     * @uses ImportEntityStatistics::setDeletions()
     * @uses ImportEntityStatistics::setEntityType()
     * @uses ImportEntityStatistics::setErrors()
     * @uses ImportEntityStatistics::setTotal()
     * @param int $additions
     * @param int $changes
     * @param int $deletions
     * @param string $entityType
     * @param int $errors
     * @param int $total
     */
    public function __construct($additions = null, $changes = null, $deletions = null, $entityType = null, $errors = null, $total = null)
    {
        $this
            ->setAdditions($additions)
            ->setChanges($changes)
            ->setDeletions($deletions)
            ->setEntityType($entityType)
            ->setErrors($errors)
            ->setTotal($total);
    }
    /**
     * Get Additions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAdditions()
    {
        return isset($this->Additions) ? $this->Additions : null;
    }
    /**
     * Set Additions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $additions
     * @return \StructType\ImportEntityStatistics
     */
    public function setAdditions($additions = null)
    {
        // validation for constraint: int
        if (!is_null($additions) && !(is_int($additions) || ctype_digit($additions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($additions, true), gettype($additions)), __LINE__);
        }
        if (is_null($additions) || (is_array($additions) && empty($additions))) {
            unset($this->Additions);
        } else {
            $this->Additions = $additions;
        }
        return $this;
    }
    /**
     * Get Changes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getChanges()
    {
        return isset($this->Changes) ? $this->Changes : null;
    }
    /**
     * Set Changes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $changes
     * @return \StructType\ImportEntityStatistics
     */
    public function setChanges($changes = null)
    {
        // validation for constraint: int
        if (!is_null($changes) && !(is_int($changes) || ctype_digit($changes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($changes, true), gettype($changes)), __LINE__);
        }
        if (is_null($changes) || (is_array($changes) && empty($changes))) {
            unset($this->Changes);
        } else {
            $this->Changes = $changes;
        }
        return $this;
    }
    /**
     * Get Deletions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeletions()
    {
        return isset($this->Deletions) ? $this->Deletions : null;
    }
    /**
     * Set Deletions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deletions
     * @return \StructType\ImportEntityStatistics
     */
    public function setDeletions($deletions = null)
    {
        // validation for constraint: int
        if (!is_null($deletions) && !(is_int($deletions) || ctype_digit($deletions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deletions, true), gettype($deletions)), __LINE__);
        }
        if (is_null($deletions) || (is_array($deletions) && empty($deletions))) {
            unset($this->Deletions);
        } else {
            $this->Deletions = $deletions;
        }
        return $this;
    }
    /**
     * Get EntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->EntityType) ? $this->EntityType : null;
    }
    /**
     * Set EntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \StructType\ImportEntityStatistics
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->EntityType);
        } else {
            $this->EntityType = $entityType;
        }
        return $this;
    }
    /**
     * Get Errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $errors
     * @return \StructType\ImportEntityStatistics
     */
    public function setErrors($errors = null)
    {
        // validation for constraint: int
        if (!is_null($errors) && !(is_int($errors) || ctype_digit($errors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errors, true), gettype($errors)), __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get Total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotal()
    {
        return isset($this->Total) ? $this->Total : null;
    }
    /**
     * Set Total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $total
     * @return \StructType\ImportEntityStatistics
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->Total);
        } else {
            $this->Total = $total;
        }
        return $this;
    }
}
