<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageMediaRepresentation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ImageMediaRepresentation
 * @subpackage Structs
 */
class ImageMediaRepresentation extends MediaRepresentation
{
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Height;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Width;
    /**
     * Constructor method for ImageMediaRepresentation
     * @uses ImageMediaRepresentation::setHeight()
     * @uses ImageMediaRepresentation::setWidth()
     * @param int $height
     * @param int $width
     */
    public function __construct($height = null, $width = null)
    {
        $this
            ->setHeight($height)
            ->setWidth($width);
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \StructType\ImageMediaRepresentation
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \StructType\ImageMediaRepresentation
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
}
