<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:IdCollection
 * @subpackage Structs
 */
class IdCollection extends AbstractStructBase
{
    /**
     * The Ids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNullableOflong
     */
    public $Ids;
    /**
     * Constructor method for IdCollection
     * @uses IdCollection::setIds()
     * @param \ArrayType\ArrayOfNullableOflong $ids
     */
    public function __construct(\ArrayType\ArrayOfNullableOflong $ids = null)
    {
        $this
            ->setIds($ids);
    }
    /**
     * Get Ids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNullableOflong|null
     */
    public function getIds()
    {
        return isset($this->Ids) ? $this->Ids : null;
    }
    /**
     * Set Ids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNullableOflong $ids
     * @return \StructType\IdCollection
     */
    public function setIds(\ArrayType\ArrayOfNullableOflong $ids = null)
    {
        if (is_null($ids) || (is_array($ids) && empty($ids))) {
            unset($this->Ids);
        } else {
            $this->Ids = $ids;
        }
        return $this;
    }
}
