<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoogleImportOption StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GoogleImportOption
 * @subpackage Structs
 */
class GoogleImportOption extends ImportOption
{
    /**
     * The AccountUrlOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AccountUrlOptions;
    /**
     * The AdScheduleUseSearcherTimezone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AdScheduleUseSearcherTimezone;
    /**
     * The AdjustmentForBids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AdjustmentForBids;
    /**
     * The AdjustmentForCampaignBudgets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AdjustmentForCampaignBudgets;
    /**
     * The AssociatedStoreId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AssociatedStoreId;
    /**
     * The AssociatedUetTagId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AssociatedUetTagId;
    /**
     * The AutoDeviceBidOptimization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutoDeviceBidOptimization;
    /**
     * The DeleteRemovedEntities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DeleteRemovedEntities;
    /**
     * The EnableAutoCurrencyConversion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnableAutoCurrencyConversion;
    /**
     * The EnableParentLocationMapping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnableParentLocationMapping;
    /**
     * The NewActiveAdsForExistingAdGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewActiveAdsForExistingAdGroups;
    /**
     * The NewActiveCampaignsAndChildEntities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewActiveCampaignsAndChildEntities;
    /**
     * The NewAdCustomizerFeeds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewAdCustomizerFeeds;
    /**
     * The NewAdGroupsAndChildEntitiesForExistingCampaigns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewAdGroupsAndChildEntitiesForExistingCampaigns;
    /**
     * The NewAdSchedules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewAdSchedules;
    /**
     * The NewAppAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewAppAdExtensions;
    /**
     * The NewAudienceTargets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewAudienceTargets;
    /**
     * The NewCallAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewCallAdExtensions;
    /**
     * The NewCalloutAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewCalloutAdExtensions;
    /**
     * The NewDemographicTargets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewDemographicTargets;
    /**
     * The NewDeviceTargets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewDeviceTargets;
    /**
     * The NewEntities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewEntities;
    /**
     * The NewKeywordUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewKeywordUrls;
    /**
     * The NewKeywordsForExistingAdGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewKeywordsForExistingAdGroups;
    /**
     * The NewLabels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewLabels;
    /**
     * The NewLocationAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewLocationAdExtensions;
    /**
     * The NewLocationTargets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewLocationTargets;
    /**
     * The NewNegativeKeywordLists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewNegativeKeywordLists;
    /**
     * The NewNegativeKeywordsForExistingParents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewNegativeKeywordsForExistingParents;
    /**
     * The NewNegativeSites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewNegativeSites;
    /**
     * The NewPageFeeds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewPageFeeds;
    /**
     * The NewPausedAdsForExistingAdGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewPausedAdsForExistingAdGroups;
    /**
     * The NewPausedCampaignsAndChildEntities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewPausedCampaignsAndChildEntities;
    /**
     * The NewPriceAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewPriceAdExtensions;
    /**
     * The NewProductFilters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewProductFilters;
    /**
     * The NewPromotionAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewPromotionAdExtensions;
    /**
     * The NewReviewAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewReviewAdExtensions;
    /**
     * The NewSitelinkAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewSitelinkAdExtensions;
    /**
     * The NewStructuredSnippetAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewStructuredSnippetAdExtensions;
    /**
     * The NewUrlOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewUrlOptions;
    /**
     * The PauseAIMAdGroupIfAllAudienceCriterionNotImported
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PauseAIMAdGroupIfAllAudienceCriterionNotImported;
    /**
     * The PauseCampaignsWithoutSupportedLocations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PauseCampaignsWithoutSupportedLocations;
    /**
     * The PauseNewCampaigns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PauseNewCampaigns;
    /**
     * The RaiseBidsToMinimum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RaiseBidsToMinimum;
    /**
     * The RaiseCampaignBudgetsToMinimum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RaiseCampaignBudgetsToMinimum;
    /**
     * The RaiseProductGroupBidsToMinimum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RaiseProductGroupBidsToMinimum;
    /**
     * The SearchAndDsaMixedCampaignAsSearchCampaign
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SearchAndDsaMixedCampaignAsSearchCampaign;
    /**
     * The SearchAndReplaceForCampaignNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ImportSearchAndReplaceForStringProperty
     */
    public $SearchAndReplaceForCampaignNames;
    /**
     * The SearchAndReplaceForCustomParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ImportSearchAndReplaceForStringProperty
     */
    public $SearchAndReplaceForCustomParameters;
    /**
     * The SearchAndReplaceForTrackingTemplates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ImportSearchAndReplaceForStringProperty
     */
    public $SearchAndReplaceForTrackingTemplates;
    /**
     * The SearchAndReplaceForUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ImportSearchAndReplaceForStringProperty
     */
    public $SearchAndReplaceForUrls;
    /**
     * The SuffixForCampaignNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SuffixForCampaignNames;
    /**
     * The SuffixForTrackingTemplates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SuffixForTrackingTemplates;
    /**
     * The SuffixForUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SuffixForUrls;
    /**
     * The UpdateAdCustomizerFeeds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateAdCustomizerFeeds;
    /**
     * The UpdateAdGroupNetwork
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateAdGroupNetwork;
    /**
     * The UpdateAdSchedules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateAdSchedules;
    /**
     * The UpdateAppAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateAppAdExtensions;
    /**
     * The UpdateAudienceTargets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateAudienceTargets;
    /**
     * The UpdateBiddingStrategies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateBiddingStrategies;
    /**
     * The UpdateBids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateBids;
    /**
     * The UpdateCallAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateCallAdExtensions;
    /**
     * The UpdateCalloutAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateCalloutAdExtensions;
    /**
     * The UpdateCampaignAdGroupLanguages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateCampaignAdGroupLanguages;
    /**
     * The UpdateCampaignBudgets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateCampaignBudgets;
    /**
     * The UpdateCampaignNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateCampaignNames;
    /**
     * The UpdateDemographicTargets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateDemographicTargets;
    /**
     * The UpdateDeviceTargets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateDeviceTargets;
    /**
     * The UpdateEntities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateEntities;
    /**
     * The UpdateKeywordUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateKeywordUrls;
    /**
     * The UpdateLabels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateLabels;
    /**
     * The UpdateLocationAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateLocationAdExtensions;
    /**
     * The UpdateLocationTargets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateLocationTargets;
    /**
     * The UpdateNegativeKeywordLists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateNegativeKeywordLists;
    /**
     * The UpdateNegativeSites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateNegativeSites;
    /**
     * The UpdatePageFeeds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdatePageFeeds;
    /**
     * The UpdatePriceAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdatePriceAdExtensions;
    /**
     * The UpdateProductFilters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateProductFilters;
    /**
     * The UpdatePromotionAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdatePromotionAdExtensions;
    /**
     * The UpdateReviewAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateReviewAdExtensions;
    /**
     * The UpdateSitelinkAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateSitelinkAdExtensions;
    /**
     * The UpdateStatusForAdGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateStatusForAdGroups;
    /**
     * The UpdateStatusForAds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateStatusForAds;
    /**
     * The UpdateStatusForCampaigns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateStatusForCampaigns;
    /**
     * The UpdateStatusForKeywords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateStatusForKeywords;
    /**
     * The UpdateStructuredSnippetAdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateStructuredSnippetAdExtensions;
    /**
     * The UpdateUrlOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateUrlOptions;
    /**
     * Constructor method for GoogleImportOption
     * @uses GoogleImportOption::setAccountUrlOptions()
     * @uses GoogleImportOption::setAdScheduleUseSearcherTimezone()
     * @uses GoogleImportOption::setAdjustmentForBids()
     * @uses GoogleImportOption::setAdjustmentForCampaignBudgets()
     * @uses GoogleImportOption::setAssociatedStoreId()
     * @uses GoogleImportOption::setAssociatedUetTagId()
     * @uses GoogleImportOption::setAutoDeviceBidOptimization()
     * @uses GoogleImportOption::setDeleteRemovedEntities()
     * @uses GoogleImportOption::setEnableAutoCurrencyConversion()
     * @uses GoogleImportOption::setEnableParentLocationMapping()
     * @uses GoogleImportOption::setNewActiveAdsForExistingAdGroups()
     * @uses GoogleImportOption::setNewActiveCampaignsAndChildEntities()
     * @uses GoogleImportOption::setNewAdCustomizerFeeds()
     * @uses GoogleImportOption::setNewAdGroupsAndChildEntitiesForExistingCampaigns()
     * @uses GoogleImportOption::setNewAdSchedules()
     * @uses GoogleImportOption::setNewAppAdExtensions()
     * @uses GoogleImportOption::setNewAudienceTargets()
     * @uses GoogleImportOption::setNewCallAdExtensions()
     * @uses GoogleImportOption::setNewCalloutAdExtensions()
     * @uses GoogleImportOption::setNewDemographicTargets()
     * @uses GoogleImportOption::setNewDeviceTargets()
     * @uses GoogleImportOption::setNewEntities()
     * @uses GoogleImportOption::setNewKeywordUrls()
     * @uses GoogleImportOption::setNewKeywordsForExistingAdGroups()
     * @uses GoogleImportOption::setNewLabels()
     * @uses GoogleImportOption::setNewLocationAdExtensions()
     * @uses GoogleImportOption::setNewLocationTargets()
     * @uses GoogleImportOption::setNewNegativeKeywordLists()
     * @uses GoogleImportOption::setNewNegativeKeywordsForExistingParents()
     * @uses GoogleImportOption::setNewNegativeSites()
     * @uses GoogleImportOption::setNewPageFeeds()
     * @uses GoogleImportOption::setNewPausedAdsForExistingAdGroups()
     * @uses GoogleImportOption::setNewPausedCampaignsAndChildEntities()
     * @uses GoogleImportOption::setNewPriceAdExtensions()
     * @uses GoogleImportOption::setNewProductFilters()
     * @uses GoogleImportOption::setNewPromotionAdExtensions()
     * @uses GoogleImportOption::setNewReviewAdExtensions()
     * @uses GoogleImportOption::setNewSitelinkAdExtensions()
     * @uses GoogleImportOption::setNewStructuredSnippetAdExtensions()
     * @uses GoogleImportOption::setNewUrlOptions()
     * @uses GoogleImportOption::setPauseAIMAdGroupIfAllAudienceCriterionNotImported()
     * @uses GoogleImportOption::setPauseCampaignsWithoutSupportedLocations()
     * @uses GoogleImportOption::setPauseNewCampaigns()
     * @uses GoogleImportOption::setRaiseBidsToMinimum()
     * @uses GoogleImportOption::setRaiseCampaignBudgetsToMinimum()
     * @uses GoogleImportOption::setRaiseProductGroupBidsToMinimum()
     * @uses GoogleImportOption::setSearchAndDsaMixedCampaignAsSearchCampaign()
     * @uses GoogleImportOption::setSearchAndReplaceForCampaignNames()
     * @uses GoogleImportOption::setSearchAndReplaceForCustomParameters()
     * @uses GoogleImportOption::setSearchAndReplaceForTrackingTemplates()
     * @uses GoogleImportOption::setSearchAndReplaceForUrls()
     * @uses GoogleImportOption::setSuffixForCampaignNames()
     * @uses GoogleImportOption::setSuffixForTrackingTemplates()
     * @uses GoogleImportOption::setSuffixForUrls()
     * @uses GoogleImportOption::setUpdateAdCustomizerFeeds()
     * @uses GoogleImportOption::setUpdateAdGroupNetwork()
     * @uses GoogleImportOption::setUpdateAdSchedules()
     * @uses GoogleImportOption::setUpdateAppAdExtensions()
     * @uses GoogleImportOption::setUpdateAudienceTargets()
     * @uses GoogleImportOption::setUpdateBiddingStrategies()
     * @uses GoogleImportOption::setUpdateBids()
     * @uses GoogleImportOption::setUpdateCallAdExtensions()
     * @uses GoogleImportOption::setUpdateCalloutAdExtensions()
     * @uses GoogleImportOption::setUpdateCampaignAdGroupLanguages()
     * @uses GoogleImportOption::setUpdateCampaignBudgets()
     * @uses GoogleImportOption::setUpdateCampaignNames()
     * @uses GoogleImportOption::setUpdateDemographicTargets()
     * @uses GoogleImportOption::setUpdateDeviceTargets()
     * @uses GoogleImportOption::setUpdateEntities()
     * @uses GoogleImportOption::setUpdateKeywordUrls()
     * @uses GoogleImportOption::setUpdateLabels()
     * @uses GoogleImportOption::setUpdateLocationAdExtensions()
     * @uses GoogleImportOption::setUpdateLocationTargets()
     * @uses GoogleImportOption::setUpdateNegativeKeywordLists()
     * @uses GoogleImportOption::setUpdateNegativeSites()
     * @uses GoogleImportOption::setUpdatePageFeeds()
     * @uses GoogleImportOption::setUpdatePriceAdExtensions()
     * @uses GoogleImportOption::setUpdateProductFilters()
     * @uses GoogleImportOption::setUpdatePromotionAdExtensions()
     * @uses GoogleImportOption::setUpdateReviewAdExtensions()
     * @uses GoogleImportOption::setUpdateSitelinkAdExtensions()
     * @uses GoogleImportOption::setUpdateStatusForAdGroups()
     * @uses GoogleImportOption::setUpdateStatusForAds()
     * @uses GoogleImportOption::setUpdateStatusForCampaigns()
     * @uses GoogleImportOption::setUpdateStatusForKeywords()
     * @uses GoogleImportOption::setUpdateStructuredSnippetAdExtensions()
     * @uses GoogleImportOption::setUpdateUrlOptions()
     * @param bool $accountUrlOptions
     * @param bool $adScheduleUseSearcherTimezone
     * @param float $adjustmentForBids
     * @param float $adjustmentForCampaignBudgets
     * @param int $associatedStoreId
     * @param int $associatedUetTagId
     * @param bool $autoDeviceBidOptimization
     * @param bool $deleteRemovedEntities
     * @param bool $enableAutoCurrencyConversion
     * @param bool $enableParentLocationMapping
     * @param bool $newActiveAdsForExistingAdGroups
     * @param bool $newActiveCampaignsAndChildEntities
     * @param bool $newAdCustomizerFeeds
     * @param bool $newAdGroupsAndChildEntitiesForExistingCampaigns
     * @param bool $newAdSchedules
     * @param bool $newAppAdExtensions
     * @param bool $newAudienceTargets
     * @param bool $newCallAdExtensions
     * @param bool $newCalloutAdExtensions
     * @param bool $newDemographicTargets
     * @param bool $newDeviceTargets
     * @param bool $newEntities
     * @param bool $newKeywordUrls
     * @param bool $newKeywordsForExistingAdGroups
     * @param bool $newLabels
     * @param bool $newLocationAdExtensions
     * @param bool $newLocationTargets
     * @param bool $newNegativeKeywordLists
     * @param bool $newNegativeKeywordsForExistingParents
     * @param bool $newNegativeSites
     * @param bool $newPageFeeds
     * @param bool $newPausedAdsForExistingAdGroups
     * @param bool $newPausedCampaignsAndChildEntities
     * @param bool $newPriceAdExtensions
     * @param bool $newProductFilters
     * @param bool $newPromotionAdExtensions
     * @param bool $newReviewAdExtensions
     * @param bool $newSitelinkAdExtensions
     * @param bool $newStructuredSnippetAdExtensions
     * @param bool $newUrlOptions
     * @param bool $pauseAIMAdGroupIfAllAudienceCriterionNotImported
     * @param bool $pauseCampaignsWithoutSupportedLocations
     * @param bool $pauseNewCampaigns
     * @param bool $raiseBidsToMinimum
     * @param bool $raiseCampaignBudgetsToMinimum
     * @param bool $raiseProductGroupBidsToMinimum
     * @param bool $searchAndDsaMixedCampaignAsSearchCampaign
     * @param \StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForCampaignNames
     * @param \StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForCustomParameters
     * @param \StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForTrackingTemplates
     * @param \StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForUrls
     * @param string $suffixForCampaignNames
     * @param string $suffixForTrackingTemplates
     * @param string $suffixForUrls
     * @param bool $updateAdCustomizerFeeds
     * @param bool $updateAdGroupNetwork
     * @param bool $updateAdSchedules
     * @param bool $updateAppAdExtensions
     * @param bool $updateAudienceTargets
     * @param bool $updateBiddingStrategies
     * @param bool $updateBids
     * @param bool $updateCallAdExtensions
     * @param bool $updateCalloutAdExtensions
     * @param bool $updateCampaignAdGroupLanguages
     * @param bool $updateCampaignBudgets
     * @param bool $updateCampaignNames
     * @param bool $updateDemographicTargets
     * @param bool $updateDeviceTargets
     * @param bool $updateEntities
     * @param bool $updateKeywordUrls
     * @param bool $updateLabels
     * @param bool $updateLocationAdExtensions
     * @param bool $updateLocationTargets
     * @param bool $updateNegativeKeywordLists
     * @param bool $updateNegativeSites
     * @param bool $updatePageFeeds
     * @param bool $updatePriceAdExtensions
     * @param bool $updateProductFilters
     * @param bool $updatePromotionAdExtensions
     * @param bool $updateReviewAdExtensions
     * @param bool $updateSitelinkAdExtensions
     * @param bool $updateStatusForAdGroups
     * @param bool $updateStatusForAds
     * @param bool $updateStatusForCampaigns
     * @param bool $updateStatusForKeywords
     * @param bool $updateStructuredSnippetAdExtensions
     * @param bool $updateUrlOptions
     */
    public function __construct($accountUrlOptions = null, $adScheduleUseSearcherTimezone = null, $adjustmentForBids = null, $adjustmentForCampaignBudgets = null, $associatedStoreId = null, $associatedUetTagId = null, $autoDeviceBidOptimization = null, $deleteRemovedEntities = null, $enableAutoCurrencyConversion = null, $enableParentLocationMapping = null, $newActiveAdsForExistingAdGroups = null, $newActiveCampaignsAndChildEntities = null, $newAdCustomizerFeeds = null, $newAdGroupsAndChildEntitiesForExistingCampaigns = null, $newAdSchedules = null, $newAppAdExtensions = null, $newAudienceTargets = null, $newCallAdExtensions = null, $newCalloutAdExtensions = null, $newDemographicTargets = null, $newDeviceTargets = null, $newEntities = null, $newKeywordUrls = null, $newKeywordsForExistingAdGroups = null, $newLabels = null, $newLocationAdExtensions = null, $newLocationTargets = null, $newNegativeKeywordLists = null, $newNegativeKeywordsForExistingParents = null, $newNegativeSites = null, $newPageFeeds = null, $newPausedAdsForExistingAdGroups = null, $newPausedCampaignsAndChildEntities = null, $newPriceAdExtensions = null, $newProductFilters = null, $newPromotionAdExtensions = null, $newReviewAdExtensions = null, $newSitelinkAdExtensions = null, $newStructuredSnippetAdExtensions = null, $newUrlOptions = null, $pauseAIMAdGroupIfAllAudienceCriterionNotImported = null, $pauseCampaignsWithoutSupportedLocations = null, $pauseNewCampaigns = null, $raiseBidsToMinimum = null, $raiseCampaignBudgetsToMinimum = null, $raiseProductGroupBidsToMinimum = null, $searchAndDsaMixedCampaignAsSearchCampaign = null, \StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForCampaignNames = null, \StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForCustomParameters = null, \StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForTrackingTemplates = null, \StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForUrls = null, $suffixForCampaignNames = null, $suffixForTrackingTemplates = null, $suffixForUrls = null, $updateAdCustomizerFeeds = null, $updateAdGroupNetwork = null, $updateAdSchedules = null, $updateAppAdExtensions = null, $updateAudienceTargets = null, $updateBiddingStrategies = null, $updateBids = null, $updateCallAdExtensions = null, $updateCalloutAdExtensions = null, $updateCampaignAdGroupLanguages = null, $updateCampaignBudgets = null, $updateCampaignNames = null, $updateDemographicTargets = null, $updateDeviceTargets = null, $updateEntities = null, $updateKeywordUrls = null, $updateLabels = null, $updateLocationAdExtensions = null, $updateLocationTargets = null, $updateNegativeKeywordLists = null, $updateNegativeSites = null, $updatePageFeeds = null, $updatePriceAdExtensions = null, $updateProductFilters = null, $updatePromotionAdExtensions = null, $updateReviewAdExtensions = null, $updateSitelinkAdExtensions = null, $updateStatusForAdGroups = null, $updateStatusForAds = null, $updateStatusForCampaigns = null, $updateStatusForKeywords = null, $updateStructuredSnippetAdExtensions = null, $updateUrlOptions = null)
    {
        $this
            ->setAccountUrlOptions($accountUrlOptions)
            ->setAdScheduleUseSearcherTimezone($adScheduleUseSearcherTimezone)
            ->setAdjustmentForBids($adjustmentForBids)
            ->setAdjustmentForCampaignBudgets($adjustmentForCampaignBudgets)
            ->setAssociatedStoreId($associatedStoreId)
            ->setAssociatedUetTagId($associatedUetTagId)
            ->setAutoDeviceBidOptimization($autoDeviceBidOptimization)
            ->setDeleteRemovedEntities($deleteRemovedEntities)
            ->setEnableAutoCurrencyConversion($enableAutoCurrencyConversion)
            ->setEnableParentLocationMapping($enableParentLocationMapping)
            ->setNewActiveAdsForExistingAdGroups($newActiveAdsForExistingAdGroups)
            ->setNewActiveCampaignsAndChildEntities($newActiveCampaignsAndChildEntities)
            ->setNewAdCustomizerFeeds($newAdCustomizerFeeds)
            ->setNewAdGroupsAndChildEntitiesForExistingCampaigns($newAdGroupsAndChildEntitiesForExistingCampaigns)
            ->setNewAdSchedules($newAdSchedules)
            ->setNewAppAdExtensions($newAppAdExtensions)
            ->setNewAudienceTargets($newAudienceTargets)
            ->setNewCallAdExtensions($newCallAdExtensions)
            ->setNewCalloutAdExtensions($newCalloutAdExtensions)
            ->setNewDemographicTargets($newDemographicTargets)
            ->setNewDeviceTargets($newDeviceTargets)
            ->setNewEntities($newEntities)
            ->setNewKeywordUrls($newKeywordUrls)
            ->setNewKeywordsForExistingAdGroups($newKeywordsForExistingAdGroups)
            ->setNewLabels($newLabels)
            ->setNewLocationAdExtensions($newLocationAdExtensions)
            ->setNewLocationTargets($newLocationTargets)
            ->setNewNegativeKeywordLists($newNegativeKeywordLists)
            ->setNewNegativeKeywordsForExistingParents($newNegativeKeywordsForExistingParents)
            ->setNewNegativeSites($newNegativeSites)
            ->setNewPageFeeds($newPageFeeds)
            ->setNewPausedAdsForExistingAdGroups($newPausedAdsForExistingAdGroups)
            ->setNewPausedCampaignsAndChildEntities($newPausedCampaignsAndChildEntities)
            ->setNewPriceAdExtensions($newPriceAdExtensions)
            ->setNewProductFilters($newProductFilters)
            ->setNewPromotionAdExtensions($newPromotionAdExtensions)
            ->setNewReviewAdExtensions($newReviewAdExtensions)
            ->setNewSitelinkAdExtensions($newSitelinkAdExtensions)
            ->setNewStructuredSnippetAdExtensions($newStructuredSnippetAdExtensions)
            ->setNewUrlOptions($newUrlOptions)
            ->setPauseAIMAdGroupIfAllAudienceCriterionNotImported($pauseAIMAdGroupIfAllAudienceCriterionNotImported)
            ->setPauseCampaignsWithoutSupportedLocations($pauseCampaignsWithoutSupportedLocations)
            ->setPauseNewCampaigns($pauseNewCampaigns)
            ->setRaiseBidsToMinimum($raiseBidsToMinimum)
            ->setRaiseCampaignBudgetsToMinimum($raiseCampaignBudgetsToMinimum)
            ->setRaiseProductGroupBidsToMinimum($raiseProductGroupBidsToMinimum)
            ->setSearchAndDsaMixedCampaignAsSearchCampaign($searchAndDsaMixedCampaignAsSearchCampaign)
            ->setSearchAndReplaceForCampaignNames($searchAndReplaceForCampaignNames)
            ->setSearchAndReplaceForCustomParameters($searchAndReplaceForCustomParameters)
            ->setSearchAndReplaceForTrackingTemplates($searchAndReplaceForTrackingTemplates)
            ->setSearchAndReplaceForUrls($searchAndReplaceForUrls)
            ->setSuffixForCampaignNames($suffixForCampaignNames)
            ->setSuffixForTrackingTemplates($suffixForTrackingTemplates)
            ->setSuffixForUrls($suffixForUrls)
            ->setUpdateAdCustomizerFeeds($updateAdCustomizerFeeds)
            ->setUpdateAdGroupNetwork($updateAdGroupNetwork)
            ->setUpdateAdSchedules($updateAdSchedules)
            ->setUpdateAppAdExtensions($updateAppAdExtensions)
            ->setUpdateAudienceTargets($updateAudienceTargets)
            ->setUpdateBiddingStrategies($updateBiddingStrategies)
            ->setUpdateBids($updateBids)
            ->setUpdateCallAdExtensions($updateCallAdExtensions)
            ->setUpdateCalloutAdExtensions($updateCalloutAdExtensions)
            ->setUpdateCampaignAdGroupLanguages($updateCampaignAdGroupLanguages)
            ->setUpdateCampaignBudgets($updateCampaignBudgets)
            ->setUpdateCampaignNames($updateCampaignNames)
            ->setUpdateDemographicTargets($updateDemographicTargets)
            ->setUpdateDeviceTargets($updateDeviceTargets)
            ->setUpdateEntities($updateEntities)
            ->setUpdateKeywordUrls($updateKeywordUrls)
            ->setUpdateLabels($updateLabels)
            ->setUpdateLocationAdExtensions($updateLocationAdExtensions)
            ->setUpdateLocationTargets($updateLocationTargets)
            ->setUpdateNegativeKeywordLists($updateNegativeKeywordLists)
            ->setUpdateNegativeSites($updateNegativeSites)
            ->setUpdatePageFeeds($updatePageFeeds)
            ->setUpdatePriceAdExtensions($updatePriceAdExtensions)
            ->setUpdateProductFilters($updateProductFilters)
            ->setUpdatePromotionAdExtensions($updatePromotionAdExtensions)
            ->setUpdateReviewAdExtensions($updateReviewAdExtensions)
            ->setUpdateSitelinkAdExtensions($updateSitelinkAdExtensions)
            ->setUpdateStatusForAdGroups($updateStatusForAdGroups)
            ->setUpdateStatusForAds($updateStatusForAds)
            ->setUpdateStatusForCampaigns($updateStatusForCampaigns)
            ->setUpdateStatusForKeywords($updateStatusForKeywords)
            ->setUpdateStructuredSnippetAdExtensions($updateStructuredSnippetAdExtensions)
            ->setUpdateUrlOptions($updateUrlOptions);
    }
    /**
     * Get AccountUrlOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAccountUrlOptions()
    {
        return isset($this->AccountUrlOptions) ? $this->AccountUrlOptions : null;
    }
    /**
     * Set AccountUrlOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $accountUrlOptions
     * @return \StructType\GoogleImportOption
     */
    public function setAccountUrlOptions($accountUrlOptions = null)
    {
        // validation for constraint: boolean
        if (!is_null($accountUrlOptions) && !is_bool($accountUrlOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accountUrlOptions, true), gettype($accountUrlOptions)), __LINE__);
        }
        if (is_null($accountUrlOptions) || (is_array($accountUrlOptions) && empty($accountUrlOptions))) {
            unset($this->AccountUrlOptions);
        } else {
            $this->AccountUrlOptions = $accountUrlOptions;
        }
        return $this;
    }
    /**
     * Get AdScheduleUseSearcherTimezone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAdScheduleUseSearcherTimezone()
    {
        return isset($this->AdScheduleUseSearcherTimezone) ? $this->AdScheduleUseSearcherTimezone : null;
    }
    /**
     * Set AdScheduleUseSearcherTimezone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $adScheduleUseSearcherTimezone
     * @return \StructType\GoogleImportOption
     */
    public function setAdScheduleUseSearcherTimezone($adScheduleUseSearcherTimezone = null)
    {
        // validation for constraint: boolean
        if (!is_null($adScheduleUseSearcherTimezone) && !is_bool($adScheduleUseSearcherTimezone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($adScheduleUseSearcherTimezone, true), gettype($adScheduleUseSearcherTimezone)), __LINE__);
        }
        if (is_null($adScheduleUseSearcherTimezone) || (is_array($adScheduleUseSearcherTimezone) && empty($adScheduleUseSearcherTimezone))) {
            unset($this->AdScheduleUseSearcherTimezone);
        } else {
            $this->AdScheduleUseSearcherTimezone = $adScheduleUseSearcherTimezone;
        }
        return $this;
    }
    /**
     * Get AdjustmentForBids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAdjustmentForBids()
    {
        return isset($this->AdjustmentForBids) ? $this->AdjustmentForBids : null;
    }
    /**
     * Set AdjustmentForBids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $adjustmentForBids
     * @return \StructType\GoogleImportOption
     */
    public function setAdjustmentForBids($adjustmentForBids = null)
    {
        // validation for constraint: float
        if (!is_null($adjustmentForBids) && !(is_float($adjustmentForBids) || is_numeric($adjustmentForBids))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adjustmentForBids, true), gettype($adjustmentForBids)), __LINE__);
        }
        if (is_null($adjustmentForBids) || (is_array($adjustmentForBids) && empty($adjustmentForBids))) {
            unset($this->AdjustmentForBids);
        } else {
            $this->AdjustmentForBids = $adjustmentForBids;
        }
        return $this;
    }
    /**
     * Get AdjustmentForCampaignBudgets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAdjustmentForCampaignBudgets()
    {
        return isset($this->AdjustmentForCampaignBudgets) ? $this->AdjustmentForCampaignBudgets : null;
    }
    /**
     * Set AdjustmentForCampaignBudgets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $adjustmentForCampaignBudgets
     * @return \StructType\GoogleImportOption
     */
    public function setAdjustmentForCampaignBudgets($adjustmentForCampaignBudgets = null)
    {
        // validation for constraint: float
        if (!is_null($adjustmentForCampaignBudgets) && !(is_float($adjustmentForCampaignBudgets) || is_numeric($adjustmentForCampaignBudgets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adjustmentForCampaignBudgets, true), gettype($adjustmentForCampaignBudgets)), __LINE__);
        }
        if (is_null($adjustmentForCampaignBudgets) || (is_array($adjustmentForCampaignBudgets) && empty($adjustmentForCampaignBudgets))) {
            unset($this->AdjustmentForCampaignBudgets);
        } else {
            $this->AdjustmentForCampaignBudgets = $adjustmentForCampaignBudgets;
        }
        return $this;
    }
    /**
     * Get AssociatedStoreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAssociatedStoreId()
    {
        return isset($this->AssociatedStoreId) ? $this->AssociatedStoreId : null;
    }
    /**
     * Set AssociatedStoreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $associatedStoreId
     * @return \StructType\GoogleImportOption
     */
    public function setAssociatedStoreId($associatedStoreId = null)
    {
        // validation for constraint: int
        if (!is_null($associatedStoreId) && !(is_int($associatedStoreId) || ctype_digit($associatedStoreId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($associatedStoreId, true), gettype($associatedStoreId)), __LINE__);
        }
        if (is_null($associatedStoreId) || (is_array($associatedStoreId) && empty($associatedStoreId))) {
            unset($this->AssociatedStoreId);
        } else {
            $this->AssociatedStoreId = $associatedStoreId;
        }
        return $this;
    }
    /**
     * Get AssociatedUetTagId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAssociatedUetTagId()
    {
        return isset($this->AssociatedUetTagId) ? $this->AssociatedUetTagId : null;
    }
    /**
     * Set AssociatedUetTagId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $associatedUetTagId
     * @return \StructType\GoogleImportOption
     */
    public function setAssociatedUetTagId($associatedUetTagId = null)
    {
        // validation for constraint: int
        if (!is_null($associatedUetTagId) && !(is_int($associatedUetTagId) || ctype_digit($associatedUetTagId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($associatedUetTagId, true), gettype($associatedUetTagId)), __LINE__);
        }
        if (is_null($associatedUetTagId) || (is_array($associatedUetTagId) && empty($associatedUetTagId))) {
            unset($this->AssociatedUetTagId);
        } else {
            $this->AssociatedUetTagId = $associatedUetTagId;
        }
        return $this;
    }
    /**
     * Get AutoDeviceBidOptimization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutoDeviceBidOptimization()
    {
        return isset($this->AutoDeviceBidOptimization) ? $this->AutoDeviceBidOptimization : null;
    }
    /**
     * Set AutoDeviceBidOptimization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $autoDeviceBidOptimization
     * @return \StructType\GoogleImportOption
     */
    public function setAutoDeviceBidOptimization($autoDeviceBidOptimization = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoDeviceBidOptimization) && !is_bool($autoDeviceBidOptimization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoDeviceBidOptimization, true), gettype($autoDeviceBidOptimization)), __LINE__);
        }
        if (is_null($autoDeviceBidOptimization) || (is_array($autoDeviceBidOptimization) && empty($autoDeviceBidOptimization))) {
            unset($this->AutoDeviceBidOptimization);
        } else {
            $this->AutoDeviceBidOptimization = $autoDeviceBidOptimization;
        }
        return $this;
    }
    /**
     * Get DeleteRemovedEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDeleteRemovedEntities()
    {
        return isset($this->DeleteRemovedEntities) ? $this->DeleteRemovedEntities : null;
    }
    /**
     * Set DeleteRemovedEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $deleteRemovedEntities
     * @return \StructType\GoogleImportOption
     */
    public function setDeleteRemovedEntities($deleteRemovedEntities = null)
    {
        // validation for constraint: boolean
        if (!is_null($deleteRemovedEntities) && !is_bool($deleteRemovedEntities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deleteRemovedEntities, true), gettype($deleteRemovedEntities)), __LINE__);
        }
        if (is_null($deleteRemovedEntities) || (is_array($deleteRemovedEntities) && empty($deleteRemovedEntities))) {
            unset($this->DeleteRemovedEntities);
        } else {
            $this->DeleteRemovedEntities = $deleteRemovedEntities;
        }
        return $this;
    }
    /**
     * Get EnableAutoCurrencyConversion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnableAutoCurrencyConversion()
    {
        return isset($this->EnableAutoCurrencyConversion) ? $this->EnableAutoCurrencyConversion : null;
    }
    /**
     * Set EnableAutoCurrencyConversion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enableAutoCurrencyConversion
     * @return \StructType\GoogleImportOption
     */
    public function setEnableAutoCurrencyConversion($enableAutoCurrencyConversion = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableAutoCurrencyConversion) && !is_bool($enableAutoCurrencyConversion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableAutoCurrencyConversion, true), gettype($enableAutoCurrencyConversion)), __LINE__);
        }
        if (is_null($enableAutoCurrencyConversion) || (is_array($enableAutoCurrencyConversion) && empty($enableAutoCurrencyConversion))) {
            unset($this->EnableAutoCurrencyConversion);
        } else {
            $this->EnableAutoCurrencyConversion = $enableAutoCurrencyConversion;
        }
        return $this;
    }
    /**
     * Get EnableParentLocationMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnableParentLocationMapping()
    {
        return isset($this->EnableParentLocationMapping) ? $this->EnableParentLocationMapping : null;
    }
    /**
     * Set EnableParentLocationMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enableParentLocationMapping
     * @return \StructType\GoogleImportOption
     */
    public function setEnableParentLocationMapping($enableParentLocationMapping = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableParentLocationMapping) && !is_bool($enableParentLocationMapping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableParentLocationMapping, true), gettype($enableParentLocationMapping)), __LINE__);
        }
        if (is_null($enableParentLocationMapping) || (is_array($enableParentLocationMapping) && empty($enableParentLocationMapping))) {
            unset($this->EnableParentLocationMapping);
        } else {
            $this->EnableParentLocationMapping = $enableParentLocationMapping;
        }
        return $this;
    }
    /**
     * Get NewActiveAdsForExistingAdGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewActiveAdsForExistingAdGroups()
    {
        return isset($this->NewActiveAdsForExistingAdGroups) ? $this->NewActiveAdsForExistingAdGroups : null;
    }
    /**
     * Set NewActiveAdsForExistingAdGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newActiveAdsForExistingAdGroups
     * @return \StructType\GoogleImportOption
     */
    public function setNewActiveAdsForExistingAdGroups($newActiveAdsForExistingAdGroups = null)
    {
        // validation for constraint: boolean
        if (!is_null($newActiveAdsForExistingAdGroups) && !is_bool($newActiveAdsForExistingAdGroups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newActiveAdsForExistingAdGroups, true), gettype($newActiveAdsForExistingAdGroups)), __LINE__);
        }
        if (is_null($newActiveAdsForExistingAdGroups) || (is_array($newActiveAdsForExistingAdGroups) && empty($newActiveAdsForExistingAdGroups))) {
            unset($this->NewActiveAdsForExistingAdGroups);
        } else {
            $this->NewActiveAdsForExistingAdGroups = $newActiveAdsForExistingAdGroups;
        }
        return $this;
    }
    /**
     * Get NewActiveCampaignsAndChildEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewActiveCampaignsAndChildEntities()
    {
        return isset($this->NewActiveCampaignsAndChildEntities) ? $this->NewActiveCampaignsAndChildEntities : null;
    }
    /**
     * Set NewActiveCampaignsAndChildEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newActiveCampaignsAndChildEntities
     * @return \StructType\GoogleImportOption
     */
    public function setNewActiveCampaignsAndChildEntities($newActiveCampaignsAndChildEntities = null)
    {
        // validation for constraint: boolean
        if (!is_null($newActiveCampaignsAndChildEntities) && !is_bool($newActiveCampaignsAndChildEntities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newActiveCampaignsAndChildEntities, true), gettype($newActiveCampaignsAndChildEntities)), __LINE__);
        }
        if (is_null($newActiveCampaignsAndChildEntities) || (is_array($newActiveCampaignsAndChildEntities) && empty($newActiveCampaignsAndChildEntities))) {
            unset($this->NewActiveCampaignsAndChildEntities);
        } else {
            $this->NewActiveCampaignsAndChildEntities = $newActiveCampaignsAndChildEntities;
        }
        return $this;
    }
    /**
     * Get NewAdCustomizerFeeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewAdCustomizerFeeds()
    {
        return isset($this->NewAdCustomizerFeeds) ? $this->NewAdCustomizerFeeds : null;
    }
    /**
     * Set NewAdCustomizerFeeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newAdCustomizerFeeds
     * @return \StructType\GoogleImportOption
     */
    public function setNewAdCustomizerFeeds($newAdCustomizerFeeds = null)
    {
        // validation for constraint: boolean
        if (!is_null($newAdCustomizerFeeds) && !is_bool($newAdCustomizerFeeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newAdCustomizerFeeds, true), gettype($newAdCustomizerFeeds)), __LINE__);
        }
        if (is_null($newAdCustomizerFeeds) || (is_array($newAdCustomizerFeeds) && empty($newAdCustomizerFeeds))) {
            unset($this->NewAdCustomizerFeeds);
        } else {
            $this->NewAdCustomizerFeeds = $newAdCustomizerFeeds;
        }
        return $this;
    }
    /**
     * Get NewAdGroupsAndChildEntitiesForExistingCampaigns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewAdGroupsAndChildEntitiesForExistingCampaigns()
    {
        return isset($this->NewAdGroupsAndChildEntitiesForExistingCampaigns) ? $this->NewAdGroupsAndChildEntitiesForExistingCampaigns : null;
    }
    /**
     * Set NewAdGroupsAndChildEntitiesForExistingCampaigns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newAdGroupsAndChildEntitiesForExistingCampaigns
     * @return \StructType\GoogleImportOption
     */
    public function setNewAdGroupsAndChildEntitiesForExistingCampaigns($newAdGroupsAndChildEntitiesForExistingCampaigns = null)
    {
        // validation for constraint: boolean
        if (!is_null($newAdGroupsAndChildEntitiesForExistingCampaigns) && !is_bool($newAdGroupsAndChildEntitiesForExistingCampaigns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newAdGroupsAndChildEntitiesForExistingCampaigns, true), gettype($newAdGroupsAndChildEntitiesForExistingCampaigns)), __LINE__);
        }
        if (is_null($newAdGroupsAndChildEntitiesForExistingCampaigns) || (is_array($newAdGroupsAndChildEntitiesForExistingCampaigns) && empty($newAdGroupsAndChildEntitiesForExistingCampaigns))) {
            unset($this->NewAdGroupsAndChildEntitiesForExistingCampaigns);
        } else {
            $this->NewAdGroupsAndChildEntitiesForExistingCampaigns = $newAdGroupsAndChildEntitiesForExistingCampaigns;
        }
        return $this;
    }
    /**
     * Get NewAdSchedules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewAdSchedules()
    {
        return isset($this->NewAdSchedules) ? $this->NewAdSchedules : null;
    }
    /**
     * Set NewAdSchedules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newAdSchedules
     * @return \StructType\GoogleImportOption
     */
    public function setNewAdSchedules($newAdSchedules = null)
    {
        // validation for constraint: boolean
        if (!is_null($newAdSchedules) && !is_bool($newAdSchedules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newAdSchedules, true), gettype($newAdSchedules)), __LINE__);
        }
        if (is_null($newAdSchedules) || (is_array($newAdSchedules) && empty($newAdSchedules))) {
            unset($this->NewAdSchedules);
        } else {
            $this->NewAdSchedules = $newAdSchedules;
        }
        return $this;
    }
    /**
     * Get NewAppAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewAppAdExtensions()
    {
        return isset($this->NewAppAdExtensions) ? $this->NewAppAdExtensions : null;
    }
    /**
     * Set NewAppAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newAppAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setNewAppAdExtensions($newAppAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($newAppAdExtensions) && !is_bool($newAppAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newAppAdExtensions, true), gettype($newAppAdExtensions)), __LINE__);
        }
        if (is_null($newAppAdExtensions) || (is_array($newAppAdExtensions) && empty($newAppAdExtensions))) {
            unset($this->NewAppAdExtensions);
        } else {
            $this->NewAppAdExtensions = $newAppAdExtensions;
        }
        return $this;
    }
    /**
     * Get NewAudienceTargets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewAudienceTargets()
    {
        return isset($this->NewAudienceTargets) ? $this->NewAudienceTargets : null;
    }
    /**
     * Set NewAudienceTargets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newAudienceTargets
     * @return \StructType\GoogleImportOption
     */
    public function setNewAudienceTargets($newAudienceTargets = null)
    {
        // validation for constraint: boolean
        if (!is_null($newAudienceTargets) && !is_bool($newAudienceTargets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newAudienceTargets, true), gettype($newAudienceTargets)), __LINE__);
        }
        if (is_null($newAudienceTargets) || (is_array($newAudienceTargets) && empty($newAudienceTargets))) {
            unset($this->NewAudienceTargets);
        } else {
            $this->NewAudienceTargets = $newAudienceTargets;
        }
        return $this;
    }
    /**
     * Get NewCallAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewCallAdExtensions()
    {
        return isset($this->NewCallAdExtensions) ? $this->NewCallAdExtensions : null;
    }
    /**
     * Set NewCallAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newCallAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setNewCallAdExtensions($newCallAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($newCallAdExtensions) && !is_bool($newCallAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newCallAdExtensions, true), gettype($newCallAdExtensions)), __LINE__);
        }
        if (is_null($newCallAdExtensions) || (is_array($newCallAdExtensions) && empty($newCallAdExtensions))) {
            unset($this->NewCallAdExtensions);
        } else {
            $this->NewCallAdExtensions = $newCallAdExtensions;
        }
        return $this;
    }
    /**
     * Get NewCalloutAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewCalloutAdExtensions()
    {
        return isset($this->NewCalloutAdExtensions) ? $this->NewCalloutAdExtensions : null;
    }
    /**
     * Set NewCalloutAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newCalloutAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setNewCalloutAdExtensions($newCalloutAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($newCalloutAdExtensions) && !is_bool($newCalloutAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newCalloutAdExtensions, true), gettype($newCalloutAdExtensions)), __LINE__);
        }
        if (is_null($newCalloutAdExtensions) || (is_array($newCalloutAdExtensions) && empty($newCalloutAdExtensions))) {
            unset($this->NewCalloutAdExtensions);
        } else {
            $this->NewCalloutAdExtensions = $newCalloutAdExtensions;
        }
        return $this;
    }
    /**
     * Get NewDemographicTargets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewDemographicTargets()
    {
        return isset($this->NewDemographicTargets) ? $this->NewDemographicTargets : null;
    }
    /**
     * Set NewDemographicTargets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newDemographicTargets
     * @return \StructType\GoogleImportOption
     */
    public function setNewDemographicTargets($newDemographicTargets = null)
    {
        // validation for constraint: boolean
        if (!is_null($newDemographicTargets) && !is_bool($newDemographicTargets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newDemographicTargets, true), gettype($newDemographicTargets)), __LINE__);
        }
        if (is_null($newDemographicTargets) || (is_array($newDemographicTargets) && empty($newDemographicTargets))) {
            unset($this->NewDemographicTargets);
        } else {
            $this->NewDemographicTargets = $newDemographicTargets;
        }
        return $this;
    }
    /**
     * Get NewDeviceTargets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewDeviceTargets()
    {
        return isset($this->NewDeviceTargets) ? $this->NewDeviceTargets : null;
    }
    /**
     * Set NewDeviceTargets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newDeviceTargets
     * @return \StructType\GoogleImportOption
     */
    public function setNewDeviceTargets($newDeviceTargets = null)
    {
        // validation for constraint: boolean
        if (!is_null($newDeviceTargets) && !is_bool($newDeviceTargets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newDeviceTargets, true), gettype($newDeviceTargets)), __LINE__);
        }
        if (is_null($newDeviceTargets) || (is_array($newDeviceTargets) && empty($newDeviceTargets))) {
            unset($this->NewDeviceTargets);
        } else {
            $this->NewDeviceTargets = $newDeviceTargets;
        }
        return $this;
    }
    /**
     * Get NewEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewEntities()
    {
        return isset($this->NewEntities) ? $this->NewEntities : null;
    }
    /**
     * Set NewEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newEntities
     * @return \StructType\GoogleImportOption
     */
    public function setNewEntities($newEntities = null)
    {
        // validation for constraint: boolean
        if (!is_null($newEntities) && !is_bool($newEntities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newEntities, true), gettype($newEntities)), __LINE__);
        }
        if (is_null($newEntities) || (is_array($newEntities) && empty($newEntities))) {
            unset($this->NewEntities);
        } else {
            $this->NewEntities = $newEntities;
        }
        return $this;
    }
    /**
     * Get NewKeywordUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewKeywordUrls()
    {
        return isset($this->NewKeywordUrls) ? $this->NewKeywordUrls : null;
    }
    /**
     * Set NewKeywordUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newKeywordUrls
     * @return \StructType\GoogleImportOption
     */
    public function setNewKeywordUrls($newKeywordUrls = null)
    {
        // validation for constraint: boolean
        if (!is_null($newKeywordUrls) && !is_bool($newKeywordUrls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newKeywordUrls, true), gettype($newKeywordUrls)), __LINE__);
        }
        if (is_null($newKeywordUrls) || (is_array($newKeywordUrls) && empty($newKeywordUrls))) {
            unset($this->NewKeywordUrls);
        } else {
            $this->NewKeywordUrls = $newKeywordUrls;
        }
        return $this;
    }
    /**
     * Get NewKeywordsForExistingAdGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewKeywordsForExistingAdGroups()
    {
        return isset($this->NewKeywordsForExistingAdGroups) ? $this->NewKeywordsForExistingAdGroups : null;
    }
    /**
     * Set NewKeywordsForExistingAdGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newKeywordsForExistingAdGroups
     * @return \StructType\GoogleImportOption
     */
    public function setNewKeywordsForExistingAdGroups($newKeywordsForExistingAdGroups = null)
    {
        // validation for constraint: boolean
        if (!is_null($newKeywordsForExistingAdGroups) && !is_bool($newKeywordsForExistingAdGroups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newKeywordsForExistingAdGroups, true), gettype($newKeywordsForExistingAdGroups)), __LINE__);
        }
        if (is_null($newKeywordsForExistingAdGroups) || (is_array($newKeywordsForExistingAdGroups) && empty($newKeywordsForExistingAdGroups))) {
            unset($this->NewKeywordsForExistingAdGroups);
        } else {
            $this->NewKeywordsForExistingAdGroups = $newKeywordsForExistingAdGroups;
        }
        return $this;
    }
    /**
     * Get NewLabels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewLabels()
    {
        return isset($this->NewLabels) ? $this->NewLabels : null;
    }
    /**
     * Set NewLabels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newLabels
     * @return \StructType\GoogleImportOption
     */
    public function setNewLabels($newLabels = null)
    {
        // validation for constraint: boolean
        if (!is_null($newLabels) && !is_bool($newLabels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newLabels, true), gettype($newLabels)), __LINE__);
        }
        if (is_null($newLabels) || (is_array($newLabels) && empty($newLabels))) {
            unset($this->NewLabels);
        } else {
            $this->NewLabels = $newLabels;
        }
        return $this;
    }
    /**
     * Get NewLocationAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewLocationAdExtensions()
    {
        return isset($this->NewLocationAdExtensions) ? $this->NewLocationAdExtensions : null;
    }
    /**
     * Set NewLocationAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newLocationAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setNewLocationAdExtensions($newLocationAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($newLocationAdExtensions) && !is_bool($newLocationAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newLocationAdExtensions, true), gettype($newLocationAdExtensions)), __LINE__);
        }
        if (is_null($newLocationAdExtensions) || (is_array($newLocationAdExtensions) && empty($newLocationAdExtensions))) {
            unset($this->NewLocationAdExtensions);
        } else {
            $this->NewLocationAdExtensions = $newLocationAdExtensions;
        }
        return $this;
    }
    /**
     * Get NewLocationTargets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewLocationTargets()
    {
        return isset($this->NewLocationTargets) ? $this->NewLocationTargets : null;
    }
    /**
     * Set NewLocationTargets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newLocationTargets
     * @return \StructType\GoogleImportOption
     */
    public function setNewLocationTargets($newLocationTargets = null)
    {
        // validation for constraint: boolean
        if (!is_null($newLocationTargets) && !is_bool($newLocationTargets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newLocationTargets, true), gettype($newLocationTargets)), __LINE__);
        }
        if (is_null($newLocationTargets) || (is_array($newLocationTargets) && empty($newLocationTargets))) {
            unset($this->NewLocationTargets);
        } else {
            $this->NewLocationTargets = $newLocationTargets;
        }
        return $this;
    }
    /**
     * Get NewNegativeKeywordLists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewNegativeKeywordLists()
    {
        return isset($this->NewNegativeKeywordLists) ? $this->NewNegativeKeywordLists : null;
    }
    /**
     * Set NewNegativeKeywordLists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newNegativeKeywordLists
     * @return \StructType\GoogleImportOption
     */
    public function setNewNegativeKeywordLists($newNegativeKeywordLists = null)
    {
        // validation for constraint: boolean
        if (!is_null($newNegativeKeywordLists) && !is_bool($newNegativeKeywordLists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newNegativeKeywordLists, true), gettype($newNegativeKeywordLists)), __LINE__);
        }
        if (is_null($newNegativeKeywordLists) || (is_array($newNegativeKeywordLists) && empty($newNegativeKeywordLists))) {
            unset($this->NewNegativeKeywordLists);
        } else {
            $this->NewNegativeKeywordLists = $newNegativeKeywordLists;
        }
        return $this;
    }
    /**
     * Get NewNegativeKeywordsForExistingParents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewNegativeKeywordsForExistingParents()
    {
        return isset($this->NewNegativeKeywordsForExistingParents) ? $this->NewNegativeKeywordsForExistingParents : null;
    }
    /**
     * Set NewNegativeKeywordsForExistingParents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newNegativeKeywordsForExistingParents
     * @return \StructType\GoogleImportOption
     */
    public function setNewNegativeKeywordsForExistingParents($newNegativeKeywordsForExistingParents = null)
    {
        // validation for constraint: boolean
        if (!is_null($newNegativeKeywordsForExistingParents) && !is_bool($newNegativeKeywordsForExistingParents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newNegativeKeywordsForExistingParents, true), gettype($newNegativeKeywordsForExistingParents)), __LINE__);
        }
        if (is_null($newNegativeKeywordsForExistingParents) || (is_array($newNegativeKeywordsForExistingParents) && empty($newNegativeKeywordsForExistingParents))) {
            unset($this->NewNegativeKeywordsForExistingParents);
        } else {
            $this->NewNegativeKeywordsForExistingParents = $newNegativeKeywordsForExistingParents;
        }
        return $this;
    }
    /**
     * Get NewNegativeSites value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewNegativeSites()
    {
        return isset($this->NewNegativeSites) ? $this->NewNegativeSites : null;
    }
    /**
     * Set NewNegativeSites value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newNegativeSites
     * @return \StructType\GoogleImportOption
     */
    public function setNewNegativeSites($newNegativeSites = null)
    {
        // validation for constraint: boolean
        if (!is_null($newNegativeSites) && !is_bool($newNegativeSites)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newNegativeSites, true), gettype($newNegativeSites)), __LINE__);
        }
        if (is_null($newNegativeSites) || (is_array($newNegativeSites) && empty($newNegativeSites))) {
            unset($this->NewNegativeSites);
        } else {
            $this->NewNegativeSites = $newNegativeSites;
        }
        return $this;
    }
    /**
     * Get NewPageFeeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewPageFeeds()
    {
        return isset($this->NewPageFeeds) ? $this->NewPageFeeds : null;
    }
    /**
     * Set NewPageFeeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newPageFeeds
     * @return \StructType\GoogleImportOption
     */
    public function setNewPageFeeds($newPageFeeds = null)
    {
        // validation for constraint: boolean
        if (!is_null($newPageFeeds) && !is_bool($newPageFeeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newPageFeeds, true), gettype($newPageFeeds)), __LINE__);
        }
        if (is_null($newPageFeeds) || (is_array($newPageFeeds) && empty($newPageFeeds))) {
            unset($this->NewPageFeeds);
        } else {
            $this->NewPageFeeds = $newPageFeeds;
        }
        return $this;
    }
    /**
     * Get NewPausedAdsForExistingAdGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewPausedAdsForExistingAdGroups()
    {
        return isset($this->NewPausedAdsForExistingAdGroups) ? $this->NewPausedAdsForExistingAdGroups : null;
    }
    /**
     * Set NewPausedAdsForExistingAdGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newPausedAdsForExistingAdGroups
     * @return \StructType\GoogleImportOption
     */
    public function setNewPausedAdsForExistingAdGroups($newPausedAdsForExistingAdGroups = null)
    {
        // validation for constraint: boolean
        if (!is_null($newPausedAdsForExistingAdGroups) && !is_bool($newPausedAdsForExistingAdGroups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newPausedAdsForExistingAdGroups, true), gettype($newPausedAdsForExistingAdGroups)), __LINE__);
        }
        if (is_null($newPausedAdsForExistingAdGroups) || (is_array($newPausedAdsForExistingAdGroups) && empty($newPausedAdsForExistingAdGroups))) {
            unset($this->NewPausedAdsForExistingAdGroups);
        } else {
            $this->NewPausedAdsForExistingAdGroups = $newPausedAdsForExistingAdGroups;
        }
        return $this;
    }
    /**
     * Get NewPausedCampaignsAndChildEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewPausedCampaignsAndChildEntities()
    {
        return isset($this->NewPausedCampaignsAndChildEntities) ? $this->NewPausedCampaignsAndChildEntities : null;
    }
    /**
     * Set NewPausedCampaignsAndChildEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newPausedCampaignsAndChildEntities
     * @return \StructType\GoogleImportOption
     */
    public function setNewPausedCampaignsAndChildEntities($newPausedCampaignsAndChildEntities = null)
    {
        // validation for constraint: boolean
        if (!is_null($newPausedCampaignsAndChildEntities) && !is_bool($newPausedCampaignsAndChildEntities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newPausedCampaignsAndChildEntities, true), gettype($newPausedCampaignsAndChildEntities)), __LINE__);
        }
        if (is_null($newPausedCampaignsAndChildEntities) || (is_array($newPausedCampaignsAndChildEntities) && empty($newPausedCampaignsAndChildEntities))) {
            unset($this->NewPausedCampaignsAndChildEntities);
        } else {
            $this->NewPausedCampaignsAndChildEntities = $newPausedCampaignsAndChildEntities;
        }
        return $this;
    }
    /**
     * Get NewPriceAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewPriceAdExtensions()
    {
        return isset($this->NewPriceAdExtensions) ? $this->NewPriceAdExtensions : null;
    }
    /**
     * Set NewPriceAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newPriceAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setNewPriceAdExtensions($newPriceAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($newPriceAdExtensions) && !is_bool($newPriceAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newPriceAdExtensions, true), gettype($newPriceAdExtensions)), __LINE__);
        }
        if (is_null($newPriceAdExtensions) || (is_array($newPriceAdExtensions) && empty($newPriceAdExtensions))) {
            unset($this->NewPriceAdExtensions);
        } else {
            $this->NewPriceAdExtensions = $newPriceAdExtensions;
        }
        return $this;
    }
    /**
     * Get NewProductFilters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewProductFilters()
    {
        return isset($this->NewProductFilters) ? $this->NewProductFilters : null;
    }
    /**
     * Set NewProductFilters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newProductFilters
     * @return \StructType\GoogleImportOption
     */
    public function setNewProductFilters($newProductFilters = null)
    {
        // validation for constraint: boolean
        if (!is_null($newProductFilters) && !is_bool($newProductFilters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newProductFilters, true), gettype($newProductFilters)), __LINE__);
        }
        if (is_null($newProductFilters) || (is_array($newProductFilters) && empty($newProductFilters))) {
            unset($this->NewProductFilters);
        } else {
            $this->NewProductFilters = $newProductFilters;
        }
        return $this;
    }
    /**
     * Get NewPromotionAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewPromotionAdExtensions()
    {
        return isset($this->NewPromotionAdExtensions) ? $this->NewPromotionAdExtensions : null;
    }
    /**
     * Set NewPromotionAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newPromotionAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setNewPromotionAdExtensions($newPromotionAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($newPromotionAdExtensions) && !is_bool($newPromotionAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newPromotionAdExtensions, true), gettype($newPromotionAdExtensions)), __LINE__);
        }
        if (is_null($newPromotionAdExtensions) || (is_array($newPromotionAdExtensions) && empty($newPromotionAdExtensions))) {
            unset($this->NewPromotionAdExtensions);
        } else {
            $this->NewPromotionAdExtensions = $newPromotionAdExtensions;
        }
        return $this;
    }
    /**
     * Get NewReviewAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewReviewAdExtensions()
    {
        return isset($this->NewReviewAdExtensions) ? $this->NewReviewAdExtensions : null;
    }
    /**
     * Set NewReviewAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newReviewAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setNewReviewAdExtensions($newReviewAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($newReviewAdExtensions) && !is_bool($newReviewAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newReviewAdExtensions, true), gettype($newReviewAdExtensions)), __LINE__);
        }
        if (is_null($newReviewAdExtensions) || (is_array($newReviewAdExtensions) && empty($newReviewAdExtensions))) {
            unset($this->NewReviewAdExtensions);
        } else {
            $this->NewReviewAdExtensions = $newReviewAdExtensions;
        }
        return $this;
    }
    /**
     * Get NewSitelinkAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewSitelinkAdExtensions()
    {
        return isset($this->NewSitelinkAdExtensions) ? $this->NewSitelinkAdExtensions : null;
    }
    /**
     * Set NewSitelinkAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newSitelinkAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setNewSitelinkAdExtensions($newSitelinkAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($newSitelinkAdExtensions) && !is_bool($newSitelinkAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newSitelinkAdExtensions, true), gettype($newSitelinkAdExtensions)), __LINE__);
        }
        if (is_null($newSitelinkAdExtensions) || (is_array($newSitelinkAdExtensions) && empty($newSitelinkAdExtensions))) {
            unset($this->NewSitelinkAdExtensions);
        } else {
            $this->NewSitelinkAdExtensions = $newSitelinkAdExtensions;
        }
        return $this;
    }
    /**
     * Get NewStructuredSnippetAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewStructuredSnippetAdExtensions()
    {
        return isset($this->NewStructuredSnippetAdExtensions) ? $this->NewStructuredSnippetAdExtensions : null;
    }
    /**
     * Set NewStructuredSnippetAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newStructuredSnippetAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setNewStructuredSnippetAdExtensions($newStructuredSnippetAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($newStructuredSnippetAdExtensions) && !is_bool($newStructuredSnippetAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newStructuredSnippetAdExtensions, true), gettype($newStructuredSnippetAdExtensions)), __LINE__);
        }
        if (is_null($newStructuredSnippetAdExtensions) || (is_array($newStructuredSnippetAdExtensions) && empty($newStructuredSnippetAdExtensions))) {
            unset($this->NewStructuredSnippetAdExtensions);
        } else {
            $this->NewStructuredSnippetAdExtensions = $newStructuredSnippetAdExtensions;
        }
        return $this;
    }
    /**
     * Get NewUrlOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewUrlOptions()
    {
        return isset($this->NewUrlOptions) ? $this->NewUrlOptions : null;
    }
    /**
     * Set NewUrlOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newUrlOptions
     * @return \StructType\GoogleImportOption
     */
    public function setNewUrlOptions($newUrlOptions = null)
    {
        // validation for constraint: boolean
        if (!is_null($newUrlOptions) && !is_bool($newUrlOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newUrlOptions, true), gettype($newUrlOptions)), __LINE__);
        }
        if (is_null($newUrlOptions) || (is_array($newUrlOptions) && empty($newUrlOptions))) {
            unset($this->NewUrlOptions);
        } else {
            $this->NewUrlOptions = $newUrlOptions;
        }
        return $this;
    }
    /**
     * Get PauseAIMAdGroupIfAllAudienceCriterionNotImported value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPauseAIMAdGroupIfAllAudienceCriterionNotImported()
    {
        return isset($this->PauseAIMAdGroupIfAllAudienceCriterionNotImported) ? $this->PauseAIMAdGroupIfAllAudienceCriterionNotImported : null;
    }
    /**
     * Set PauseAIMAdGroupIfAllAudienceCriterionNotImported value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $pauseAIMAdGroupIfAllAudienceCriterionNotImported
     * @return \StructType\GoogleImportOption
     */
    public function setPauseAIMAdGroupIfAllAudienceCriterionNotImported($pauseAIMAdGroupIfAllAudienceCriterionNotImported = null)
    {
        // validation for constraint: boolean
        if (!is_null($pauseAIMAdGroupIfAllAudienceCriterionNotImported) && !is_bool($pauseAIMAdGroupIfAllAudienceCriterionNotImported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pauseAIMAdGroupIfAllAudienceCriterionNotImported, true), gettype($pauseAIMAdGroupIfAllAudienceCriterionNotImported)), __LINE__);
        }
        if (is_null($pauseAIMAdGroupIfAllAudienceCriterionNotImported) || (is_array($pauseAIMAdGroupIfAllAudienceCriterionNotImported) && empty($pauseAIMAdGroupIfAllAudienceCriterionNotImported))) {
            unset($this->PauseAIMAdGroupIfAllAudienceCriterionNotImported);
        } else {
            $this->PauseAIMAdGroupIfAllAudienceCriterionNotImported = $pauseAIMAdGroupIfAllAudienceCriterionNotImported;
        }
        return $this;
    }
    /**
     * Get PauseCampaignsWithoutSupportedLocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPauseCampaignsWithoutSupportedLocations()
    {
        return isset($this->PauseCampaignsWithoutSupportedLocations) ? $this->PauseCampaignsWithoutSupportedLocations : null;
    }
    /**
     * Set PauseCampaignsWithoutSupportedLocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $pauseCampaignsWithoutSupportedLocations
     * @return \StructType\GoogleImportOption
     */
    public function setPauseCampaignsWithoutSupportedLocations($pauseCampaignsWithoutSupportedLocations = null)
    {
        // validation for constraint: boolean
        if (!is_null($pauseCampaignsWithoutSupportedLocations) && !is_bool($pauseCampaignsWithoutSupportedLocations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pauseCampaignsWithoutSupportedLocations, true), gettype($pauseCampaignsWithoutSupportedLocations)), __LINE__);
        }
        if (is_null($pauseCampaignsWithoutSupportedLocations) || (is_array($pauseCampaignsWithoutSupportedLocations) && empty($pauseCampaignsWithoutSupportedLocations))) {
            unset($this->PauseCampaignsWithoutSupportedLocations);
        } else {
            $this->PauseCampaignsWithoutSupportedLocations = $pauseCampaignsWithoutSupportedLocations;
        }
        return $this;
    }
    /**
     * Get PauseNewCampaigns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPauseNewCampaigns()
    {
        return isset($this->PauseNewCampaigns) ? $this->PauseNewCampaigns : null;
    }
    /**
     * Set PauseNewCampaigns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $pauseNewCampaigns
     * @return \StructType\GoogleImportOption
     */
    public function setPauseNewCampaigns($pauseNewCampaigns = null)
    {
        // validation for constraint: boolean
        if (!is_null($pauseNewCampaigns) && !is_bool($pauseNewCampaigns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pauseNewCampaigns, true), gettype($pauseNewCampaigns)), __LINE__);
        }
        if (is_null($pauseNewCampaigns) || (is_array($pauseNewCampaigns) && empty($pauseNewCampaigns))) {
            unset($this->PauseNewCampaigns);
        } else {
            $this->PauseNewCampaigns = $pauseNewCampaigns;
        }
        return $this;
    }
    /**
     * Get RaiseBidsToMinimum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRaiseBidsToMinimum()
    {
        return isset($this->RaiseBidsToMinimum) ? $this->RaiseBidsToMinimum : null;
    }
    /**
     * Set RaiseBidsToMinimum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $raiseBidsToMinimum
     * @return \StructType\GoogleImportOption
     */
    public function setRaiseBidsToMinimum($raiseBidsToMinimum = null)
    {
        // validation for constraint: boolean
        if (!is_null($raiseBidsToMinimum) && !is_bool($raiseBidsToMinimum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($raiseBidsToMinimum, true), gettype($raiseBidsToMinimum)), __LINE__);
        }
        if (is_null($raiseBidsToMinimum) || (is_array($raiseBidsToMinimum) && empty($raiseBidsToMinimum))) {
            unset($this->RaiseBidsToMinimum);
        } else {
            $this->RaiseBidsToMinimum = $raiseBidsToMinimum;
        }
        return $this;
    }
    /**
     * Get RaiseCampaignBudgetsToMinimum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRaiseCampaignBudgetsToMinimum()
    {
        return isset($this->RaiseCampaignBudgetsToMinimum) ? $this->RaiseCampaignBudgetsToMinimum : null;
    }
    /**
     * Set RaiseCampaignBudgetsToMinimum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $raiseCampaignBudgetsToMinimum
     * @return \StructType\GoogleImportOption
     */
    public function setRaiseCampaignBudgetsToMinimum($raiseCampaignBudgetsToMinimum = null)
    {
        // validation for constraint: boolean
        if (!is_null($raiseCampaignBudgetsToMinimum) && !is_bool($raiseCampaignBudgetsToMinimum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($raiseCampaignBudgetsToMinimum, true), gettype($raiseCampaignBudgetsToMinimum)), __LINE__);
        }
        if (is_null($raiseCampaignBudgetsToMinimum) || (is_array($raiseCampaignBudgetsToMinimum) && empty($raiseCampaignBudgetsToMinimum))) {
            unset($this->RaiseCampaignBudgetsToMinimum);
        } else {
            $this->RaiseCampaignBudgetsToMinimum = $raiseCampaignBudgetsToMinimum;
        }
        return $this;
    }
    /**
     * Get RaiseProductGroupBidsToMinimum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRaiseProductGroupBidsToMinimum()
    {
        return isset($this->RaiseProductGroupBidsToMinimum) ? $this->RaiseProductGroupBidsToMinimum : null;
    }
    /**
     * Set RaiseProductGroupBidsToMinimum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $raiseProductGroupBidsToMinimum
     * @return \StructType\GoogleImportOption
     */
    public function setRaiseProductGroupBidsToMinimum($raiseProductGroupBidsToMinimum = null)
    {
        // validation for constraint: boolean
        if (!is_null($raiseProductGroupBidsToMinimum) && !is_bool($raiseProductGroupBidsToMinimum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($raiseProductGroupBidsToMinimum, true), gettype($raiseProductGroupBidsToMinimum)), __LINE__);
        }
        if (is_null($raiseProductGroupBidsToMinimum) || (is_array($raiseProductGroupBidsToMinimum) && empty($raiseProductGroupBidsToMinimum))) {
            unset($this->RaiseProductGroupBidsToMinimum);
        } else {
            $this->RaiseProductGroupBidsToMinimum = $raiseProductGroupBidsToMinimum;
        }
        return $this;
    }
    /**
     * Get SearchAndDsaMixedCampaignAsSearchCampaign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSearchAndDsaMixedCampaignAsSearchCampaign()
    {
        return isset($this->SearchAndDsaMixedCampaignAsSearchCampaign) ? $this->SearchAndDsaMixedCampaignAsSearchCampaign : null;
    }
    /**
     * Set SearchAndDsaMixedCampaignAsSearchCampaign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $searchAndDsaMixedCampaignAsSearchCampaign
     * @return \StructType\GoogleImportOption
     */
    public function setSearchAndDsaMixedCampaignAsSearchCampaign($searchAndDsaMixedCampaignAsSearchCampaign = null)
    {
        // validation for constraint: boolean
        if (!is_null($searchAndDsaMixedCampaignAsSearchCampaign) && !is_bool($searchAndDsaMixedCampaignAsSearchCampaign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($searchAndDsaMixedCampaignAsSearchCampaign, true), gettype($searchAndDsaMixedCampaignAsSearchCampaign)), __LINE__);
        }
        if (is_null($searchAndDsaMixedCampaignAsSearchCampaign) || (is_array($searchAndDsaMixedCampaignAsSearchCampaign) && empty($searchAndDsaMixedCampaignAsSearchCampaign))) {
            unset($this->SearchAndDsaMixedCampaignAsSearchCampaign);
        } else {
            $this->SearchAndDsaMixedCampaignAsSearchCampaign = $searchAndDsaMixedCampaignAsSearchCampaign;
        }
        return $this;
    }
    /**
     * Get SearchAndReplaceForCampaignNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ImportSearchAndReplaceForStringProperty|null
     */
    public function getSearchAndReplaceForCampaignNames()
    {
        return isset($this->SearchAndReplaceForCampaignNames) ? $this->SearchAndReplaceForCampaignNames : null;
    }
    /**
     * Set SearchAndReplaceForCampaignNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForCampaignNames
     * @return \StructType\GoogleImportOption
     */
    public function setSearchAndReplaceForCampaignNames(\StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForCampaignNames = null)
    {
        if (is_null($searchAndReplaceForCampaignNames) || (is_array($searchAndReplaceForCampaignNames) && empty($searchAndReplaceForCampaignNames))) {
            unset($this->SearchAndReplaceForCampaignNames);
        } else {
            $this->SearchAndReplaceForCampaignNames = $searchAndReplaceForCampaignNames;
        }
        return $this;
    }
    /**
     * Get SearchAndReplaceForCustomParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ImportSearchAndReplaceForStringProperty|null
     */
    public function getSearchAndReplaceForCustomParameters()
    {
        return isset($this->SearchAndReplaceForCustomParameters) ? $this->SearchAndReplaceForCustomParameters : null;
    }
    /**
     * Set SearchAndReplaceForCustomParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForCustomParameters
     * @return \StructType\GoogleImportOption
     */
    public function setSearchAndReplaceForCustomParameters(\StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForCustomParameters = null)
    {
        if (is_null($searchAndReplaceForCustomParameters) || (is_array($searchAndReplaceForCustomParameters) && empty($searchAndReplaceForCustomParameters))) {
            unset($this->SearchAndReplaceForCustomParameters);
        } else {
            $this->SearchAndReplaceForCustomParameters = $searchAndReplaceForCustomParameters;
        }
        return $this;
    }
    /**
     * Get SearchAndReplaceForTrackingTemplates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ImportSearchAndReplaceForStringProperty|null
     */
    public function getSearchAndReplaceForTrackingTemplates()
    {
        return isset($this->SearchAndReplaceForTrackingTemplates) ? $this->SearchAndReplaceForTrackingTemplates : null;
    }
    /**
     * Set SearchAndReplaceForTrackingTemplates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForTrackingTemplates
     * @return \StructType\GoogleImportOption
     */
    public function setSearchAndReplaceForTrackingTemplates(\StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForTrackingTemplates = null)
    {
        if (is_null($searchAndReplaceForTrackingTemplates) || (is_array($searchAndReplaceForTrackingTemplates) && empty($searchAndReplaceForTrackingTemplates))) {
            unset($this->SearchAndReplaceForTrackingTemplates);
        } else {
            $this->SearchAndReplaceForTrackingTemplates = $searchAndReplaceForTrackingTemplates;
        }
        return $this;
    }
    /**
     * Get SearchAndReplaceForUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ImportSearchAndReplaceForStringProperty|null
     */
    public function getSearchAndReplaceForUrls()
    {
        return isset($this->SearchAndReplaceForUrls) ? $this->SearchAndReplaceForUrls : null;
    }
    /**
     * Set SearchAndReplaceForUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForUrls
     * @return \StructType\GoogleImportOption
     */
    public function setSearchAndReplaceForUrls(\StructType\ImportSearchAndReplaceForStringProperty $searchAndReplaceForUrls = null)
    {
        if (is_null($searchAndReplaceForUrls) || (is_array($searchAndReplaceForUrls) && empty($searchAndReplaceForUrls))) {
            unset($this->SearchAndReplaceForUrls);
        } else {
            $this->SearchAndReplaceForUrls = $searchAndReplaceForUrls;
        }
        return $this;
    }
    /**
     * Get SuffixForCampaignNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffixForCampaignNames()
    {
        return isset($this->SuffixForCampaignNames) ? $this->SuffixForCampaignNames : null;
    }
    /**
     * Set SuffixForCampaignNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffixForCampaignNames
     * @return \StructType\GoogleImportOption
     */
    public function setSuffixForCampaignNames($suffixForCampaignNames = null)
    {
        // validation for constraint: string
        if (!is_null($suffixForCampaignNames) && !is_string($suffixForCampaignNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffixForCampaignNames, true), gettype($suffixForCampaignNames)), __LINE__);
        }
        if (is_null($suffixForCampaignNames) || (is_array($suffixForCampaignNames) && empty($suffixForCampaignNames))) {
            unset($this->SuffixForCampaignNames);
        } else {
            $this->SuffixForCampaignNames = $suffixForCampaignNames;
        }
        return $this;
    }
    /**
     * Get SuffixForTrackingTemplates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffixForTrackingTemplates()
    {
        return isset($this->SuffixForTrackingTemplates) ? $this->SuffixForTrackingTemplates : null;
    }
    /**
     * Set SuffixForTrackingTemplates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffixForTrackingTemplates
     * @return \StructType\GoogleImportOption
     */
    public function setSuffixForTrackingTemplates($suffixForTrackingTemplates = null)
    {
        // validation for constraint: string
        if (!is_null($suffixForTrackingTemplates) && !is_string($suffixForTrackingTemplates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffixForTrackingTemplates, true), gettype($suffixForTrackingTemplates)), __LINE__);
        }
        if (is_null($suffixForTrackingTemplates) || (is_array($suffixForTrackingTemplates) && empty($suffixForTrackingTemplates))) {
            unset($this->SuffixForTrackingTemplates);
        } else {
            $this->SuffixForTrackingTemplates = $suffixForTrackingTemplates;
        }
        return $this;
    }
    /**
     * Get SuffixForUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffixForUrls()
    {
        return isset($this->SuffixForUrls) ? $this->SuffixForUrls : null;
    }
    /**
     * Set SuffixForUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffixForUrls
     * @return \StructType\GoogleImportOption
     */
    public function setSuffixForUrls($suffixForUrls = null)
    {
        // validation for constraint: string
        if (!is_null($suffixForUrls) && !is_string($suffixForUrls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffixForUrls, true), gettype($suffixForUrls)), __LINE__);
        }
        if (is_null($suffixForUrls) || (is_array($suffixForUrls) && empty($suffixForUrls))) {
            unset($this->SuffixForUrls);
        } else {
            $this->SuffixForUrls = $suffixForUrls;
        }
        return $this;
    }
    /**
     * Get UpdateAdCustomizerFeeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateAdCustomizerFeeds()
    {
        return isset($this->UpdateAdCustomizerFeeds) ? $this->UpdateAdCustomizerFeeds : null;
    }
    /**
     * Set UpdateAdCustomizerFeeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateAdCustomizerFeeds
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateAdCustomizerFeeds($updateAdCustomizerFeeds = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateAdCustomizerFeeds) && !is_bool($updateAdCustomizerFeeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateAdCustomizerFeeds, true), gettype($updateAdCustomizerFeeds)), __LINE__);
        }
        if (is_null($updateAdCustomizerFeeds) || (is_array($updateAdCustomizerFeeds) && empty($updateAdCustomizerFeeds))) {
            unset($this->UpdateAdCustomizerFeeds);
        } else {
            $this->UpdateAdCustomizerFeeds = $updateAdCustomizerFeeds;
        }
        return $this;
    }
    /**
     * Get UpdateAdGroupNetwork value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateAdGroupNetwork()
    {
        return isset($this->UpdateAdGroupNetwork) ? $this->UpdateAdGroupNetwork : null;
    }
    /**
     * Set UpdateAdGroupNetwork value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateAdGroupNetwork
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateAdGroupNetwork($updateAdGroupNetwork = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateAdGroupNetwork) && !is_bool($updateAdGroupNetwork)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateAdGroupNetwork, true), gettype($updateAdGroupNetwork)), __LINE__);
        }
        if (is_null($updateAdGroupNetwork) || (is_array($updateAdGroupNetwork) && empty($updateAdGroupNetwork))) {
            unset($this->UpdateAdGroupNetwork);
        } else {
            $this->UpdateAdGroupNetwork = $updateAdGroupNetwork;
        }
        return $this;
    }
    /**
     * Get UpdateAdSchedules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateAdSchedules()
    {
        return isset($this->UpdateAdSchedules) ? $this->UpdateAdSchedules : null;
    }
    /**
     * Set UpdateAdSchedules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateAdSchedules
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateAdSchedules($updateAdSchedules = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateAdSchedules) && !is_bool($updateAdSchedules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateAdSchedules, true), gettype($updateAdSchedules)), __LINE__);
        }
        if (is_null($updateAdSchedules) || (is_array($updateAdSchedules) && empty($updateAdSchedules))) {
            unset($this->UpdateAdSchedules);
        } else {
            $this->UpdateAdSchedules = $updateAdSchedules;
        }
        return $this;
    }
    /**
     * Get UpdateAppAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateAppAdExtensions()
    {
        return isset($this->UpdateAppAdExtensions) ? $this->UpdateAppAdExtensions : null;
    }
    /**
     * Set UpdateAppAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateAppAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateAppAdExtensions($updateAppAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateAppAdExtensions) && !is_bool($updateAppAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateAppAdExtensions, true), gettype($updateAppAdExtensions)), __LINE__);
        }
        if (is_null($updateAppAdExtensions) || (is_array($updateAppAdExtensions) && empty($updateAppAdExtensions))) {
            unset($this->UpdateAppAdExtensions);
        } else {
            $this->UpdateAppAdExtensions = $updateAppAdExtensions;
        }
        return $this;
    }
    /**
     * Get UpdateAudienceTargets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateAudienceTargets()
    {
        return isset($this->UpdateAudienceTargets) ? $this->UpdateAudienceTargets : null;
    }
    /**
     * Set UpdateAudienceTargets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateAudienceTargets
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateAudienceTargets($updateAudienceTargets = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateAudienceTargets) && !is_bool($updateAudienceTargets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateAudienceTargets, true), gettype($updateAudienceTargets)), __LINE__);
        }
        if (is_null($updateAudienceTargets) || (is_array($updateAudienceTargets) && empty($updateAudienceTargets))) {
            unset($this->UpdateAudienceTargets);
        } else {
            $this->UpdateAudienceTargets = $updateAudienceTargets;
        }
        return $this;
    }
    /**
     * Get UpdateBiddingStrategies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateBiddingStrategies()
    {
        return isset($this->UpdateBiddingStrategies) ? $this->UpdateBiddingStrategies : null;
    }
    /**
     * Set UpdateBiddingStrategies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateBiddingStrategies
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateBiddingStrategies($updateBiddingStrategies = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateBiddingStrategies) && !is_bool($updateBiddingStrategies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateBiddingStrategies, true), gettype($updateBiddingStrategies)), __LINE__);
        }
        if (is_null($updateBiddingStrategies) || (is_array($updateBiddingStrategies) && empty($updateBiddingStrategies))) {
            unset($this->UpdateBiddingStrategies);
        } else {
            $this->UpdateBiddingStrategies = $updateBiddingStrategies;
        }
        return $this;
    }
    /**
     * Get UpdateBids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateBids()
    {
        return isset($this->UpdateBids) ? $this->UpdateBids : null;
    }
    /**
     * Set UpdateBids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateBids
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateBids($updateBids = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateBids) && !is_bool($updateBids)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateBids, true), gettype($updateBids)), __LINE__);
        }
        if (is_null($updateBids) || (is_array($updateBids) && empty($updateBids))) {
            unset($this->UpdateBids);
        } else {
            $this->UpdateBids = $updateBids;
        }
        return $this;
    }
    /**
     * Get UpdateCallAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateCallAdExtensions()
    {
        return isset($this->UpdateCallAdExtensions) ? $this->UpdateCallAdExtensions : null;
    }
    /**
     * Set UpdateCallAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateCallAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateCallAdExtensions($updateCallAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateCallAdExtensions) && !is_bool($updateCallAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateCallAdExtensions, true), gettype($updateCallAdExtensions)), __LINE__);
        }
        if (is_null($updateCallAdExtensions) || (is_array($updateCallAdExtensions) && empty($updateCallAdExtensions))) {
            unset($this->UpdateCallAdExtensions);
        } else {
            $this->UpdateCallAdExtensions = $updateCallAdExtensions;
        }
        return $this;
    }
    /**
     * Get UpdateCalloutAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateCalloutAdExtensions()
    {
        return isset($this->UpdateCalloutAdExtensions) ? $this->UpdateCalloutAdExtensions : null;
    }
    /**
     * Set UpdateCalloutAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateCalloutAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateCalloutAdExtensions($updateCalloutAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateCalloutAdExtensions) && !is_bool($updateCalloutAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateCalloutAdExtensions, true), gettype($updateCalloutAdExtensions)), __LINE__);
        }
        if (is_null($updateCalloutAdExtensions) || (is_array($updateCalloutAdExtensions) && empty($updateCalloutAdExtensions))) {
            unset($this->UpdateCalloutAdExtensions);
        } else {
            $this->UpdateCalloutAdExtensions = $updateCalloutAdExtensions;
        }
        return $this;
    }
    /**
     * Get UpdateCampaignAdGroupLanguages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateCampaignAdGroupLanguages()
    {
        return isset($this->UpdateCampaignAdGroupLanguages) ? $this->UpdateCampaignAdGroupLanguages : null;
    }
    /**
     * Set UpdateCampaignAdGroupLanguages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateCampaignAdGroupLanguages
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateCampaignAdGroupLanguages($updateCampaignAdGroupLanguages = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateCampaignAdGroupLanguages) && !is_bool($updateCampaignAdGroupLanguages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateCampaignAdGroupLanguages, true), gettype($updateCampaignAdGroupLanguages)), __LINE__);
        }
        if (is_null($updateCampaignAdGroupLanguages) || (is_array($updateCampaignAdGroupLanguages) && empty($updateCampaignAdGroupLanguages))) {
            unset($this->UpdateCampaignAdGroupLanguages);
        } else {
            $this->UpdateCampaignAdGroupLanguages = $updateCampaignAdGroupLanguages;
        }
        return $this;
    }
    /**
     * Get UpdateCampaignBudgets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateCampaignBudgets()
    {
        return isset($this->UpdateCampaignBudgets) ? $this->UpdateCampaignBudgets : null;
    }
    /**
     * Set UpdateCampaignBudgets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateCampaignBudgets
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateCampaignBudgets($updateCampaignBudgets = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateCampaignBudgets) && !is_bool($updateCampaignBudgets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateCampaignBudgets, true), gettype($updateCampaignBudgets)), __LINE__);
        }
        if (is_null($updateCampaignBudgets) || (is_array($updateCampaignBudgets) && empty($updateCampaignBudgets))) {
            unset($this->UpdateCampaignBudgets);
        } else {
            $this->UpdateCampaignBudgets = $updateCampaignBudgets;
        }
        return $this;
    }
    /**
     * Get UpdateCampaignNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateCampaignNames()
    {
        return isset($this->UpdateCampaignNames) ? $this->UpdateCampaignNames : null;
    }
    /**
     * Set UpdateCampaignNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateCampaignNames
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateCampaignNames($updateCampaignNames = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateCampaignNames) && !is_bool($updateCampaignNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateCampaignNames, true), gettype($updateCampaignNames)), __LINE__);
        }
        if (is_null($updateCampaignNames) || (is_array($updateCampaignNames) && empty($updateCampaignNames))) {
            unset($this->UpdateCampaignNames);
        } else {
            $this->UpdateCampaignNames = $updateCampaignNames;
        }
        return $this;
    }
    /**
     * Get UpdateDemographicTargets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateDemographicTargets()
    {
        return isset($this->UpdateDemographicTargets) ? $this->UpdateDemographicTargets : null;
    }
    /**
     * Set UpdateDemographicTargets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateDemographicTargets
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateDemographicTargets($updateDemographicTargets = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateDemographicTargets) && !is_bool($updateDemographicTargets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateDemographicTargets, true), gettype($updateDemographicTargets)), __LINE__);
        }
        if (is_null($updateDemographicTargets) || (is_array($updateDemographicTargets) && empty($updateDemographicTargets))) {
            unset($this->UpdateDemographicTargets);
        } else {
            $this->UpdateDemographicTargets = $updateDemographicTargets;
        }
        return $this;
    }
    /**
     * Get UpdateDeviceTargets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateDeviceTargets()
    {
        return isset($this->UpdateDeviceTargets) ? $this->UpdateDeviceTargets : null;
    }
    /**
     * Set UpdateDeviceTargets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateDeviceTargets
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateDeviceTargets($updateDeviceTargets = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateDeviceTargets) && !is_bool($updateDeviceTargets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateDeviceTargets, true), gettype($updateDeviceTargets)), __LINE__);
        }
        if (is_null($updateDeviceTargets) || (is_array($updateDeviceTargets) && empty($updateDeviceTargets))) {
            unset($this->UpdateDeviceTargets);
        } else {
            $this->UpdateDeviceTargets = $updateDeviceTargets;
        }
        return $this;
    }
    /**
     * Get UpdateEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateEntities()
    {
        return isset($this->UpdateEntities) ? $this->UpdateEntities : null;
    }
    /**
     * Set UpdateEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateEntities
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateEntities($updateEntities = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateEntities) && !is_bool($updateEntities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateEntities, true), gettype($updateEntities)), __LINE__);
        }
        if (is_null($updateEntities) || (is_array($updateEntities) && empty($updateEntities))) {
            unset($this->UpdateEntities);
        } else {
            $this->UpdateEntities = $updateEntities;
        }
        return $this;
    }
    /**
     * Get UpdateKeywordUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateKeywordUrls()
    {
        return isset($this->UpdateKeywordUrls) ? $this->UpdateKeywordUrls : null;
    }
    /**
     * Set UpdateKeywordUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateKeywordUrls
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateKeywordUrls($updateKeywordUrls = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateKeywordUrls) && !is_bool($updateKeywordUrls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateKeywordUrls, true), gettype($updateKeywordUrls)), __LINE__);
        }
        if (is_null($updateKeywordUrls) || (is_array($updateKeywordUrls) && empty($updateKeywordUrls))) {
            unset($this->UpdateKeywordUrls);
        } else {
            $this->UpdateKeywordUrls = $updateKeywordUrls;
        }
        return $this;
    }
    /**
     * Get UpdateLabels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateLabels()
    {
        return isset($this->UpdateLabels) ? $this->UpdateLabels : null;
    }
    /**
     * Set UpdateLabels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateLabels
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateLabels($updateLabels = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateLabels) && !is_bool($updateLabels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateLabels, true), gettype($updateLabels)), __LINE__);
        }
        if (is_null($updateLabels) || (is_array($updateLabels) && empty($updateLabels))) {
            unset($this->UpdateLabels);
        } else {
            $this->UpdateLabels = $updateLabels;
        }
        return $this;
    }
    /**
     * Get UpdateLocationAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateLocationAdExtensions()
    {
        return isset($this->UpdateLocationAdExtensions) ? $this->UpdateLocationAdExtensions : null;
    }
    /**
     * Set UpdateLocationAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateLocationAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateLocationAdExtensions($updateLocationAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateLocationAdExtensions) && !is_bool($updateLocationAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateLocationAdExtensions, true), gettype($updateLocationAdExtensions)), __LINE__);
        }
        if (is_null($updateLocationAdExtensions) || (is_array($updateLocationAdExtensions) && empty($updateLocationAdExtensions))) {
            unset($this->UpdateLocationAdExtensions);
        } else {
            $this->UpdateLocationAdExtensions = $updateLocationAdExtensions;
        }
        return $this;
    }
    /**
     * Get UpdateLocationTargets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateLocationTargets()
    {
        return isset($this->UpdateLocationTargets) ? $this->UpdateLocationTargets : null;
    }
    /**
     * Set UpdateLocationTargets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateLocationTargets
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateLocationTargets($updateLocationTargets = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateLocationTargets) && !is_bool($updateLocationTargets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateLocationTargets, true), gettype($updateLocationTargets)), __LINE__);
        }
        if (is_null($updateLocationTargets) || (is_array($updateLocationTargets) && empty($updateLocationTargets))) {
            unset($this->UpdateLocationTargets);
        } else {
            $this->UpdateLocationTargets = $updateLocationTargets;
        }
        return $this;
    }
    /**
     * Get UpdateNegativeKeywordLists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateNegativeKeywordLists()
    {
        return isset($this->UpdateNegativeKeywordLists) ? $this->UpdateNegativeKeywordLists : null;
    }
    /**
     * Set UpdateNegativeKeywordLists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateNegativeKeywordLists
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateNegativeKeywordLists($updateNegativeKeywordLists = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateNegativeKeywordLists) && !is_bool($updateNegativeKeywordLists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateNegativeKeywordLists, true), gettype($updateNegativeKeywordLists)), __LINE__);
        }
        if (is_null($updateNegativeKeywordLists) || (is_array($updateNegativeKeywordLists) && empty($updateNegativeKeywordLists))) {
            unset($this->UpdateNegativeKeywordLists);
        } else {
            $this->UpdateNegativeKeywordLists = $updateNegativeKeywordLists;
        }
        return $this;
    }
    /**
     * Get UpdateNegativeSites value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateNegativeSites()
    {
        return isset($this->UpdateNegativeSites) ? $this->UpdateNegativeSites : null;
    }
    /**
     * Set UpdateNegativeSites value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateNegativeSites
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateNegativeSites($updateNegativeSites = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateNegativeSites) && !is_bool($updateNegativeSites)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateNegativeSites, true), gettype($updateNegativeSites)), __LINE__);
        }
        if (is_null($updateNegativeSites) || (is_array($updateNegativeSites) && empty($updateNegativeSites))) {
            unset($this->UpdateNegativeSites);
        } else {
            $this->UpdateNegativeSites = $updateNegativeSites;
        }
        return $this;
    }
    /**
     * Get UpdatePageFeeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdatePageFeeds()
    {
        return isset($this->UpdatePageFeeds) ? $this->UpdatePageFeeds : null;
    }
    /**
     * Set UpdatePageFeeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updatePageFeeds
     * @return \StructType\GoogleImportOption
     */
    public function setUpdatePageFeeds($updatePageFeeds = null)
    {
        // validation for constraint: boolean
        if (!is_null($updatePageFeeds) && !is_bool($updatePageFeeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updatePageFeeds, true), gettype($updatePageFeeds)), __LINE__);
        }
        if (is_null($updatePageFeeds) || (is_array($updatePageFeeds) && empty($updatePageFeeds))) {
            unset($this->UpdatePageFeeds);
        } else {
            $this->UpdatePageFeeds = $updatePageFeeds;
        }
        return $this;
    }
    /**
     * Get UpdatePriceAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdatePriceAdExtensions()
    {
        return isset($this->UpdatePriceAdExtensions) ? $this->UpdatePriceAdExtensions : null;
    }
    /**
     * Set UpdatePriceAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updatePriceAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setUpdatePriceAdExtensions($updatePriceAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($updatePriceAdExtensions) && !is_bool($updatePriceAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updatePriceAdExtensions, true), gettype($updatePriceAdExtensions)), __LINE__);
        }
        if (is_null($updatePriceAdExtensions) || (is_array($updatePriceAdExtensions) && empty($updatePriceAdExtensions))) {
            unset($this->UpdatePriceAdExtensions);
        } else {
            $this->UpdatePriceAdExtensions = $updatePriceAdExtensions;
        }
        return $this;
    }
    /**
     * Get UpdateProductFilters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateProductFilters()
    {
        return isset($this->UpdateProductFilters) ? $this->UpdateProductFilters : null;
    }
    /**
     * Set UpdateProductFilters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateProductFilters
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateProductFilters($updateProductFilters = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateProductFilters) && !is_bool($updateProductFilters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateProductFilters, true), gettype($updateProductFilters)), __LINE__);
        }
        if (is_null($updateProductFilters) || (is_array($updateProductFilters) && empty($updateProductFilters))) {
            unset($this->UpdateProductFilters);
        } else {
            $this->UpdateProductFilters = $updateProductFilters;
        }
        return $this;
    }
    /**
     * Get UpdatePromotionAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdatePromotionAdExtensions()
    {
        return isset($this->UpdatePromotionAdExtensions) ? $this->UpdatePromotionAdExtensions : null;
    }
    /**
     * Set UpdatePromotionAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updatePromotionAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setUpdatePromotionAdExtensions($updatePromotionAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($updatePromotionAdExtensions) && !is_bool($updatePromotionAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updatePromotionAdExtensions, true), gettype($updatePromotionAdExtensions)), __LINE__);
        }
        if (is_null($updatePromotionAdExtensions) || (is_array($updatePromotionAdExtensions) && empty($updatePromotionAdExtensions))) {
            unset($this->UpdatePromotionAdExtensions);
        } else {
            $this->UpdatePromotionAdExtensions = $updatePromotionAdExtensions;
        }
        return $this;
    }
    /**
     * Get UpdateReviewAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateReviewAdExtensions()
    {
        return isset($this->UpdateReviewAdExtensions) ? $this->UpdateReviewAdExtensions : null;
    }
    /**
     * Set UpdateReviewAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateReviewAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateReviewAdExtensions($updateReviewAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateReviewAdExtensions) && !is_bool($updateReviewAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateReviewAdExtensions, true), gettype($updateReviewAdExtensions)), __LINE__);
        }
        if (is_null($updateReviewAdExtensions) || (is_array($updateReviewAdExtensions) && empty($updateReviewAdExtensions))) {
            unset($this->UpdateReviewAdExtensions);
        } else {
            $this->UpdateReviewAdExtensions = $updateReviewAdExtensions;
        }
        return $this;
    }
    /**
     * Get UpdateSitelinkAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateSitelinkAdExtensions()
    {
        return isset($this->UpdateSitelinkAdExtensions) ? $this->UpdateSitelinkAdExtensions : null;
    }
    /**
     * Set UpdateSitelinkAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateSitelinkAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateSitelinkAdExtensions($updateSitelinkAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateSitelinkAdExtensions) && !is_bool($updateSitelinkAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateSitelinkAdExtensions, true), gettype($updateSitelinkAdExtensions)), __LINE__);
        }
        if (is_null($updateSitelinkAdExtensions) || (is_array($updateSitelinkAdExtensions) && empty($updateSitelinkAdExtensions))) {
            unset($this->UpdateSitelinkAdExtensions);
        } else {
            $this->UpdateSitelinkAdExtensions = $updateSitelinkAdExtensions;
        }
        return $this;
    }
    /**
     * Get UpdateStatusForAdGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateStatusForAdGroups()
    {
        return isset($this->UpdateStatusForAdGroups) ? $this->UpdateStatusForAdGroups : null;
    }
    /**
     * Set UpdateStatusForAdGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateStatusForAdGroups
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateStatusForAdGroups($updateStatusForAdGroups = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateStatusForAdGroups) && !is_bool($updateStatusForAdGroups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateStatusForAdGroups, true), gettype($updateStatusForAdGroups)), __LINE__);
        }
        if (is_null($updateStatusForAdGroups) || (is_array($updateStatusForAdGroups) && empty($updateStatusForAdGroups))) {
            unset($this->UpdateStatusForAdGroups);
        } else {
            $this->UpdateStatusForAdGroups = $updateStatusForAdGroups;
        }
        return $this;
    }
    /**
     * Get UpdateStatusForAds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateStatusForAds()
    {
        return isset($this->UpdateStatusForAds) ? $this->UpdateStatusForAds : null;
    }
    /**
     * Set UpdateStatusForAds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateStatusForAds
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateStatusForAds($updateStatusForAds = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateStatusForAds) && !is_bool($updateStatusForAds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateStatusForAds, true), gettype($updateStatusForAds)), __LINE__);
        }
        if (is_null($updateStatusForAds) || (is_array($updateStatusForAds) && empty($updateStatusForAds))) {
            unset($this->UpdateStatusForAds);
        } else {
            $this->UpdateStatusForAds = $updateStatusForAds;
        }
        return $this;
    }
    /**
     * Get UpdateStatusForCampaigns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateStatusForCampaigns()
    {
        return isset($this->UpdateStatusForCampaigns) ? $this->UpdateStatusForCampaigns : null;
    }
    /**
     * Set UpdateStatusForCampaigns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateStatusForCampaigns
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateStatusForCampaigns($updateStatusForCampaigns = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateStatusForCampaigns) && !is_bool($updateStatusForCampaigns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateStatusForCampaigns, true), gettype($updateStatusForCampaigns)), __LINE__);
        }
        if (is_null($updateStatusForCampaigns) || (is_array($updateStatusForCampaigns) && empty($updateStatusForCampaigns))) {
            unset($this->UpdateStatusForCampaigns);
        } else {
            $this->UpdateStatusForCampaigns = $updateStatusForCampaigns;
        }
        return $this;
    }
    /**
     * Get UpdateStatusForKeywords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateStatusForKeywords()
    {
        return isset($this->UpdateStatusForKeywords) ? $this->UpdateStatusForKeywords : null;
    }
    /**
     * Set UpdateStatusForKeywords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateStatusForKeywords
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateStatusForKeywords($updateStatusForKeywords = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateStatusForKeywords) && !is_bool($updateStatusForKeywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateStatusForKeywords, true), gettype($updateStatusForKeywords)), __LINE__);
        }
        if (is_null($updateStatusForKeywords) || (is_array($updateStatusForKeywords) && empty($updateStatusForKeywords))) {
            unset($this->UpdateStatusForKeywords);
        } else {
            $this->UpdateStatusForKeywords = $updateStatusForKeywords;
        }
        return $this;
    }
    /**
     * Get UpdateStructuredSnippetAdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateStructuredSnippetAdExtensions()
    {
        return isset($this->UpdateStructuredSnippetAdExtensions) ? $this->UpdateStructuredSnippetAdExtensions : null;
    }
    /**
     * Set UpdateStructuredSnippetAdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateStructuredSnippetAdExtensions
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateStructuredSnippetAdExtensions($updateStructuredSnippetAdExtensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateStructuredSnippetAdExtensions) && !is_bool($updateStructuredSnippetAdExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateStructuredSnippetAdExtensions, true), gettype($updateStructuredSnippetAdExtensions)), __LINE__);
        }
        if (is_null($updateStructuredSnippetAdExtensions) || (is_array($updateStructuredSnippetAdExtensions) && empty($updateStructuredSnippetAdExtensions))) {
            unset($this->UpdateStructuredSnippetAdExtensions);
        } else {
            $this->UpdateStructuredSnippetAdExtensions = $updateStructuredSnippetAdExtensions;
        }
        return $this;
    }
    /**
     * Get UpdateUrlOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateUrlOptions()
    {
        return isset($this->UpdateUrlOptions) ? $this->UpdateUrlOptions : null;
    }
    /**
     * Set UpdateUrlOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateUrlOptions
     * @return \StructType\GoogleImportOption
     */
    public function setUpdateUrlOptions($updateUrlOptions = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateUrlOptions) && !is_bool($updateUrlOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateUrlOptions, true), gettype($updateUrlOptions)), __LINE__);
        }
        if (is_null($updateUrlOptions) || (is_array($updateUrlOptions) && empty($updateUrlOptions))) {
            unset($this->UpdateUrlOptions);
        } else {
            $this->UpdateUrlOptions = $updateUrlOptions;
        }
        return $this;
    }
}
